/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.util.HashMap;
import org.eclipse.core.internal.resources.semantic.ISemanticContentProviderFactory;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFileSystemCore
implements IRegistryChangeListener {
    private static final String INVALID_CONTENT_PROVIDER = "org.eclipse.core.resources.semantic.provider.InvalidContentProvider";
    private static final String PI_CONTENT_PROVIDER = "contentProvider";
    private static final String EMPTY = "";
    private static final SemanticFileSystemCore INSTANCE = new SemanticFileSystemCore();
    private HashMap<String, IConfigurationElement> contentProviders;

    public static SemanticFileSystemCore getInstance() {
        return INSTANCE;
    }

    private SemanticFileSystemCore() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] changes = event.getExtensionDeltas("org.eclipse.core.resources.semantic", PI_CONTENT_PROVIDER);
        if (changes.length == 0) {
            return;
        }
        SemanticFileSystemCore semanticFileSystemCore = this;
        synchronized (semanticFileSystemCore) {
            this.contentProviders = null;
        }
    }

    public ISemanticContentProviderFactory getContentProviderFactory(final String contentProviderID) {
        return new ISemanticContentProviderFactory(){

            public ISemanticContentProvider createContentProvider() throws CoreException {
                int i = 0;
                while (i < 3) {
                    try {
                        return this.toProvider(this.getConfigurationElement());
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                        ++i;
                    }
                }
                return this.toProvider(this.getConfigurationElement());
            }

            private IConfigurationElement getConfigurationElement() throws CoreException {
                HashMap<String, IConfigurationElement> registry = SemanticFileSystemCore.this.getContentProviderRegistry();
                IConfigurationElement element = registry.get(contentProviderID);
                if (element == null && (element = registry.get(SemanticFileSystemCore.INVALID_CONTENT_PROVIDER)) == null) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.UNKNOWN_CONTENT_PROVIDER_ID, (IPath)new Path(SemanticFileSystemCore.EMPTY), NLS.bind((String)Messages.SemanticFileSystemCore_TemplateIdNotFound_XMSG, (Object)SemanticFileSystemCore.INVALID_CONTENT_PROVIDER));
                }
                return element;
            }

            private ISemanticContentProvider toProvider(IConfigurationElement element) throws CoreException {
                ISemanticContentProvider provider = (ISemanticContentProvider)element.createExecutableExtension("class");
                return provider;
            }
        };
    }

    synchronized HashMap<String, IConfigurationElement> getContentProviderRegistry() {
        if (this.contentProviders == null) {
            this.contentProviders = new HashMap();
            IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.resources.semantic", PI_CONTENT_PROVIDER);
            IExtension[] exts = extensionPoint.getExtensions();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elements = exts[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String contentProviderID;
                    if (PI_CONTENT_PROVIDER.equals(elements[j].getName()) && (contentProviderID = elements[j].getAttribute("id")) != null) {
                        this.contentProviders.put(contentProviderID, elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.contentProviders;
    }
}

