/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.provisional.bind.IModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.TwoWayBinding;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoWayValidationBinding<T>
extends TwoWayBinding<T>
implements ITargetBinding<T> {
    private final IModelBinding<T> modelBinding;
    private final IValidator<T> validator;

    public TwoWayValidationBinding(IModelBinding<T> modelBinding, IValidator<T> validator, boolean pullInitialValue) {
        super(pullInitialValue);
        this.modelBinding = modelBinding;
        this.validator = validator;
    }

    @Override
    public T getModelValue() {
        return this.modelBinding.getModelValue();
    }

    @Override
    public void setModelValue(T valueOnTargetSide) {
        IStatus status = this.validator.validate(valueOnTargetSide);
        this.targetBinding.setStatus(status);
        if (status.getSeverity() >= 2) {
            this.modelBinding.setModelValue(valueOnTargetSide);
        }
    }

    @Override
    public void setTargetValue(T valueOnModelSide) {
        this.targetBinding.setTargetValue(valueOnModelSide);
    }

    @Override
    public void setStatus(IStatus status) {
        this.targetBinding.setStatus(status);
    }

    @Override
    public void removeModelListener() {
        this.modelBinding.removeModelListener();
    }
}

