/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.util.LinkedList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ListenerListCopy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableValue<T>
extends AbstractObservableValue<T> {
    private final Object valueType;
    private T value = null;
    private boolean isFiring = false;
    private LinkedList<QueuedEvent<T>> eventQueue = new LinkedList();

    public WritableValue() {
        this(null, null);
    }

    public WritableValue(T initialValue, Object valueType) {
        this(new Realm(){

            public boolean isCurrent() {
                return true;
            }
        }, initialValue, valueType);
    }

    public WritableValue(Realm realm) {
        this(realm, null, null);
    }

    public WritableValue(Realm realm, T initialValue, Object valueType) {
        super(realm);
        this.valueType = valueType;
        this.value = initialValue;
    }

    @Override
    public T doGetValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void doSetValue(T value) {
        myOueuedEvent = null;
        var3_3 = this;
        synchronized (var3_3) {
            if (value != this.value) {
                oldValue = this.value;
                this.value = value;
                if (this.genericListenerList != null && !this.genericListenerList.isEmpty() || this.valueListenerList != null && !this.valueListenerList.isEmpty()) {
                    if (!this.isFiring) {
                        myOueuedEvent = new QueuedEvent<T>(Diffs.createValueDiff(oldValue, value), this.genericListenerList == null ? null : this.genericListenerList.getReadOnlyCopy(), this.valueListenerList == null ? null : this.valueListenerList.getReadOnlyCopy());
                        this.isFiring = true;
                    } else if (this.eventQueue.isEmpty()) {
                        queuedEvent = new QueuedEvent<T>(Diffs.createValueDiff(oldValue, value), this.genericListenerList == null ? null : this.genericListenerList.getReadOnlyCopy(), this.valueListenerList == null ? null : this.valueListenerList.getReadOnlyCopy());
                        this.eventQueue.addLast(queuedEvent);
                    } else {
                        lastEvent = this.eventQueue.getLast();
                        if (this.isIdentical(lastEvent.genericListenerList, this.genericListenerList) && this.isIdentical(lastEvent.valueListenerList, this.valueListenerList)) {
                            lastEvent.diff = Diffs.createValueDiff(lastEvent.diff.getOldValue(), value);
                        } else {
                            queuedEvent = new QueuedEvent<T>(Diffs.createValueDiff(oldValue, value), this.genericListenerList == null ? null : this.genericListenerList.getReadOnlyCopy(), this.valueListenerList == null ? null : this.valueListenerList.getReadOnlyCopy());
                            this.eventQueue.addLast(queuedEvent);
                        }
                    }
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl43
        }
        do {
            if (myOueuedEvent.genericListenerList != null) {
                myOueuedEvent.genericListenerList.fireEvent(new ChangeEvent(this));
            }
            if (myOueuedEvent.valueListenerList != null) {
                myOueuedEvent.valueListenerList.fireEvent(new ValueChangeEvent<T>(this, myOueuedEvent.diff));
            }
            var3_3 = this;
            synchronized (var3_3) {
                if (this.eventQueue.isEmpty()) {
                    myOueuedEvent = null;
                    this.isFiring = false;
                } else {
                    myOueuedEvent = this.eventQueue.removeFirst();
                }
            }
lbl43:
            // 3 sources

        } while (myOueuedEvent != null);
    }

    private <L extends IObservablesListener<L>> boolean isIdentical(ListenerListCopy<L> listenerList1, ListenerList<L> listenerList2) {
        if (listenerList1 == null) {
            return listenerList2 == null;
        }
        if (listenerList2 == null) {
            return false;
        }
        return listenerList1.isIdenticalTo(listenerList2);
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    public synchronized T addListenerAndGetValue(IValueChangeListener<T> listener) {
        this.addValueChangeListener(listener);
        return this.doGetValue();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        T value = this.doGetValue();
        buffer.append(value == null ? "null" : value.toString());
        if (this.isStale()) {
            buffer.append("(stale)");
        }
        if (this.isDisposed()) {
            buffer.append("(disposed)");
        }
        return buffer.toString();
    }

    public static <T2> WritableValue<T2> withValueType(Object elementType) {
        return new WritableValue<Object>(Realm.getDefault(), null, elementType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueuedEvent<T> {
        public ValueDiff<T> diff;
        public final ListenerListCopy<IChangeListener> genericListenerList;
        public final ListenerListCopy<IValueChangeListener<T>> valueListenerList;

        QueuedEvent(ValueDiff<T> diff, ListenerListCopy<IChangeListener> genericChangeListeners, ListenerListCopy<IValueChangeListener<T>> valueChangeListeners) {
            this.diff = diff;
            this.genericListenerList = genericChangeListeners;
            this.valueListenerList = valueChangeListeners;
        }
    }
}

