/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.property.IProperty;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.jmock.core.Constraint;

public abstract class AttributeContractTests<T, A>
extends MockObjectTestCase {
    private IProperty<T> target;
    Mock<IPropertyAttributeListener<A>> mockListener;

    protected abstract IProperty<T> newTarget();

    protected abstract A newNonDefaultAttributeValue();

    protected abstract A newAttributeDifferentThen(A var1);

    protected abstract A getAttributeValue(IProperty<T> var1);

    protected abstract void setAttributeValue(IProperty<T> var1, A var2);

    protected abstract void registerAttributeListener(IProperty<T> var1, IPropertyAttributeListener<A> var2, boolean var3);

    protected abstract boolean removeAttributeListener(IProperty<T> var1, IPropertyAttributeListener<A> var2);

    protected abstract A getDefaultValue();

    public void setUp() {
        this.setTarget(this.newTarget());
        this.mockListener = this.mock(IPropertyAttributeListener.class);
    }

    public void test_defaultAttribute() {
        AttributeContractTests.assertEquals(this.getDefaultValue(), this.getAttributeValue(this.target()));
    }

    public void test_getSetAttribute() {
        A oldValue = this.getAttributeValue(this.target());
        A newValue = this.newAttributeDifferentThen(oldValue);
        this.setAttributeValue(this.target(), newValue);
        AttributeContractTests.assertEquals(newValue, this.getAttributeValue(this.target()));
    }

    public void test_registerListenerNotifiesForCurrentAttribute() {
        this.mockListener.expects(this.once()).method("attributeChanged").with(new Constraint(){

            public boolean eval(Object arg0) {
                PropertyAttributeChangedEvent ace = (PropertyAttributeChangedEvent)arg0;
                AttributeContractTests.assertEquals((String)"Current access state differs from old access state", (Object)ace.getNewAttribute(), (Object)ace.getOldAttribute());
                AttributeContractTests.assertEquals((String)"Current access state reported by the event differs from the notifying property current access state", AttributeContractTests.this.getAttributeValue(AttributeContractTests.this.target()), (Object)ace.getNewAttribute());
                AttributeContractTests.assertTrue((String)"The event reported that it was not a notification for the current state altought the current and old state were equal", (boolean)ace.isCurrent());
                AttributeContractTests.assertEquals((String)"Notifier reported by the event was not the one used in the test", AttributeContractTests.this.target(), (Object)ace.getNotifier());
                return true;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                arg0.append("AccessChandedEvent delivered as current state notification");
                return arg0;
            }
        });
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), true);
    }

    public void test_registerListenerDoesntNotofyForCurrentAttribute() {
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), false);
    }

    public void test_listenerGetsNotifiedUpponAttributeChange() {
        A oldValue = this.getAttributeValue(this.target());
        A newValue = this.newAttributeDifferentThen(oldValue);
        this.mockListener.expects(this.once()).method("attributeChanged").with((Constraint)new PropertyAttributeChangedEventConstraint(this.target(), oldValue, newValue));
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), false);
        this.setAttributeValue(this.target(), newValue);
    }

    public void test_moreThenOneListenerCouldBeAdded() {
        A oldAttribute = this.getAttributeValue(this.target());
        A newAttribute = this.newAttributeDifferentThen(oldAttribute);
        PropertyAttributeChangedEventConstraint rightEvent = new PropertyAttributeChangedEventConstraint(this.target(), oldAttribute, newAttribute);
        this.mockListener.expects(this.once()).method("attributeChanged").with((Constraint)rightEvent);
        Mock secondMockListener = this.mock(IPropertyAttributeListener.class);
        secondMockListener.expects(this.once()).method("attributeChanged").with((Constraint)rightEvent);
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), false);
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)secondMockListener.proxy(), false);
        this.setAttributeValue(this.target(), newAttribute);
    }

    public void test_noNotificationIfNewAttributeIsTheSameAsCurrent() {
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), false);
        this.setAttributeValue(this.target(), this.getAttributeValue(this.target()));
    }

    public void test_removeListenerReturnsFalseIfNotRegistered() {
        AttributeContractTests.assertFalse((boolean)this.removeAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy()));
    }

    public void test_removeListenerReturnsTrueIfRegistered() {
        this.registerAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy(), false);
        AttributeContractTests.assertTrue((boolean)this.removeAttributeListener(this.target(), (IPropertyAttributeListener)this.mockListener.proxy()));
    }

    public void test_ValueChangedBeforeValueListenerNotified() {
        final Property testProperty = new Property();
        testProperty.set((Object)"OldValue");
        testProperty.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<String>(){

            public void attributeChanged(PropertyAttributeChangedEvent<String> event) {
                AttributeContractTests.assertTrue((boolean)((String)testProperty.get()).equals("NewValue"));
            }
        }, false);
        testProperty.set((Object)"NewValue");
    }

    public void tearDown() {
    }

    protected void setTarget(IProperty<T> target) {
        this.target = target;
    }

    protected IProperty<T> target() {
        return this.target;
    }

    private class PropertyAttributeChangedEventConstraint
    implements Constraint {
        private final A oldAttribute;
        private final A newAttribute;
        private final IProperty<T> notifier;

        public PropertyAttributeChangedEventConstraint(IProperty<T> notifier, A oldAttribute, A newAttribute) {
            this.oldAttribute = oldAttribute;
            this.newAttribute = newAttribute;
            this.notifier = notifier;
        }

        public boolean eval(Object arg0) {
            PropertyAttributeChangedEvent ace = (PropertyAttributeChangedEvent)arg0;
            AttributeContractTests.assertEquals((String)"New attribute value reported by the event was not the set one", this.newAttribute, (Object)ace.getNewAttribute());
            AttributeContractTests.assertEquals((String)("Old attribute value reported by the event was not the " + this.oldAttribute), this.oldAttribute, (Object)ace.getOldAttribute());
            AttributeContractTests.assertSame((String)"Notifier reported by the event was not the one used in the test", this.notifier, (Object)ace.getNotifier());
            AttributeContractTests.assertFalse((String)"isCurrent was true although this was not current attribute value event uppon listener registration", (boolean)ace.isCurrent());
            return true;
        }

        public StringBuffer describeTo(StringBuffer arg0) {
            arg0.append("Attribute changed to " + this.newAttribute);
            return arg0;
        }
    }
}

