/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.HashSet;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.ui.api.ISearchParametersUI;
import org.eclipse.platform.discovery.ui.internal.selector.SubdestinationsSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SubdestinationsSelectedListener
implements SelectionListener,
Listener {
    private final Control parentControl;
    private final ISearchParametersUI.IConsoleContext consoleContext;

    public SubdestinationsSelectedListener(Control parentControl, ISearchParametersUI.IConsoleContext consoleContext) {
        this.parentControl = parentControl;
        this.consoleContext = consoleContext;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        List subDestinations = this.consoleContext.searchProviderConfiguration().getAvailableSearchSubdestinations(this.consoleContext.selectedObjectType(), this.consoleContext.destinationCategory(), this.consoleContext.searchProvider());
        Point showPoint = new Point(event.x, event.y + this.parentControl.getSize().y);
        SubdestinationsSelector selector = new SubdestinationsSelector(this.parentControl, 0, subDestinations, showPoint){

            public void handleSelection(ISearchSubdestination item, boolean selected) {
                SubdestinationsSelectedListener.this.consoleContext.searchProviderConfiguration().activateSubdestination(SubdestinationsSelectedListener.this.consoleContext.selectedObjectType(), SubdestinationsSelectedListener.this.consoleContext.destinationCategory(), SubdestinationsSelectedListener.this.consoleContext.searchProvider(), item, selected);
                if (selected) {
                    HashSet<ISearchSubdestination> inactive = new HashSet<ISearchSubdestination>();
                    for (ISearchSubdestination curr : SubdestinationsSelectedListener.this.consoleContext.searchProviderConfiguration().getAvailableSearchSubdestinations(SubdestinationsSelectedListener.this.consoleContext.selectedObjectType(), SubdestinationsSelectedListener.this.consoleContext.destinationCategory(), SubdestinationsSelectedListener.this.consoleContext.searchProvider())) {
                        if (this.isSubdestinationActive(curr)) continue;
                        inactive.add(curr);
                    }
                    HashSet<ISearchSubdestination> deactivated = new HashSet<ISearchSubdestination>();
                    for (ISearchSubdestination curr : SubdestinationsSelectedListener.this.consoleContext.searchProviderConfiguration().getAvailableSearchSubdestinations(SubdestinationsSelectedListener.this.consoleContext.selectedObjectType(), SubdestinationsSelectedListener.this.consoleContext.destinationCategory(), SubdestinationsSelectedListener.this.consoleContext.searchProvider())) {
                        if (this.isSubdestinationActive(curr) || inactive.contains(curr)) continue;
                        deactivated.add(curr);
                    }
                    for (ISearchSubdestination subd : deactivated) {
                        SubdestinationsSelectedListener.this.consoleContext.notifySubdestinationActivationChange(subd, false);
                    }
                }
                SubdestinationsSelectedListener.this.consoleContext.notifySubdestinationActivationChange(item, selected);
            }

            @Override
            protected boolean isSubdestinationActive(ISearchSubdestination subdestination) {
                return SubdestinationsSelectedListener.this.consoleContext.searchProviderConfiguration().isSubdestinationActive(subdestination, SubdestinationsSelectedListener.this.consoleContext.selectedObjectType(), SubdestinationsSelectedListener.this.consoleContext.destinationCategory(), SubdestinationsSelectedListener.this.consoleContext.searchProvider());
            }
        };
        try {
            selector.select();
        }
        finally {
            selector.dispose();
        }
    }

    public void handleEvent(Event event) {
        SelectionEvent selectionEvent = new SelectionEvent(event);
        this.widgetSelected(selectionEvent);
    }
}

