/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.ContextStructuredSelection;
import org.eclipse.platform.discovery.core.internal.IContextStructuredSelection;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.test.comp.internal.fixture.SearchConsoleTestFixture;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SearchFavoritesPageObject;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SearchFavoritesViewTest {
    private static SearchConsoleTestFixture fixture;
    private ISearchFavoritesViewCustomization viewCustomization;
    private ITreeContentProvider dragHelperViewerContentProvider;
    private ITreeContentProvider favoritesContentProvider;
    private ILabelProvider labelProvider;
    private Object favoritesItemSource;
    private Object firstFavoriteItem;
    private Object secondFavoriteItem;
    private Object favoritesGroup;
    private SearchFavoritesPageObject searchFavorites;
    private IDiscoveryEnvironment environment;

    @BeforeClass
    public static void initFixture() {
        fixture = new SearchConsoleTestFixture();
    }

    @Before
    public void setUp() {
        this.favoritesItemSource = new String("favoritesItemSource");
        this.firstFavoriteItem = new String("firstFavoriteItem");
        this.secondFavoriteItem = new String("secondFavoriteItem");
        this.favoritesGroup = new String("favoritesGroup");
        this.setupContentProvider();
        this.setupLabelProvider();
        this.setupViewCustomization();
        this.environment = SearchFavoritesViewTest.fixture.environment;
        this.searchFavorites = new SearchFavoritesPageObject(this.viewCustomization, this.dragHelperViewerContentProvider, this.environment);
        this.searchFavorites.open();
    }

    @After
    public void tearDown() {
        this.searchFavorites.close();
    }

    private void setupLabelProvider() {
        this.labelProvider = (ILabelProvider)Mockito.mock(ILabelProvider.class);
        Mockito.stub((Object)this.labelProvider.getText(Mockito.any())).toAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getArguments()[0].toString();
            }
        });
    }

    private void setupContentProvider() {
        this.favoritesContentProvider = (ITreeContentProvider)Mockito.mock(ITreeContentProvider.class);
        Mockito.stub((Object)this.favoritesContentProvider.getChildren(Mockito.any())).toReturn((Object)new Object[0]);
        Mockito.stub((Object)this.favoritesContentProvider.getParent(Mockito.any())).toReturn(null);
        Mockito.stub((Object)this.favoritesContentProvider.hasChildren(Mockito.any())).toReturn((Object)false);
        this.dragHelperViewerContentProvider = (ITreeContentProvider)Mockito.mock(ITreeContentProvider.class);
        Mockito.stub((Object)this.dragHelperViewerContentProvider.getChildren(Mockito.any())).toReturn((Object)new Object[0]);
        Mockito.stub((Object)this.dragHelperViewerContentProvider.getParent(Mockito.any())).toReturn(null);
        Mockito.stub((Object)this.dragHelperViewerContentProvider.hasChildren(Mockito.any())).toReturn((Object)false);
        Mockito.stub((Object)this.dragHelperViewerContentProvider.getElements(Mockito.any())).toReturn((Object)new Object[]{this.firstFavoriteItem, this.secondFavoriteItem});
    }

    private void setupViewCustomization() {
        this.viewCustomization = (ISearchFavoritesViewCustomization)Mockito.mock(ISearchFavoritesViewCustomization.class);
        Mockito.stub((Object)this.viewCustomization.getContentProvider()).toReturn((Object)this.favoritesContentProvider);
        Mockito.stub((Object)this.viewCustomization.getLabelProvider()).toReturn((Object)this.labelProvider);
        Mockito.stub((Object)this.viewCustomization.itemGroup(Mockito.any())).toReturn(this.favoritesGroup);
        Mockito.stub((Object)this.viewCustomization.itemsFor(Mockito.any())).toAnswer((Answer)new Answer<Set<Object>>(){

            public Set<Object> answer(InvocationOnMock invocation) throws Throwable {
                Object biSrc = invocation.getArguments()[0];
                if (biSrc == SearchFavoritesViewTest.this.favoritesItemSource) {
                    return new HashSet<Object>(Arrays.asList(SearchFavoritesViewTest.this.firstFavoriteItem, SearchFavoritesViewTest.this.secondFavoriteItem));
                }
                return new HashSet<Object>(Arrays.asList(biSrc));
            }
        });
    }

    @Test
    public void testViewIsBusyWhenOpened() {
        Assert.assertTrue((String)"Operation is not running", (boolean)this.searchFavorites.isOperationRunning());
        this.searchFavorites.completeInitialization();
        Assert.assertFalse((String)"Operation is still running", (boolean)this.searchFavorites.isOperationRunning());
    }

    @Test
    public void testDragToFavorites() {
        this.searchFavorites.registerController(new FavoritesController());
        this.searchFavorites.dragToFavorites(this.firstFavoriteItem);
        Assert.assertTrue((String)"Grouping item not displayed", (boolean)this.searchFavorites.isFavoritesRootItemDisplayed(this.favoritesGroup));
        Assert.assertTrue((String)"First favorite item not displayed", (boolean)this.searchFavorites.isFavoritesItemDisplayed(this.firstFavoriteItem, this.favoritesGroup));
    }

    @Test
    public void testDragFromFavorites() {
        this.searchFavorites.registerController(new FavoritesController());
        HashSet<Object> favoritesToShow = new HashSet<Object>();
        favoritesToShow.add(this.firstFavoriteItem);
        this.searchFavorites.showFavorites(favoritesToShow);
        final ArrayList droppedObjects = new ArrayList();
        this.searchFavorites.getDragHelper().addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    IStructuredSelection sel = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                    Iterator it = sel.iterator();
                    while (it.hasNext()) {
                        droppedObjects.add(it.next());
                    }
                }
            }
        });
        this.searchFavorites.dragFromFavorites(this.favoritesGroup, this.firstFavoriteItem);
        Assert.assertEquals((String)"One dropped item expected", (int)1, (int)droppedObjects.size());
        Assert.assertEquals((String)"Unexpected item dropped", (Object)this.firstFavoriteItem, droppedObjects.iterator().next());
    }

    private class FavoritesController
    implements ISearchFavoritesMasterController {
        private FavoritesController() {
        }

        public IDiscoveryEnvironment getEnvironment() {
            return SearchFavoritesViewTest.this.environment;
        }

        public void deleteItems(Set<Object> data) {
        }

        public void importData(Object data) {
            Assert.assertTrue((boolean)(data instanceof IContextStructuredSelection));
            ContextStructuredSelection selection = (ContextStructuredSelection)data;
            HashSet<Object> affectedObjects = new HashSet<Object>();
            affectedObjects.addAll(selection.toList());
            SearchFavoritesViewTest.this.searchFavorites.showFavorites(affectedObjects);
        }

        public boolean isImportPossible(Object data) {
            return true;
        }
    }
}

