/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.testutils.internal.plugin;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TestPlugin
extends AbstractUIPlugin {
    private static TestPlugin INSTANCE;
    private static String pluginId;

    public TestPlugin() {
        INSTANCE = this;
    }

    public static TestPlugin getDefault() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        pluginId = context.getBundle().getSymbolicName();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
    }

    public static void logError(Throwable e) {
        TestPlugin.getDefault().getLog().log(TestPlugin.createStatus(4, e, e.getMessage()));
    }

    public static void logError(String message, Throwable e) {
        TestPlugin.getDefault().getLog().log(TestPlugin.createStatus(4, e, message));
    }

    public static void logWarning(String string) {
        TestPlugin.getDefault().getLog().log(TestPlugin.createStatus(2, string));
    }

    public static void logInfo(String string) {
        TestPlugin.getDefault().getLog().log(TestPlugin.createStatus(1, string));
    }

    private static IStatus createStatus(int severity, Throwable cause, String message) {
        return new Status(severity, pluginId, message, cause);
    }

    private static IStatus createStatus(int severity, String message) {
        return new Status(severity, pluginId, message);
    }
}

