/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.test.unit.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.integration.internal.plugin.DiscoveryIntegrationMessages;
import org.eclipse.platform.discovery.integration.internal.plugin.IViewCustomizationConfiguration;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.IActionWithAvailability;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesViewCustomization;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jmock.core.Constraint;

public class SaveInFavoritesViewCustomizationTest
extends MockObjectTestCase {
    private SaveInFavoritesViewCustomization customization;
    private Mock<IMasterDiscoveryView> masterView;
    private Mock<IContributedAction> contributedAction;
    private TreeViewer treeViewer;
    private Mock<ISelection> viewerSelection;
    private Mock<ISearchContext> searchContext;
    private Mock<IViewCustomizationConfiguration> viewCustomizationConfig;
    private Mock<ISearchFavoritesViewCustomization> favoritesCustomization;
    private Mock<IActionWithAvailability> menuAction;
    private Mock<IDiscoveryEnvironment> environment;
    private Mock<IResultsViewAccessor> viewAccessor;
    private Mock<IMenuManager> menuManager;

    protected void setUp() throws Exception {
        this.contributedAction = this.mock(IContributedAction.class);
        this.menuAction = this.mock(IActionWithAvailability.class);
        this.environment = this.mock(IDiscoveryEnvironment.class);
        this.masterView = this.mock(IMasterDiscoveryView.class);
        this.masterView.stubs().method("getEnvironment").will(this.returnValue(this.environment.proxy()));
        this.setupViewAccessor();
        this.favoritesCustomization = this.mock(ISearchFavoritesViewCustomization.class);
        this.viewCustomizationConfig = this.mock(IViewCustomizationConfiguration.class);
        this.viewCustomizationConfig.stubs().method("availableSearchFavoritesCustomizations").will(this.returnValue(Arrays.asList((ISearchFavoritesViewCustomization)this.favoritesCustomization.proxy())));
        this.customization = new SaveInFavoritesViewCustomization(){

            protected IActionWithAvailability createSaveAction(IContributedAction contributedAction, ISelection selection, ISearchContext searchContext, List<ISearchFavoritesViewCustomization> sbCustomizations, IDiscoveryEnvironment environment) {
                SaveInFavoritesViewCustomizationTest.assertTrue((String)"Unexpected action", (contributedAction == SaveInFavoritesViewCustomizationTest.this.contributedAction.proxy() ? 1 : 0) != 0);
                SaveInFavoritesViewCustomizationTest.assertTrue((String)"Unexpcted selection", (selection == SaveInFavoritesViewCustomizationTest.this.viewerSelection.proxy() ? 1 : 0) != 0);
                SaveInFavoritesViewCustomizationTest.assertTrue((String)"Unexpected environment", (environment == SaveInFavoritesViewCustomizationTest.this.environment.proxy() ? 1 : 0) != 0);
                SaveInFavoritesViewCustomizationTest.assertEquals((String)"One customization expected", (int)1, (int)sbCustomizations.size());
                SaveInFavoritesViewCustomizationTest.assertTrue((String)"Test customization not found", (boolean)sbCustomizations.contains(SaveInFavoritesViewCustomizationTest.this.favoritesCustomization.proxy()));
                return (IActionWithAvailability)SaveInFavoritesViewCustomizationTest.this.menuAction.proxy();
            }

            protected IViewCustomizationConfiguration viewCustomizationConfiguration() {
                return (IViewCustomizationConfiguration)SaveInFavoritesViewCustomizationTest.this.viewCustomizationConfig.proxy();
            }
        };
        this.customization.setMasterView((IMasterDiscoveryView)this.masterView.proxy());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.treeViewer.getControl().getParent().dispose();
    }

    private void setupViewAccessor() {
        this.viewerSelection = this.mock(ISelection.class);
        this.searchContext = this.mock(ISearchContext.class);
        Shell s = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.treeViewer = new DummyTreeViewer((Composite)s, (ISelection)this.viewerSelection.proxy(), this.searchContext.proxy());
        this.viewAccessor = this.mock(IResultsViewAccessor.class);
        this.viewAccessor.stubs().method("getTreeViewer").will(this.returnValue(this.treeViewer));
        this.menuManager = this.mock(IMenuManager.class);
        this.viewAccessor.stubs().method("getMenuManager").will(this.returnValue(this.menuManager.proxy()));
    }

    public void testAcceptSearchProvider() {
        SaveInFavoritesViewCustomizationTest.assertTrue((boolean)this.customization.acceptSearchProvider("A"));
        SaveInFavoritesViewCustomizationTest.assertTrue((boolean)this.customization.acceptSearchProvider(null));
    }

    public void testInstallActionWithUnknownId() {
        this.contributedAction.stubs().method("getActionId").will(this.returnValue("unknown"));
        this.customization.installAction((IContributedAction)this.contributedAction.proxy(), (IResultsViewAccessor)this.viewAccessor.proxy());
    }

    public void testInstallActionWhenNotAvailable() {
        this.contributedAction.stubs().method("getActionId").will(this.returnValue("org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesContributedAction"));
        this.menuAction.expects(this.once()).method("isAvailable").will(this.returnValue(false));
        this.customization.installAction((IContributedAction)this.contributedAction.proxy(), (IResultsViewAccessor)this.viewAccessor.proxy());
    }

    public void testInstallAction() {
        this.contributedAction.stubs().method("getActionId").will(this.returnValue("org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesContributedAction"));
        this.menuAction.expects(this.once()).method("setText").with((Constraint)this.eq(DiscoveryIntegrationMessages.SaveInSearchFavoritesAction_Text));
        this.menuAction.expects(this.once()).method("isAvailable").will(this.returnValue(true));
        this.menuManager.expects(this.once()).method("add").with((Constraint)this.eq(this.menuAction.proxy()));
        this.customization.installAction((IContributedAction)this.contributedAction.proxy(), (IResultsViewAccessor)this.viewAccessor.proxy());
    }

    private class DummyTreeViewer
    extends TreeViewer {
        private final ISelection selection;
        private final Object input;

        public DummyTreeViewer(Composite parent, ISelection selection, Object input) {
            super(parent);
            this.selection = selection;
            this.input = input;
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public Object getInput() {
            return this.input;
        }
    }
}

