/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import junit.framework.TestCase;
import org.eclipse.e4.internal.languages.javascript.JSImportPackage;
import org.eclipse.e4.internal.languages.javascript.JSVersionRange;

public class JSImportTest
extends TestCase {
    public JSImportTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNullHeader() {
        try {
            new JSImportPackage(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSImportTest.fail();
    }

    public void testNameAndEmptyVersionRange() {
        JSImportPackage jsImport = new JSImportPackage("a.a");
        JSImportTest.assertEquals((String)"a.a", (String)jsImport.getName());
        JSImportTest.assertEquals((Object)JSVersionRange.emptyRange, (Object)jsImport.getVersionRange());
        JSImportTest.assertEquals(null, (String)jsImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)JSVersionRange.emptyRange, (Object)jsImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)0, (int)jsImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jsImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jsImport.isOptional());
    }

    public void testNameAndVersion() {
        JSImportPackage jsImport = new JSImportPackage("a.a;version=1.2.1");
        JSImportTest.assertEquals((String)"a.a", (String)jsImport.getName());
        JSImportTest.assertEquals((Object)new JSVersionRange("1.2.1"), (Object)jsImport.getVersionRange());
        JSImportTest.assertEquals(null, (String)jsImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)JSVersionRange.emptyRange, (Object)jsImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)1, (int)jsImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jsImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jsImport.isOptional());
    }

    public void testBundleNameAndVersion() {
        JSImportPackage jsImport = new JSImportPackage("a.a;version=1.2.1;bundle-symbolic-name=test1;bundle-version=1.8");
        JSImportTest.assertEquals((String)"a.a", (String)jsImport.getName());
        JSImportTest.assertEquals((Object)new JSVersionRange("1.2.1"), (Object)jsImport.getVersionRange());
        JSImportTest.assertEquals((String)"test1", (String)jsImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)new JSVersionRange("1.8"), (Object)jsImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)3, (int)jsImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jsImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jsImport.isOptional());
    }

    public void testIsOptional() {
        JSImportPackage jsImport = new JSImportPackage("a.a;version=1.2.1;bundle-symbolic-name=test1;bundle-version=1.8;resolution:=optional");
        JSImportTest.assertEquals((String)"a.a", (String)jsImport.getName());
        JSImportTest.assertEquals((Object)new JSVersionRange("1.2.1"), (Object)jsImport.getVersionRange());
        JSImportTest.assertEquals((String)"test1", (String)jsImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)new JSVersionRange("1.8"), (Object)jsImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)3, (int)jsImport.getAttributes().size());
        JSImportTest.assertEquals((int)1, (int)jsImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)true, (boolean)jsImport.isOptional());
    }
}

