/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.provisional.bind.IBidiConverter;
import org.eclipse.core.internal.databinding.provisional.bind.IOneWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITwoWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.OneWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.TwoWayBinding;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bind {
    public static <V> IOneWayBinding<V> oneWay(IObservableValue<V> modelObservable) {
        return new OneWayModelBinding<V>(modelObservable, false);
    }

    public static <S, V> IOneWayBinding<V> oneWay(IValueProperty<S, V> modelProperty, S source) {
        IObservableValue modelObservable = modelProperty.observe(source);
        return new OneWayModelBinding(modelObservable, true);
    }

    public static <V> ITwoWayBinding<V> twoWay(IObservableValue<V> modelObservable) {
        return new TwoWayModelBinding<V>(modelObservable, false);
    }

    public static <S, V> ITwoWayBinding<V> twoWay(IValueProperty<S, V> modelProperty, S source) {
        IObservableValue modelObservable = modelProperty.observe(source);
        return new TwoWayModelBinding(modelObservable, true);
    }

    public static <T1, T2> ITwoWayBinding<T2> bounceBack(final IBidiConverter<T1, T2> converter) {
        return new TwoWayBinding<T2>(false){

            @Override
            public T2 getModelValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setModelValue(T2 valueFromTarget) {
                try {
                    Object modelSideValue = converter.targetToModel(valueFromTarget);
                    Object valueBackToTarget = converter.modelToTarget(modelSideValue);
                    this.targetBinding.setTargetValue(valueBackToTarget);
                }
                catch (CoreException coreException) {}
            }

            @Override
            public void removeModelListener() {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OneWayModelBinding<V>
    extends OneWayBinding<V> {
        private final IObservableValue<V> modelObservable;
        private final boolean takeOwnership;
        IValueChangeListener<V> modelListener = new IValueChangeListener<V>(){

            public void handleValueChange(ValueChangeEvent<V> event) {
                OneWayModelBinding.this.targetBinding.setTargetValue(event.diff.getNewValue());
            }
        };

        public OneWayModelBinding(IObservableValue<V> modelObservable, boolean takeOwnership) {
            this.modelObservable = modelObservable;
            this.takeOwnership = takeOwnership;
            modelObservable.addValueChangeListener(this.modelListener);
        }

        @Override
        public V getModelValue() {
            return (V)this.modelObservable.getValue();
        }

        @Override
        public void removeModelListener() {
            this.modelObservable.removeValueChangeListener(this.modelListener);
            if (this.takeOwnership) {
                this.modelObservable.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TwoWayModelBinding<V>
    extends TwoWayBinding<V> {
        private final IObservableValue<V> modelObservable;
        private final boolean takeOwnership;
        private boolean isModelChanging = false;
        IValueChangeListener<V> modelListener = new IValueChangeListener<V>(){

            public void handleValueChange(ValueChangeEvent<V> event) {
                if (!TwoWayModelBinding.this.isModelChanging) {
                    TwoWayModelBinding.this.targetBinding.setTargetValue(event.diff.getNewValue());
                }
            }
        };

        public TwoWayModelBinding(IObservableValue<V> modelObservable, boolean takeOwnership) {
            super(true);
            this.modelObservable = modelObservable;
            this.takeOwnership = takeOwnership;
            modelObservable.addValueChangeListener(this.modelListener);
        }

        @Override
        public V getModelValue() {
            return (V)this.modelObservable.getValue();
        }

        @Override
        public void setModelValue(V newValue) {
            this.isModelChanging = true;
            try {
                this.modelObservable.setValue(newValue);
            }
            finally {
                this.isModelChanging = false;
            }
        }

        @Override
        public void removeModelListener() {
            this.modelObservable.removeValueChangeListener(this.modelListener);
            if (this.takeOwnership) {
                this.modelObservable.dispose();
            }
        }
    }
}

