/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ITooltipProvider;
import org.eclipse.platform.discovery.ui.api.impl.GenericViewCustomizationImpl;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jmock.core.Constraint;

public class GenericResultContentProviderTest
extends MockObjectTestCase {
    private Mock<ITreeContentProvider> contentProvider1;
    private Mock<ITreeContentProvider> contentProvider2;
    private Object element1;
    private Object child1;
    private Object element2;
    private Object child2;
    private Object child3;
    private Set<IGenericViewCustomization> customizations;
    private GenericResultContentProvider testedProvider;

    protected void setUp() throws Exception {
        this.element1 = new Object();
        this.child1 = new Object();
        this.element2 = new Object();
        this.child2 = new Object();
        this.child3 = new Object();
        this.setupContentProviders();
        this.setupCustomizations();
        this.testedProvider = new GenericResultContentProvider(new ArrayList<IGenericViewCustomization>(this.customizations));
    }

    private void setupCustomizations() {
        this.customizations = new HashSet<IGenericViewCustomization>();
        this.customizations.add((IGenericViewCustomization)this.viewCustomizations((ITreeContentProvider)this.contentProvider1.proxy()));
        this.customizations.add((IGenericViewCustomization)this.viewCustomizations((ITreeContentProvider)this.contentProvider2.proxy()));
        this.customizations.add((IGenericViewCustomization)this.viewCustomizations(null));
    }

    final ISearchConsoleCustomization viewCustomizations(final ITreeContentProvider cp) {
        return new TestCustomization(){

            public boolean acceptSearchProvider(String searchProviderId) {
                throw new UnsupportedOperationException();
            }

            public ITreeContentProvider getContentProvider() {
                return cp;
            }

            public ILabelProvider getLabelProvider() {
                throw new UnsupportedOperationException();
            }

            public ITooltipProvider getTooltipProvider() {
                throw new UnsupportedOperationException();
            }

            public void installAction(IContributedAction contributedAction, IResultsViewAccessor viewAccessor) {
                throw new UnsupportedOperationException();
            }

            public void setMasterView(IMasterDiscoveryView masterView) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void setupContentProviders() {
        this.contentProvider1 = this.mock(ITreeContentProvider.class);
        this.contentProvider1.stubs().method("getElements").will(this.returnValue(new Object[]{this.element1}));
        this.contentProvider1.stubs().method("getChildren").with((Constraint)this.eq(this.element1)).will(this.returnValue(new Object[]{this.child1}));
        this.contentProvider1.stubs().method("getChildren").with((Constraint)this.eq(this.child1)).will(this.returnValue(new Object[0]));
        this.contentProvider1.stubs().method("getChildren").with(new Constraint(){

            public boolean eval(Object arg0) {
                return arg0 != GenericResultContentProviderTest.this.element1 && arg0 != GenericResultContentProviderTest.this.child1;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        }).will(this.returnValue(new Object[0]));
        this.contentProvider2 = this.mock(ITreeContentProvider.class);
        this.contentProvider2.stubs().method("getElements").will(this.returnValue(new Object[]{this.element2}));
        this.contentProvider2.stubs().method("getChildren").with((Constraint)this.eq(this.element2)).will(this.returnValue(new Object[]{this.child2, this.child3}));
        this.contentProvider2.stubs().method("getChildren").with((Constraint)this.eq(this.child2)).will(this.returnValue(new Object[0]));
        this.contentProvider2.stubs().method("getChildren").with((Constraint)this.eq(this.child3)).will(this.returnValue(new Object[0]));
        this.contentProvider2.stubs().method("getChildren").with(new Constraint(){

            public boolean eval(Object arg0) {
                return arg0 != GenericResultContentProviderTest.this.element2 && arg0 != GenericResultContentProviderTest.this.child2 && arg0 != GenericResultContentProviderTest.this.child3;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        }).will(this.returnValue(new Object[0]));
    }

    public void testGetElements() {
        Object[] firstChildren = this.testedProvider.getElements(null);
        GenericResultContentProviderTest.assertEquals((String)"Two children expected", (int)2, (int)firstChildren.length);
        HashSet<Object> childrentSet = new HashSet<Object>(Arrays.asList(firstChildren));
        GenericResultContentProviderTest.assertTrue((String)"Element1 not found", (boolean)childrentSet.contains(this.element1));
        GenericResultContentProviderTest.assertTrue((String)"Element2 not found", (boolean)childrentSet.contains(this.element2));
        childrentSet = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.element1)));
        GenericResultContentProviderTest.assertEquals((String)"One child expected", (int)1, (int)childrentSet.size());
        GenericResultContentProviderTest.assertTrue((String)"Child1 not found", (boolean)childrentSet.contains(this.child1));
        childrentSet = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.element2)));
        GenericResultContentProviderTest.assertEquals((String)"Two children expected", (int)2, (int)childrentSet.size());
        GenericResultContentProviderTest.assertTrue((String)"Child2 not found", (boolean)childrentSet.contains(this.child2));
        GenericResultContentProviderTest.assertTrue((String)"Child3 not found", (boolean)childrentSet.contains(this.child3));
    }

    public void testDispose() {
        this.contentProvider1.expects(this.once()).method("dispose");
        this.contentProvider2.expects(this.once()).method("dispose");
        this.testedProvider.dispose();
    }

    public void testInputChanged() {
        Viewer viewer = this.createDummyViewer();
        Object oldInput = new Object();
        Object newInput = new Object();
        this.contentProvider1.expects(this.once()).method("inputChanged").with((Constraint)this.eq(viewer), (Constraint)this.eq(oldInput), (Constraint)this.eq(newInput));
        this.contentProvider2.expects(this.once()).method("inputChanged").with((Constraint)this.eq(viewer), (Constraint)this.eq(oldInput), (Constraint)this.eq(newInput));
        this.testedProvider.inputChanged(viewer, oldInput, newInput);
    }

    private Viewer createDummyViewer() {
        Shell s = new Shell(PlatformUI.getWorkbench().getDisplay());
        return new TextViewer((Composite)s, 0);
    }

    public void testHasChildren() {
        Object object = new Object();
        this.contentProvider1.expects(this.once()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(false));
        this.contentProvider2.expects(this.once()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(false));
        GenericResultContentProviderTest.assertFalse((boolean)this.testedProvider.hasChildren(object));
        this.contentProvider1.reset();
        this.contentProvider2.reset();
        this.contentProvider1.expects(this.atMostOnce()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(true));
        this.contentProvider2.expects(this.atMostOnce()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(false));
        GenericResultContentProviderTest.assertTrue((boolean)this.testedProvider.hasChildren(object));
        this.contentProvider1.reset();
        this.contentProvider2.reset();
        this.contentProvider1.expects(this.atMostOnce()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(false));
        this.contentProvider2.expects(this.atMostOnce()).method("hasChildren").with((Constraint)this.same(object)).will(this.returnValue(true));
        GenericResultContentProviderTest.assertTrue((boolean)this.testedProvider.hasChildren(object));
    }

    private abstract class TestCustomization
    extends GenericViewCustomizationImpl
    implements ISearchConsoleCustomization {
        private TestCustomization() {
        }
    }
}

