/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;

public class SuiteBuilder {
    private LinkedHashSet content = new LinkedHashSet();
    static /* synthetic */ Class class$0;

    public SuiteBuilder addTests(Class testCase) {
        this.content.add(testCase);
        return this;
    }

    public SuiteBuilder addParameterizedTests(Class testCase, Object[] parameters) {
        Constructor constructor = SuiteBuilder.findConstructor(testCase, parameters);
        if (constructor == null) {
            throw new IllegalArgumentException("The parameters provided don't match a constructor found in [" + testCase.getName() + "]");
        }
        this.content.add(new ParameterizedTest(testCase, constructor, parameters));
        return this;
    }

    public SuiteBuilder addObservableContractTest(Class testCase, IObservableContractDelegate delegate) {
        this.addParameterizedTests(testCase, new Object[]{delegate});
        return this;
    }

    public TestSuite build() {
        TestSuite suite = new TestSuite();
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Class) {
                suite.addTestSuite((Class)o);
                continue;
            }
            if (!(o instanceof ParameterizedTest)) continue;
            ParameterizedTest test = (ParameterizedTest)o;
            TestSuite testClassSuite = new TestSuite();
            testClassSuite.setName(test.testClass.getName());
            TestSuite parameterSuite = new TestSuite();
            parameterSuite.setName(test.parameters[0].getClass().getName());
            testClassSuite.addTest((Test)parameterSuite);
            Method[] methods = test.testClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                String name = methods[i].getName();
                if (name.startsWith("test")) {
                    try {
                        parameterSuite.addTest((Test)test.constructor.newInstance(this.toParamArray(name, test.parameters)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
            if (testClassSuite.countTestCases() <= 0) continue;
            suite.addTest((Test)testClassSuite);
        }
        return suite;
    }

    private Object[] toParamArray(String testName, Object[] parameters) {
        Object[] result = new Object[parameters.length + 1];
        result[0] = testName;
        System.arraycopy(parameters, 0, result, 1, parameters.length);
        return result;
    }

    private static Constructor findConstructor(Class clazz, Object[] parameters) {
        Constructor<?>[] constructors = clazz.getConstructors();
        int expectedParametersLength = parameters.length + 1;
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length == expectedParametersLength) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.equals(types[0])) {
                    boolean skip = false;
                    int j = 1;
                    while (j < types.length) {
                        Class<?> type = types[j];
                        if (!type.isInstance(parameters[j - 1])) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                    if (!skip) {
                        return constructor;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    static class ParameterizedTest {
        final Constructor constructor;
        final Object[] parameters;
        private Class testClass;

        ParameterizedTest(Class testClass, Constructor constructor, Object[] parameterss) {
            this.testClass = testClass;
            this.constructor = constructor;
            this.parameters = parameterss;
        }
    }
}

