/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Random;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.MappedSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.examples.databinding.contentprovider.test.SomeMathFunction;
import org.eclipse.jface.internal.databinding.provisional.swt.ControlUpdater;
import org.eclipse.jface.internal.databinding.provisional.viewers.ViewerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StructuredContentProviderTest {
    private static Realm realm;
    private Shell shell;
    protected Random random = new Random();
    private WritableSet inputSet;
    private WritableValue currentFunction;
    private SomeMathFunction mathFunction;
    private MappedSet outputSet;
    private IObservableValue sumOfOutputSet;

    public StructuredContentProviderTest() {
        this.createDataModel();
        this.shell = new Shell(Display.getCurrent(), 1264);
        Label someDoubles = new Label((Composite)this.shell, 0);
        someDoubles.setText("A list of random Doubles");
        someDoubles.setLayoutData((Object)new GridData(272));
        Control addRemoveComposite = this.createInputControl((Composite)this.shell, this.inputSet);
        GridData addRemoveData = new GridData(1808);
        addRemoveData.minimumHeight = 1;
        addRemoveData.minimumWidth = 1;
        addRemoveComposite.setLayoutData((Object)addRemoveData);
        Group operation = new Group((Composite)this.shell, 0);
        operation.setText("Select transformation");
        this.createRadioButton((Composite)operation, this.currentFunction, "f(x) = x", new Integer(0));
        this.createRadioButton((Composite)operation, this.currentFunction, "f(x) = 2 * x", new Integer(1));
        this.createRadioButton((Composite)operation, this.currentFunction, "f(x) = floor(x)", new Integer(2));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        operation.setLayout((Layout)layout);
        operation.setLayoutData((Object)new GridData(272));
        Control outputControl = this.createOutputComposite((Composite)this.shell);
        GridData outputData = new GridData(1808);
        outputData.minimumHeight = 1;
        outputData.minimumWidth = 1;
        outputData.widthHint = 300;
        outputData.heightHint = 150;
        outputControl.setLayoutData((Object)outputData);
        final Label sumLabel = new Label((Composite)this.shell, 0);
        new ControlUpdater((Control)sumLabel){

            protected void updateControl() {
                double sum = (Double)StructuredContentProviderTest.this.sumOfOutputSet.getValue();
                int size = StructuredContentProviderTest.this.outputSet.size();
                sumLabel.setText("The sum of the above " + size + " doubles is " + sum);
            }
        };
        sumLabel.setLayoutData((Object)new GridData(272));
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        this.shell.setLayout((Layout)layout2);
    }

    private void createDataModel() {
        this.inputSet = new WritableSet(realm);
        this.currentFunction = new WritableValue(realm, (Object)new Integer(1), null);
        this.mathFunction = new SomeMathFunction((IObservableSet)this.inputSet);
        this.currentFunction.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                StructuredContentProviderTest.this.mathFunction.setOperation((Integer)StructuredContentProviderTest.this.currentFunction.getValue());
            }
        });
        this.mathFunction.setOperation((Integer)this.currentFunction.getValue());
        this.outputSet = new MappedSet((IObservableSet)this.inputSet, (IObservableMap)this.mathFunction);
        this.sumOfOutputSet = new ComputedValue(realm){

            protected Object calculate() {
                double sum = 0.0;
                for (Double next : StructuredContentProviderTest.this.outputSet) {
                    sum += next.doubleValue();
                }
                return new Double(sum);
            }
        };
    }

    private void createRadioButton(Composite parent, final WritableValue model, String string, final Object value) {
        final Button button = new Button(parent, 16);
        button.setText(string);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                model.setValue(value);
                super.widgetSelected(e);
            }
        });
        new ControlUpdater((Control)button){

            protected void updateControl() {
                button.setSelection(model.getValue().equals(value));
            }
        };
        button.setLayoutData((Object)new GridData(272));
    }

    private Control createOutputComposite(Composite parent) {
        ListViewer listOfInts = new ListViewer(parent, 2816);
        listOfInts.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        listOfInts.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider());
        listOfInts.setInput((Object)this.outputSet);
        return listOfInts.getControl();
    }

    private Control createInputControl(Composite parent, final WritableSet inputSet) {
        Composite addRemoveComposite = new Composite(parent, 0);
        ListViewer listOfInts = new ListViewer(addRemoveComposite, 2048);
        listOfInts.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        listOfInts.setLabelProvider((IBaseLabelProvider)new ViewerLabelProvider());
        listOfInts.setInput((Object)inputSet);
        IViewerObservableValue selectedInt = ViewersObservables.observeSingleSelection((Viewer)listOfInts);
        GridData listData = new GridData(1808);
        listData.minimumHeight = 1;
        listData.minimumWidth = 1;
        listData.widthHint = 150;
        listData.heightHint = 150;
        listOfInts.getControl().setLayoutData((Object)listData);
        Composite buttonBar = new Composite(addRemoveComposite, 0);
        Button add = new Button(buttonBar, 8);
        add.setText("Add");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                inputSet.add((Object)new Double(StructuredContentProviderTest.this.random.nextDouble() * 100.0));
                super.widgetSelected(e);
            }
        });
        add.setLayoutData((Object)new GridData(272));
        final Button remove = new Button(buttonBar, 8);
        remove.setText("Remove");
        new ControlUpdater((Control)remove, (IObservableValue)selectedInt){
            private final /* synthetic */ IObservableValue val$selectedInt;
            {
                this.val$selectedInt = iObservableValue;
                super($anonymous0);
            }

            protected void updateControl() {
                remove.setEnabled(this.val$selectedInt.getValue() != null);
            }
        };
        remove.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableValue)selectedInt){
            private final /* synthetic */ IObservableValue val$selectedInt;
            {
                this.val$selectedInt = iObservableValue;
            }

            public void widgetSelected(SelectionEvent e) {
                inputSet.remove(this.val$selectedInt.getValue());
                super.widgetSelected(e);
            }
        });
        remove.setLayoutData((Object)new GridData(272));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonBar.setLayout((Layout)buttonLayout);
        buttonBar.setLayoutData((Object)new GridData(258));
        GridLayout addRemoveLayout = new GridLayout();
        addRemoveLayout.numColumns = 2;
        addRemoveComposite.setLayout((Layout)addRemoveLayout);
        return addRemoveComposite;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        realm = SWTObservables.getRealm((Display)display);
        StructuredContentProviderTest test = new StructuredContentProviderTest();
        Shell s = test.getShell();
        s.pack();
        s.setVisible(true);
        while (!s.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private Shell getShell() {
        return this.shell;
    }
}

