/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableListContentProvider
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider impl;

    public ObservableListContentProvider() {
        this(null);
    }

    public ObservableListContentProvider(IViewerUpdater viewerUpdater) {
        this.impl = new Impl(viewerUpdater);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet<Object> getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet<Object> getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Impl
    extends ObservableCollectionContentProvider
    implements IListChangeListener<Object> {
        private Viewer viewer;

        Impl(IViewerUpdater explicitViewerUpdater) {
            super(explicitViewerUpdater);
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }

        @Override
        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableList), (String)"This content provider only works with input of type IObservableList");
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection<?> collection) {
            ((IObservableList)collection).addListChangeListener((IListChangeListener)this);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection<?> collection) {
            ((IObservableList)collection).removeListChangeListener((IListChangeListener)this);
        }

        public void handleListChange(ListChangeEvent<Object> event) {
            if (this.isViewerDisposed()) {
                return;
            }
            final Set<Object> knownElementAdditions = ViewerElementSet.withComparer(this.comparer);
            final Set<Object> knownElementRemovals = ViewerElementSet.withComparer(this.comparer);
            final boolean[] suspendRedraw = new boolean[1];
            event.diff.accept((ListDiffVisitor)new ListDiffVisitor<Object>(){

                public void handleAdd(int index, Object element) {
                    knownElementAdditions.add(element);
                }

                public void handleRemove(int index, Object element) {
                    knownElementRemovals.add(element);
                }

                public void handleMove(int oldIndex, int newIndex, Object element) {
                    suspendRedraw[0] = true;
                    super.handleMove(oldIndex, newIndex, element);
                }

                public void handleReplace(int index, Object oldElement, Object newElement) {
                    suspendRedraw[0] = true;
                    super.handleReplace(index, oldElement, newElement);
                }
            });
            knownElementAdditions.removeAll((Collection<?>)this.knownElements);
            knownElementRemovals.removeAll((Collection<?>)event.getObservableList());
            this.knownElements.addAll(knownElementAdditions);
            if (this.realizedElements != null) {
                this.realizedElements.removeAll(knownElementRemovals);
            }
            if (suspendRedraw[0]) {
                this.viewer.getControl().setRedraw(false);
            }
            try {
                event.diff.accept((ListDiffVisitor)new ListDiffVisitor<Object>(){

                    public void handleAdd(int index, Object element) {
                        Impl.this.viewerUpdater.insert(element, index);
                    }

                    public void handleRemove(int index, Object element) {
                        Impl.this.viewerUpdater.remove(element, index);
                    }

                    public void handleReplace(int index, Object oldElement, Object newElement) {
                        Impl.this.viewerUpdater.replace(oldElement, newElement, index);
                    }

                    public void handleMove(int oldIndex, int newIndex, Object element) {
                        Impl.this.viewerUpdater.move(element, oldIndex, newIndex);
                    }
                });
            }
            finally {
                if (suspendRedraw[0]) {
                    this.viewer.getControl().setRedraw(true);
                }
            }
            if (this.realizedElements != null) {
                this.realizedElements.addAll(knownElementAdditions);
            }
            this.knownElements.removeAll(knownElementRemovals);
        }
    }
}

