/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js.text.scanners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.script.js.ResourceProvider;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.AbstractJavaScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.CombinedWordRule;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptWhitespaceDetector;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptWordDetector;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public final class JavaScriptCodeScanner
extends AbstractJavaScanner {
    static String[] fgKeywords = new String[]{"break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "enum", "export", "extends", "import", "super"};
    private static final String RETURN = "return";
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgTokenProperties = new String[]{ResourceProvider.JAVA_KEYWORD, ResourceProvider.JAVA_STRING, ResourceProvider.JAVA_DEFAULT, ResourceProvider.JAVA_KEYWORD_RETURN, ResourceProvider.JAVA_OPERATOR, ResourceProvider.JAVA_BRACKET};

    public JavaScriptCodeScanner(IResourcePool manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    @Override
    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token token = this.getToken(ResourceProvider.JAVA_STRING);
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)token, '\\'));
        Token defaultToken = this.getToken(ResourceProvider.JAVA_DEFAULT);
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavaScriptWhitespaceDetector(), (IToken)defaultToken));
        JavaScriptWordDetector wordDetector = new JavaScriptWordDetector();
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)defaultToken);
        token = this.getToken(ResourceProvider.JAVA_OPERATOR);
        rules.add(new OperatorRule((IToken)token));
        token = this.getToken(ResourceProvider.JAVA_BRACKET);
        rules.add(new BracketRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken(ResourceProvider.JAVA_KEYWORD_RETURN);
        returnWordRule.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken(ResourceProvider.JAVA_KEYWORD);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher(wordRule);
        rules.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)defaultToken);
        return rules;
    }

    private static final class BracketRule
    implements IRule {
        private final char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken fToken;

        public BracketRule(IToken token) {
            this.fToken = token;
        }

        public boolean isBracket(char character) {
            int index = 0;
            while (index < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isBracket((char)character)) {
                while (this.isBracket((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static final class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '.', '=', '/', '\\', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

