/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import junit.framework.TestCase;
import org.eclipse.e4.internal.languages.javascript.JSRequireBundle;
import org.eclipse.e4.internal.languages.javascript.JSVersionRange;

public class JSRequireTest
extends TestCase {
    public JSRequireTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNullHeader() {
        try {
            new JSRequireBundle(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSRequireTest.fail();
    }

    public void testNameAndEmptyVersionRange() {
        JSRequireBundle jsRequire = new JSRequireBundle("a.a");
        JSRequireTest.assertEquals((String)"a.a", (String)jsRequire.getName());
        JSRequireTest.assertEquals((Object)JSVersionRange.emptyRange, (Object)jsRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)0, (int)jsRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)0, (int)jsRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)false, (boolean)jsRequire.isOptional());
    }

    public void testNameAndVersion() {
        JSRequireBundle jsRequire = new JSRequireBundle("a.a;bundle-version=1.2.1");
        JSRequireTest.assertEquals((String)"a.a", (String)jsRequire.getName());
        JSRequireTest.assertEquals((Object)new JSVersionRange("1.2.1"), (Object)jsRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)1, (int)jsRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)0, (int)jsRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)false, (boolean)jsRequire.isOptional());
    }

    public void testIsOptional() {
        JSRequireBundle jsRequire = new JSRequireBundle("a.a;bundle-version=1.2.1;resolution:=optional");
        JSRequireTest.assertEquals((String)"a.a", (String)jsRequire.getName());
        JSRequireTest.assertEquals((Object)new JSVersionRange("1.2.1"), (Object)jsRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)1, (int)jsRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)1, (int)jsRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)true, (boolean)jsRequire.isOptional());
    }
}

