/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValueBinding<M, T>
extends Binding<IObservableValue<M>, IObservableValue<T>> {
    private final UpdateValueStrategy<T, M> targetToModel;
    private final UpdateValueStrategy<M, T> modelToTarget;
    private WritableValue<IStatus> validationStatusObservable;
    private IObservableValue<T> target;
    private IObservableValue<M> model;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IValueChangeListener<T> targetChangeListener = new IValueChangeListener<T>(){

        public void handleValueChange(ValueChangeEvent<T> event) {
            if (!ValueBinding.this.updatingTarget && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.target, ValueBinding.this.model, ValueBinding.this.targetToModel, false, false);
            }
        }
    };
    private IValueChangeListener<M> modelChangeListener = new IValueChangeListener<M>(){

        public void handleValueChange(ValueChangeEvent<M> event) {
            if (!ValueBinding.this.updatingModel && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.model, ValueBinding.this.target, ValueBinding.this.modelToTarget, false, false);
            }
        }
    };

    public ValueBinding(IObservableValue<T> targetObservableValue, IObservableValue<M> modelObservableValue, UpdateValueStrategy<T, M> targetToModel, UpdateValueStrategy<M, T> modelToTarget) {
        super(targetObservableValue, modelObservableValue);
        this.target = targetObservableValue;
        this.model = modelObservableValue;
        this.targetToModel = targetToModel;
        this.modelToTarget = modelToTarget;
        if ((targetToModel.getUpdatePolicy() & (UpdateValueStrategy.POLICY_CONVERT | UpdateValueStrategy.POLICY_UPDATE)) != 0) {
            this.target.addValueChangeListener(this.targetChangeListener);
        } else {
            this.targetChangeListener = null;
        }
        if ((modelToTarget.getUpdatePolicy() & (UpdateValueStrategy.POLICY_CONVERT | UpdateValueStrategy.POLICY_UPDATE)) != 0) {
            this.model.addValueChangeListener(this.modelChangeListener);
        } else {
            this.modelChangeListener = null;
        }
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE) {
            this.updateModelToTarget();
        } else if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.validateModelToTarget();
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE || this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.validateTargetToModel();
        }
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    public void updateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, false);
    }

    @Override
    public void updateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, false);
    }

    boolean mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
            return multiStatus.getSeverity() < 4;
        }
        return true;
    }

    private <S, D> void doUpdate(final IObservableValue<S> source, final IObservableValue<D> destination, final UpdateValueStrategy<S, D> updateValueStrategy, final boolean explicit, final boolean validateOnly) {
        final int policy = updateValueStrategy.getUpdatePolicy();
        if (policy == UpdateValueStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateValueStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        source.getRealm().exec(new Runnable(){

            public void run() {
                boolean destinationRealmReached = false;
                final BindingStatus multiStatus = BindingStatus.ok();
                try {
                    Object value = source.getValue();
                    IStatus status = updateValueStrategy.validateAfterGet(value);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    final Object convertedValue = updateValueStrategy.convert(value);
                    status = updateValueStrategy.validateAfterConvert(convertedValue);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    if (policy == UpdateValueStrategy.POLICY_CONVERT && !explicit) {
                        return;
                    }
                    status = updateValueStrategy.validateBeforeSet(convertedValue);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    if (validateOnly) {
                        return;
                    }
                    try {
                        destinationRealmReached = true;
                        destination.getRealm().exec(new Runnable(){

                            public void run() {
                                if (destination == ValueBinding.this.target) {
                                    ValueBinding.this.updatingTarget = true;
                                } else {
                                    ValueBinding.this.updatingModel = true;
                                }
                                try {
                                    IStatus setterStatus = updateValueStrategy.doSet(destination, convertedValue);
                                    ValueBinding.this.mergeStatus(multiStatus, setterStatus);
                                }
                                finally {
                                    if (destination == ValueBinding.this.target) {
                                        ValueBinding.this.updatingTarget = false;
                                    } else {
                                        ValueBinding.this.updatingModel = false;
                                    }
                                    ValueBinding.this.setValidationStatus((IStatus)multiStatus);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage() != null ? ex.getMessage() : "";
                        ValueBinding.this.mergeStatus(multiStatus, (IStatus)new Status(4, "org.eclipse.core.databinding", 4, message, (Throwable)ex));
                    }
                }
                finally {
                    if (!destinationRealmReached) {
                        ValueBinding.this.setValidationStatus((IStatus)multiStatus);
                    }
                }
            }
        });
    }

    @Override
    public void validateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, true);
    }

    @Override
    public void validateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, true);
    }

    private void setValidationStatus(final IStatus status) {
        this.validationStatusObservable.getRealm().exec(new Runnable(){

            public void run() {
                ValueBinding.this.validationStatusObservable.setValue((Object)status);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            this.target.removeValueChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            this.model.removeValueChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        this.target = null;
        this.model = null;
        super.dispose();
    }
}

