/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.xml;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.xml.ICollectionTransformer;
import org.eclipse.platform.discovery.util.internal.xml.XMLUtils;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class CollectionTransformerAbstractTest
extends MockObjectTestCase {
    protected Collection<?> testCollection;
    protected ICollectionTransformer target;
    protected Mock<ILongOperationRunner> lorMock;
    protected Mock<IProgressMonitor> pmMock;

    public void setUp() {
        this.target = this.createCollectionTransformer();
        this.testCollection = this.createTestList();
        this.lorMock = this.mock(ILongOperationRunner.class);
        this.pmMock = this.mock(IProgressMonitor.class);
        this.lorMock.stubs().method("run").withAnyArguments().will(this.invokePassedOperation());
        this.pmMock.stubs().method("beginTask").withAnyArguments();
        this.pmMock.stubs().method("done").withAnyArguments();
    }

    protected abstract String testCollecitonTag();

    protected abstract String testItemTag();

    protected abstract String testNamespace();

    protected abstract Collection<?> createTestList();

    protected abstract ICollectionTransformer createCollectionTransformer();

    public void testReturnedXMLIsExpected() throws SAXException, IOException {
        String result = this.target.transform(this.testCollection.iterator(), (ILongOperationRunner)this.lorMock.proxy());
        Element e = this.string2RootElement(result);
        CollectionTransformerAbstractTest.assertEquals((String)this.testCollecitonTag(), (String)e.getLocalName());
        CollectionTransformerAbstractTest.assertEquals((String)this.testNamespace(), (String)e.getNamespaceURI());
        NodeList children = e.getElementsByTagNameNS(this.testNamespace(), this.testItemTag());
        int i = 0;
        while (i < children.getLength()) {
            this.assertExpectedElement(i, (Element)children.item(i));
            ++i;
        }
    }

    protected Stub invokePassedOperation() {
        return new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                return ((ILongOperation)arg0.parameterValues.get(0)).run((IProgressMonitor)CollectionTransformerAbstractTest.this.pmMock.proxy());
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                arg0.append("execute passed long operation");
                return arg0;
            }
        };
    }

    protected abstract void assertExpectedElement(int var1, Element var2);

    public Element string2RootElement(String xml) throws SAXException, IOException {
        return new XMLUtils().bytes2RootElement(xml.getBytes());
    }
}

