/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;

public abstract class AbstractLongOpRunnerTests
extends MockObjectTestCase {
    protected ILongOperationRunner target;
    protected IProgressMonitor monitor;

    protected void setUp() throws Exception {
        this.monitor = this.newMonitor();
        this.target = this.newRunner(this.monitor);
    }

    protected abstract ILongOperationRunner newRunner(IProgressMonitor var1);

    protected IProgressMonitor newMonitor() {
        return new NullProgressMonitor();
    }

    public void testRuntimeNotWrapped() throws LongOpCanceledException {
        RuntimeException re = new RuntimeException();
        try {
            this.target.run(this.newExcThrowingOp(re));
            this.failNoExc();
        }
        catch (InvocationTargetException e) {
            AbstractLongOpRunnerTests.assertEquals((Object)re, (Object)e.getCause());
            this.failITE();
        }
        catch (RuntimeException e) {
            AbstractLongOpRunnerTests.assertSame((Object)re, (Object)e);
        }
    }

    public void testErrorNotWrapped() throws LongOpCanceledException {
        Error e = new Error();
        try {
            this.target.run(this.newErrThrowingOp(e));
            this.failNoExc();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.failITE();
        }
        catch (Error er) {
            AbstractLongOpRunnerTests.assertSame((Object)e, (Object)er);
        }
    }

    public void testOpReturnValue() throws LongOpCanceledException, InvocationTargetException {
        Object o = new Object();
        AbstractLongOpRunnerTests.assertSame((Object)o, (Object)this.target.run(this.newObjRetOp(o)));
    }

    public void testCancelledExceptionThrown() throws InvocationTargetException {
        LongOpCanceledException e = new LongOpCanceledException();
        try {
            this.target.run(this.newExcThrowingOp((Exception)((Object)e)));
        }
        catch (LongOpCanceledException ce) {
            AbstractLongOpRunnerTests.assertSame((Object)((Object)e), (Object)((Object)ce));
        }
    }

    protected void failITE() {
        AbstractLongOpRunnerTests.fail((String)"InvokationTargetEception cought");
    }

    protected void failNoExc() {
        AbstractLongOpRunnerTests.fail((String)"No exception thrown");
    }

    protected ILongOperation<Object> newObjRetOp(final Object o) {
        return new ILongOperation<Object>(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return o;
            }
        };
    }

    protected ILongOperation<Object> newExcThrowingOp(final Exception e) {
        return new ILongOperation<Object>(){

            public Object run(IProgressMonitor monitor) throws Exception {
                throw e;
            }
        };
    }

    protected ILongOperation<Object> newErrThrowingOp(final Error e) {
        return new ILongOperation<Object>(){

            public Object run(IProgressMonitor monitor) throws Exception {
                throw e;
            }
        };
    }
}

