/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.eclipse.platform.discovery.ui.api.IAdvancedSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsUiContributorDescr;
import org.eclipse.platform.discovery.ui.internal.xp.impl.AdvancedSearchParamsUiContribXpParser;
import org.junit.Assert;
import org.mockito.Mockito;

public class AdvancedSearchParamsUiContribXpParserTest
extends AbstractExtensionPointParserTest<IAdvancedSearchParamsUiContributorDescr> {
    private static final String CONTRIBUTOR_ID = "mycontributor";
    private static final String SEARCH_PROVIDER_ID = "mysearchprovider";
    private static final String CONTRIBUTOR_CLASS = "org.eclipse.test.MyContributor";
    private IAdvancedSearchParamsUiContributor contributor;

    protected AbstractExtensionPointParser<IAdvancedSearchParamsUiContributorDescr> createParser(IExtensionRegistry registry) {
        return new AdvancedSearchParamsUiContribXpParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        this.contributor = (IAdvancedSearchParamsUiContributor)Mockito.mock(IAdvancedSearchParamsUiContributor.class);
        registryBuilder.addAdvancedSearchParamsUiContributor(CONTRIBUTOR_ID, SEARCH_PROVIDER_ID, CONTRIBUTOR_CLASS, this.contributor);
    }

    protected void verifyContributions(List<IAdvancedSearchParamsUiContributorDescr> contributions) {
        Assert.assertEquals((String)"One contributor expected", (long)1L, (long)contributions.size());
        IAdvancedSearchParamsUiContributorDescr contributorDescr = contributions.get(0);
        Assert.assertEquals((String)"Unexpected id", (Object)CONTRIBUTOR_ID, (Object)contributorDescr.getId());
        Assert.assertEquals((String)"Unexpected search provider id", (Object)SEARCH_PROVIDER_ID, (Object)contributorDescr.getSearchProviderId());
        Assert.assertSame((String)"Unexpected custom ui contributor", (Object)this.contributor, (Object)contributorDescr.createContributor());
    }
}

