/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ISubdestinationsActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.IXPParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.impl.SearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationCategoryExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IObjectTypeExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.testutils.utils.model.DestProviderDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationCategoryDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationsProviderBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.ObjectTypeDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SearchDestinationBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SearchProviderDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.reflection.ReflectionUtils;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;
import org.mockito.Mockito;

public class SearchProviderConfigurationTest
extends MockObjectTestCase {
    private Boolean isActiveForSelection = true;
    private ISearchProviderConfiguration searchProviderConfig;
    private Mock<ISearchProvidersExtensionParser> searchProviderExtensionParser;
    private Mock<IObjectTypeExtensionParser> objectTypeExtensionParser;
    private Mock<IDestinationCategoryExtensionParser> destCategoryExtensionParser;
    private Mock<IDestinationsProviderExtensionParser> destProviderExtensionParser;
    private Mock<IXPParsersFactory> xpParsersFactory;
    private IObjectTypeDescription objectType_1;
    private IObjectTypeDescription objectType_2;
    private static final String OBJECT_TYPE_ID_1 = "objecttype1";
    private static final String OBJECT_TYPE_ID_2 = "objecttype2";
    private static final String OBJECT_TYPE_NAME_1 = "Object 1";
    private static final String OBJECT_TYPE_NAME_2 = "Object 2";
    private IDestinationCategoryDescription destinationCategory1;
    private IDestinationCategoryDescription destinationCategory2;
    private IDestinationCategoryDescription destinationCategory3;
    private IDestinationCategoryDescription destinationCategory4;
    private static final String DESTINATION_CATEGORY_ID_1 = "destcategory1";
    private static final String DESTINATION_CATEGORY_ID_2 = "destcategory2";
    private static final String DESTINATION_CATEGORY_ID_3 = "destcategory3";
    private static final String DESTINATION_CATEGORY_ID_4 = "destcategory4";
    private static final String DESTINATION_CATEGORY_NAME_1 = "Destination category 1";
    private static final String DESTINATION_CATEGORY_NAME_2 = "Destination category 2";
    private static final String DESTINATION_CATEGORY_NAME_3 = "Destination category 3";
    private static final String DESTINATION_CATEGORY_NAME_4 = "Destination category 4";
    private ISearchDestination searchDestination1;
    private ISearchDestination searchDestination2;
    private ISearchDestination searchDestination3;
    private ISearchDestination searchDestination4;
    private ISearchDestination searchDestination5;
    private ISearchDestination searchDestination6;
    private ISearchDestination searchDestination7;
    private ISearchDestination searchDestination8;
    private static final String SEARCH_DESTINATION_NAME_1 = "Search destination 1";
    private static final String SEARCH_DESTINATION_NAME_2 = "Search destination 2";
    private static final String SEARCH_DESTINATION_NAME_3 = "Search destination 3";
    private static final String SEARCH_DESTINATION_NAME_4 = "Search destination 4";
    private static final String SEARCH_DESTINATION_NAME_5 = "Search destination 5";
    private static final String SEARCH_DESTINATION_NAME_6 = "Search destination 6";
    private static final String SEARCH_DESTINATION_NAME_7 = "Search destination 7";
    private static final String SEARCH_DESTINATION_NAME_8 = "Search destination 8";
    private IDestinationsProviderDescription destinationProviderDescr1;
    private IDestinationsProviderDescription destinationProviderDescr2;
    private IDestinationsProviderDescription destinationProviderDescr3;
    private IDestinationsProviderDescription destinationProviderDescr4;
    private IDestinationsProviderDescription destinationProviderDescr5;
    private IDestinationsProvider destinationProvider1;
    private IDestinationsProvider destinationProvider2;
    private IDestinationsProvider destinationProvider3;
    private IDestinationsProvider destinationProvider4;
    private IDestinationsProvider destinationProvider5;
    private static final String DESTINATION_PROVIDER_ID_1 = "destinationprovider1";
    private static final String DESTINATION_PROVIDER_ID_2 = "destinationprovider2";
    private static final String DESTINATION_PROVIDER_ID_3 = "destinationprovider3";
    private static final String DESTINATION_PROVIDER_ID_4 = "destinationprovider4";
    private static final String DESTINATION_PROVIDER_ID_5 = "destinationprovider5";
    private ISearchProviderDescription provider1;
    private ISearchProviderDescription provider2;
    private ISearchProviderDescription provider3;
    private ISearchProviderDescription provider4;
    private static final String PROVIDER_ID_1 = "provider1";
    private static final String PROVIDER_ID_2 = "provider2";
    private static final String PROVIDER_ID_3 = "provider3";
    private static final String PROVIDER_ID_4 = "provider4";
    private static final String PROVIDER_NAME_1 = "Provider 1";
    private static final String PROVIDER_NAME_2 = "Provider 2";
    private static final String PROVIDER_NAME_3 = "Provider 3";
    private static final String PROVIDER_NAME_4 = "Provider 4";
    private Mock<ISearchSubdestination> subdestination1;
    private Mock<ISearchSubdestination> subdestination2;
    private Mock<ISearchSubdestination> subdestination3;
    private static final String SUBDESTINATION_ID_1 = "subdestination1";
    private static final String SUBDESTINATION_ID_2 = "subdestination2";
    private static final String SUBDESTINATION_ID_3 = "subdestination3";
    private static final String SUBDESTINATION_NAME_1 = "Subdestination 1";
    private static final String SUBDESTINATION_NAME_2 = "Subdestination 2";
    private static final String SUBDESTINATION_NAME_3 = "Subdestination 3";

    protected void setUp() throws Exception {
        this.setupObjectTypes();
        this.setupSearchDestinations();
        this.setupDestinationProviders();
        this.setupDestinationCategories();
        this.setupSearchProviders();
        this.setupSubdestinations();
        this.setupObjectTypesExtensionParser();
        this.setupDestCategoryExtensionParser();
        this.setupDestProvidersExtParser();
        this.setupSearchProvidersExtParser();
        this.setupParsersFactory();
        this.searchProviderConfig = new SearchProviderConfiguration((IXPParsersFactory)this.xpParsersFactory.proxy(), this.createActivationConfig(), this.createSubdestinationsActivationConfig());
    }

    private void setupParsersFactory() {
        this.xpParsersFactory = this.mock(IXPParsersFactory.class);
        this.xpParsersFactory.stubs().method("createDestinationsProviderParser").will(this.returnValue(this.destProviderExtensionParser.proxy()));
        this.xpParsersFactory.stubs().method("createDestinationsCategoryParser").will(this.returnValue(this.destCategoryExtensionParser.proxy()));
        this.xpParsersFactory.stubs().method("createObjectTypeParser").will(this.returnValue(this.objectTypeExtensionParser.proxy()));
        this.xpParsersFactory.stubs().method("createSearchProviderParser").will(this.returnValue(this.searchProviderExtensionParser.proxy()));
    }

    private void setupObjectTypes() {
        this.objectType_1 = (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId(OBJECT_TYPE_ID_1).withName(OBJECT_TYPE_NAME_1).object();
        this.objectType_2 = (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId(OBJECT_TYPE_ID_2).withName(OBJECT_TYPE_NAME_2).object();
    }

    private void setupSearchDestinations() {
        this.searchDestination1 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_1);
        this.searchDestination2 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_2);
        this.searchDestination3 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_3);
        this.searchDestination4 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_4);
        this.searchDestination5 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_5);
        this.searchDestination6 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_6);
        this.searchDestination7 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_7);
        this.searchDestination8 = this.stubSearchDestination(SEARCH_DESTINATION_NAME_8);
    }

    private ISearchDestination stubSearchDestination(String displayName) {
        return (ISearchDestination)new SearchDestinationBuilder().withDisplayName(displayName).object();
    }

    private void setupDestinationProviders() {
        this.destinationProvider1 = this.stubDestinationsProvider(this.searchDestination1, this.searchDestination2);
        this.destinationProviderDescr1 = this.stubDestinationsProviderDescription(DESTINATION_PROVIDER_ID_1, this.destinationProvider1);
        this.destinationProvider2 = this.stubDestinationsProvider(this.searchDestination3);
        this.destinationProviderDescr2 = this.stubDestinationsProviderDescription(DESTINATION_PROVIDER_ID_2, this.destinationProvider2);
        this.destinationProvider3 = this.stubDestinationsProvider(this.searchDestination4, this.searchDestination5);
        this.destinationProviderDescr3 = this.stubDestinationsProviderDescription(DESTINATION_PROVIDER_ID_3, this.destinationProvider3);
        this.destinationProvider4 = this.stubDestinationsProvider(this.searchDestination6, this.searchDestination7);
        this.destinationProviderDescr4 = this.stubDestinationsProviderDescription(DESTINATION_PROVIDER_ID_4, this.destinationProvider4);
        this.destinationProvider5 = this.stubDestinationsProvider(this.searchDestination8);
        this.destinationProviderDescr5 = this.stubDestinationsProviderDescription(DESTINATION_PROVIDER_ID_5, this.destinationProvider5);
    }

    private IDestinationsProvider stubDestinationsProvider(ISearchDestination ... destinations) {
        return (IDestinationsProvider)new DestinationsProviderBuilder().withDestinations(destinations).object();
    }

    private IDestinationsProviderDescription stubDestinationsProviderDescription(String id, IDestinationsProvider destProviderInstance) {
        return (IDestinationsProviderDescription)new DestProviderDescriptionBuilder().withProvider(destProviderInstance).withId(id).object();
    }

    private void setupDestinationCategories() {
        this.destinationCategory1 = this.stubDestCategoryDescription(DESTINATION_CATEGORY_ID_1, DESTINATION_CATEGORY_NAME_1, DESTINATION_PROVIDER_ID_1);
        this.destinationCategory2 = this.stubDestCategoryDescription(DESTINATION_CATEGORY_ID_2, DESTINATION_CATEGORY_NAME_2, DESTINATION_PROVIDER_ID_2, DESTINATION_PROVIDER_ID_3);
        this.destinationCategory3 = this.stubDestCategoryDescription(DESTINATION_CATEGORY_ID_3, DESTINATION_CATEGORY_NAME_3, DESTINATION_PROVIDER_ID_4);
        this.destinationCategory4 = this.stubDestCategoryDescription(DESTINATION_CATEGORY_ID_4, DESTINATION_CATEGORY_NAME_4, DESTINATION_PROVIDER_ID_5);
    }

    private IDestinationCategoryDescription stubDestCategoryDescription(String id, String displayName, String ... destProviderIds) {
        return (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().withDestinationClass(ISearchDestination.class).withDestinationProviders(destProviderIds).withId(id).withName(displayName).object();
    }

    private void setupSearchProviders() {
        this.provider1 = this.stubSearchProviderDescription(PROVIDER_ID_1, PROVIDER_NAME_1, true, this.objectType_1, this.destinationCategory1, this.destinationCategory2);
        this.provider2 = this.stubSearchProviderDescription(PROVIDER_ID_2, PROVIDER_NAME_2, false, this.objectType_1, this.destinationCategory3, this.destinationCategory4);
        this.provider3 = this.stubSearchProviderDescription(PROVIDER_ID_3, PROVIDER_NAME_3, true, this.objectType_1, this.destinationCategory2, this.destinationCategory3);
        this.provider4 = this.stubSearchProviderDescription(PROVIDER_ID_4, PROVIDER_NAME_4, false, this.objectType_2, this.destinationCategory1, this.destinationCategory4);
    }

    private ISearchProviderDescription stubSearchProviderDescription(String id, String name, boolean supportsTextSearch, IObjectTypeDescription objectType, IDestinationCategoryDescription ... categories) {
        return (ISearchProviderDescription)new SearchProviderDescriptionBuilder().supportsTextSearch(supportsTextSearch).withDestinationCategories(categories).supportsObjectType(objectType).withId(id).withName(name).object();
    }

    private void setupSubdestinations() {
        this.subdestination1 = this.mock(ISearchSubdestination.class, SUBDESTINATION_NAME_1);
        this.subdestination1.stubs().method("getId").will(this.returnValue(SUBDESTINATION_ID_1));
        this.subdestination1.stubs().method("getDisplayName").will(this.returnValue(SUBDESTINATION_NAME_1));
        this.subdestination1.stubs().method("getDestinationCategoryId").will(this.returnValue(DESTINATION_CATEGORY_ID_1));
        this.subdestination1.stubs().method("getObjectTypeId").will(this.returnValue(OBJECT_TYPE_ID_1));
        this.subdestination2 = this.mock(ISearchSubdestination.class, SUBDESTINATION_NAME_2);
        this.subdestination2.stubs().method("getId").will(this.returnValue(SUBDESTINATION_ID_2));
        this.subdestination2.stubs().method("getDisplayName").will(this.returnValue(SUBDESTINATION_NAME_2));
        this.subdestination2.stubs().method("getDestinationCategoryId").will(this.returnValue(DESTINATION_CATEGORY_ID_2));
        this.subdestination2.stubs().method("getObjectTypeId").will(this.returnValue(OBJECT_TYPE_ID_1));
        this.subdestination3 = this.mock(ISearchSubdestination.class, SUBDESTINATION_NAME_3);
        this.subdestination3.stubs().method("getId").will(this.returnValue(SUBDESTINATION_ID_3));
        this.subdestination3.stubs().method("getDisplayName").will(this.returnValue(SUBDESTINATION_NAME_3));
        this.subdestination3.stubs().method("getDestinationCategoryId").will(this.returnValue(DESTINATION_CATEGORY_ID_2));
        this.subdestination3.stubs().method("getObjectTypeId").will(this.returnValue(OBJECT_TYPE_ID_1));
    }

    private void setupObjectTypesExtensionParser() {
        this.objectTypeExtensionParser = this.mock(IObjectTypeExtensionParser.class);
        List<IObjectTypeDescription> objects = Arrays.asList(this.objectType_1, this.objectType_2);
        this.objectTypeExtensionParser.stubs().method("readContributions").will(this.returnValue(objects));
    }

    private void setupDestCategoryExtensionParser() {
        this.destCategoryExtensionParser = this.mock(IDestinationCategoryExtensionParser.class);
        ArrayList<IDestinationCategoryDescription> categories = new ArrayList<IDestinationCategoryDescription>();
        categories.addAll(Arrays.asList(this.destinationCategory1, this.destinationCategory2, this.destinationCategory3, this.destinationCategory4));
        this.destCategoryExtensionParser.stubs().method("readContributions").will(this.returnValue(categories));
    }

    private void setupDestProvidersExtParser() {
        this.destProviderExtensionParser = this.mock(IDestinationsProviderExtensionParser.class);
        ArrayList<IDestinationsProviderDescription> providers = new ArrayList<IDestinationsProviderDescription>();
        providers.addAll(Arrays.asList(this.destinationProviderDescr1, this.destinationProviderDescr2, this.destinationProviderDescr3, this.destinationProviderDescr4, this.destinationProviderDescr5));
        this.destProviderExtensionParser.stubs().method("readContributions").will(this.returnValue(providers));
    }

    private void setupSearchProvidersExtParser() {
        this.searchProviderExtensionParser = this.mock(ISearchProvidersExtensionParser.class);
        ArrayList<ISearchProviderDescription> providers = new ArrayList<ISearchProviderDescription>();
        providers.addAll(Arrays.asList(this.provider1, this.provider2, this.provider3, this.provider4));
        this.searchProviderExtensionParser.stubs().method("readContributions").will(this.returnValue(providers));
    }

    private ISearchProviderActivationConfig createActivationConfig() {
        Mock activationConfig = this.mock(ISearchProviderActivationConfig.class);
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_2), (Constraint)this.or((Constraint)this.eq(this.destinationCategory1), (Constraint)this.eq(this.destinationCategory4))).will(this.returnValue(this.provider4));
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_2), (Constraint)this.not((Constraint)this.or((Constraint)this.eq(this.destinationCategory1), (Constraint)this.eq(this.destinationCategory4)))).will(this.throwException(new ProviderNotFoundException("Provider not found")));
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory1)).will(this.returnValue(this.provider1));
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory2)).will(this.returnValue(this.provider1));
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory3)).will(this.returnValue(this.provider3));
        activationConfig.stubs().method("getActiveSearchProviderDescription").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory4)).will(this.returnValue(this.provider2));
        return (ISearchProviderActivationConfig)activationConfig.proxy();
    }

    private ISubdestinationsActivationConfig createSubdestinationsActivationConfig() {
        Mock activationConfig = this.mock(ISubdestinationsActivationConfig.class);
        activationConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_2), ANYTHING, ANYTHING).will(this.returnValue(new ArrayList()));
        activationConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory1), ANYTHING).will(this.returnValue(Arrays.asList((ISearchSubdestination)this.subdestination1.proxy())));
        activationConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory2), ANYTHING).will(this.returnValue(Arrays.asList((ISearchSubdestination)this.subdestination2.proxy(), (ISearchSubdestination)this.subdestination3.proxy())));
        activationConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory3), ANYTHING).will(this.returnValue(new ArrayList()));
        activationConfig.stubs().method("getAvailableSearchSubdestinations").with((Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory4), ANYTHING).will(this.returnValue(new ArrayList()));
        activationConfig.stubs().method("isSubdestinationActive").with((Constraint)this.eq(this.subdestination2.proxy()), (Constraint)this.eq(this.objectType_1), (Constraint)this.eq(this.destinationCategory2), (Constraint)this.eq(this.provider1)).will(this.checkValueForSelection());
        Constraint[] constraints = new Constraint[]{this.eq(this.objectType_1), this.eq(this.destinationCategory2), this.eq(this.provider1), this.eq(this.subdestination2.proxy()), this.eq(new Boolean(false))};
        activationConfig.stubs().method("activateSubdestination").with(constraints).will(new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                SearchProviderConfigurationTest.this.isActiveForSelection = new Boolean(false);
                return null;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return null;
            }
        });
        return (ISubdestinationsActivationConfig)activationConfig.proxy();
    }

    private Stub checkValueForSelection() {
        return new Stub(){

            public StringBuffer describeTo(StringBuffer buffer) {
                return buffer;
            }

            public Object invoke(Invocation invocation) throws Throwable {
                return SearchProviderConfigurationTest.this.isActiveForSelection;
            }
        };
    }

    public void testGetAvailableSearchProvidersDescriptionsForObjectType() {
        List descriptions = this.searchProviderConfig.getAvailableSearchProviderDescriptions(this.objectType_1);
        SearchProviderConfigurationTest.assertEquals((String)"Three providers expected", (int)3, (int)descriptions.size());
        ArrayList<String> ids = new ArrayList<String>();
        for (ISearchProviderDescription d : descriptions) {
            SearchProviderConfigurationTest.assertEquals((String)"Unexpected object type", (String)OBJECT_TYPE_ID_1, (String)d.getObjectType().getId());
            ids.add(d.getId());
        }
        SearchProviderConfigurationTest.assertTrue((String)"Provider 1 not returned", (boolean)ids.contains(PROVIDER_ID_1));
        SearchProviderConfigurationTest.assertTrue((String)"Provider 2 not returned", (boolean)ids.contains(PROVIDER_ID_2));
        SearchProviderConfigurationTest.assertTrue((String)"Provider 3 not returned", (boolean)ids.contains(PROVIDER_ID_3));
        ArrayList<String> ids2 = new ArrayList<String>();
        for (ISearchProviderDescription p : this.searchProviderConfig.getAvailableSearchProviderDescriptions(this.objectType_2)) {
            SearchProviderConfigurationTest.assertEquals((String)"Unexpected object type", (String)OBJECT_TYPE_ID_2, (String)p.getObjectType().getId());
            ids2.add(p.getId());
        }
        SearchProviderConfigurationTest.assertEquals((String)"One provider expected", (int)1, (int)ids2.size());
        SearchProviderConfigurationTest.assertTrue((String)"Provider 4 not returned", (boolean)ids2.contains(PROVIDER_ID_4));
    }

    public void testGetAvailableDestinationCategoriesForObjectType() {
        ArrayList<String> cat1Ids = new ArrayList<String>();
        for (IDestinationCategoryDescription cat : this.searchProviderConfig.getAvailableDestinationCategoriesForObjectType(this.objectType_1)) {
            cat1Ids.add(cat.getId());
        }
        SearchProviderConfigurationTest.assertEquals((String)"4 categories expected", (int)4, (int)cat1Ids.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat1Ids.contains(DESTINATION_CATEGORY_ID_1));
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat1Ids.contains(DESTINATION_CATEGORY_ID_2));
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat1Ids.contains(DESTINATION_CATEGORY_ID_3));
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat1Ids.contains(DESTINATION_CATEGORY_ID_4));
        ArrayList<String> cat2Ids = new ArrayList<String>();
        for (IDestinationCategoryDescription cat : this.searchProviderConfig.getAvailableDestinationCategoriesForObjectType(this.objectType_2)) {
            cat2Ids.add(cat.getId());
        }
        SearchProviderConfigurationTest.assertEquals((String)"2 categories expected", (int)2, (int)cat2Ids.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat2Ids.contains(DESTINATION_CATEGORY_ID_1));
        SearchProviderConfigurationTest.assertTrue((String)"Destinationa category 1 not returned", (boolean)cat2Ids.contains(DESTINATION_CATEGORY_ID_4));
    }

    public void testGetActiveSearchProvider() throws ProviderNotFoundException {
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_1, this.destinationCategory1).getId(), (String)PROVIDER_ID_1);
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_1, this.destinationCategory2).getId(), (String)PROVIDER_ID_1);
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_1, this.destinationCategory3).getId(), (String)PROVIDER_ID_3);
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_1, this.destinationCategory4).getId(), (String)PROVIDER_ID_2);
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_2, this.destinationCategory1).getId(), (String)PROVIDER_ID_4);
        SearchProviderConfigurationTest.assertEquals((String)this.searchProviderConfig.getActiveSearchProvider(this.objectType_2, this.destinationCategory4).getId(), (String)PROVIDER_ID_4);
        try {
            this.searchProviderConfig.getActiveSearchProvider(this.objectType_2, this.destinationCategory3);
            SearchProviderConfigurationTest.fail((String)"ProviderNotFoundException not thrown");
        }
        catch (ProviderNotFoundException providerNotFoundException) {}
        try {
            this.searchProviderConfig.getActiveSearchProvider(this.objectType_2, this.destinationCategory2);
            SearchProviderConfigurationTest.fail((String)"ProviderNotFoundException not thrown");
        }
        catch (ProviderNotFoundException providerNotFoundException) {}
    }

    public void testGetObjectTypes() {
        ArrayList<String> objectIds = new ArrayList<String>();
        for (IObjectTypeDescription objectType : this.searchProviderConfig.getObjectTypes()) {
            objectIds.add(objectType.getId());
        }
        SearchProviderConfigurationTest.assertEquals((String)"2 objects expected", (int)2, (int)objectIds.size());
        SearchProviderConfigurationTest.assertTrue((String)"Object 1 not returned", (boolean)objectIds.contains(OBJECT_TYPE_ID_1));
        SearchProviderConfigurationTest.assertTrue((String)"Object 2 not returned", (boolean)objectIds.contains(OBJECT_TYPE_ID_2));
    }

    public void testGetDestinationCategories() {
        ArrayList<String> catIds = new ArrayList<String>();
        for (IDestinationCategoryDescription cat : this.searchProviderConfig.getDestinationCategories()) {
            catIds.add(cat.getId());
        }
        SearchProviderConfigurationTest.assertEquals((String)"4 categories expected", (int)4, (int)catIds.size());
        SearchProviderConfigurationTest.assertTrue((String)"Category 1 not returned", (boolean)catIds.contains(DESTINATION_CATEGORY_ID_1));
        SearchProviderConfigurationTest.assertTrue((String)"Category 2 not returned", (boolean)catIds.contains(DESTINATION_CATEGORY_ID_2));
        SearchProviderConfigurationTest.assertTrue((String)"Category 3 not returned", (boolean)catIds.contains(DESTINATION_CATEGORY_ID_3));
        SearchProviderConfigurationTest.assertTrue((String)"Category 4 not returned", (boolean)catIds.contains(DESTINATION_CATEGORY_ID_4));
    }

    public void testGetDestinationProvidersForCategory() {
        List providers1 = this.searchProviderConfig.getDestinationProvidersForCategory(this.destinationCategory1);
        SearchProviderConfigurationTest.assertEquals((String)"One destination provider expected", (int)1, (int)providers1.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination provider 1 not returned", (boolean)providers1.contains(this.destinationProviderDescr1));
        List providers2 = this.searchProviderConfig.getDestinationProvidersForCategory(this.destinationCategory2);
        SearchProviderConfigurationTest.assertEquals((String)"Two destination providers expected", (int)2, (int)providers2.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination provider 2 not returned", (boolean)providers2.contains(this.destinationProviderDescr2));
        SearchProviderConfigurationTest.assertTrue((String)"Destination provider 3 not returned", (boolean)providers2.contains(this.destinationProviderDescr3));
        List providers3 = this.searchProviderConfig.getDestinationProvidersForCategory(this.destinationCategory3);
        SearchProviderConfigurationTest.assertEquals((String)"One destination provider expected", (int)1, (int)providers3.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination provider 4 not returned", (boolean)providers3.contains(this.destinationProviderDescr4));
        List providers4 = this.searchProviderConfig.getDestinationProvidersForCategory(this.destinationCategory4);
        SearchProviderConfigurationTest.assertEquals((String)"One destination provider expected", (int)1, (int)providers4.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination provider 5 not returned", (boolean)providers4.contains(this.destinationProviderDescr5));
    }

    public void testGetSearchDestinations() {
        List destinations = this.searchProviderConfig.getSearchDestinations(this.destinationCategory1, this.destinationProvider1);
        SearchProviderConfigurationTest.assertEquals((String)"Two destinations expected", (int)2, (int)destinations.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination 1 not returned", (boolean)destinations.contains(this.searchDestination1));
        SearchProviderConfigurationTest.assertTrue((String)"Destination 2 not returned", (boolean)destinations.contains(this.searchDestination2));
        destinations = this.searchProviderConfig.getSearchDestinations(this.destinationCategory2, this.destinationProvider2);
        SearchProviderConfigurationTest.assertEquals((String)"One destination expected", (int)1, (int)destinations.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination 3 not returned", (boolean)destinations.contains(this.searchDestination3));
        destinations = this.searchProviderConfig.getSearchDestinations(this.destinationCategory2, this.destinationProvider3);
        SearchProviderConfigurationTest.assertEquals((String)"Two destinations expected", (int)2, (int)destinations.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination 4 not returned", (boolean)destinations.contains(this.searchDestination4));
        SearchProviderConfigurationTest.assertTrue((String)"Destination 5 not returned", (boolean)destinations.contains(this.searchDestination5));
        destinations = this.searchProviderConfig.getSearchDestinations(this.destinationCategory3, this.destinationProvider4);
        SearchProviderConfigurationTest.assertEquals((String)"Two destinations expected", (int)2, (int)destinations.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination 6 not returned", (boolean)destinations.contains(this.searchDestination6));
        SearchProviderConfigurationTest.assertTrue((String)"Destination 7 not returned", (boolean)destinations.contains(this.searchDestination7));
        destinations = this.searchProviderConfig.getSearchDestinations(this.destinationCategory4, this.destinationProvider5);
        SearchProviderConfigurationTest.assertEquals((String)"One destination expected", (int)1, (int)destinations.size());
        SearchProviderConfigurationTest.assertTrue((String)"Destination 8 not returned", (boolean)destinations.contains(this.searchDestination8));
    }

    public void testGetSearchDestinationsIgnoredWhenDestinationsClassNoLegal() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Mock logger = this.mock(ILogger.class);
        logger.expects(this.atLeastOnce()).method("logWarn");
        ReflectionUtils.setFieldValue((Object)this.searchProviderConfig, (String)"logger", (Object)logger.proxy());
        Class<String> illegalClass = String.class;
        Mockito.stub((Object)this.destinationCategory1.getDestinationsClass()).toReturn(illegalClass);
        SearchProviderConfigurationTest.assertEquals((String)"No search destinations expected", (int)0, (int)this.searchProviderConfig.getSearchDestinations(this.destinationCategory1, this.destinationProvider1).size());
    }

    public void testGetAvailableSearchSubdestinations() {
        List subdest1 = this.searchProviderConfig.getAvailableSearchSubdestinations(this.objectType_1, this.destinationCategory1, this.provider1);
        SearchProviderConfigurationTest.assertEquals((String)"One subdestination expected", (int)1, (int)subdest1.size());
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 1 not returned", (boolean)subdest1.contains(this.subdestination1.proxy()));
        List subdest2 = this.searchProviderConfig.getAvailableSearchSubdestinations(this.objectType_1, this.destinationCategory2, this.provider1);
        SearchProviderConfigurationTest.assertEquals((String)"Two subdestination expected", (int)2, (int)subdest2.size());
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 2 not returned", (boolean)subdest2.contains(this.subdestination2.proxy()));
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 3 not returned", (boolean)subdest2.contains(this.subdestination3.proxy()));
        List subdest3 = this.searchProviderConfig.getAvailableSearchSubdestinations(this.objectType_1, this.destinationCategory3, this.provider2);
        SearchProviderConfigurationTest.assertEquals((String)"No subdestination expected", (int)0, (int)subdest3.size());
    }

    public void testGetActiveSearchSubdestinations() {
        List subdest2 = this.searchProviderConfig.getAvailableSearchSubdestinations(this.objectType_1, this.destinationCategory2, this.provider1);
        SearchProviderConfigurationTest.assertEquals((String)"Two subdestination expected", (int)2, (int)subdest2.size());
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 2 not returned", (boolean)subdest2.contains(this.subdestination2.proxy()));
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 3 not returned", (boolean)subdest2.contains(this.subdestination3.proxy()));
        SearchProviderConfigurationTest.assertTrue((String)"Subdestination 2 not checked", (boolean)this.searchProviderConfig.isSubdestinationActive((ISearchSubdestination)this.subdestination2.proxy(), this.objectType_1, this.destinationCategory2, this.provider1));
        this.searchProviderConfig.activateSubdestination(this.objectType_1, this.destinationCategory2, this.provider1, (ISearchSubdestination)this.subdestination2.proxy(), false);
        SearchProviderConfigurationTest.assertFalse((String)"Subdestination 2 is checked", (boolean)this.searchProviderConfig.isSubdestinationActive((ISearchSubdestination)this.subdestination2.proxy(), this.objectType_1, this.destinationCategory2, this.provider1));
    }

    public void testGetDestinationCategoriesForDestination() throws DestinationCategoryNotFoundException {
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 1 expected for destination1", (String)DESTINATION_CATEGORY_ID_1, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination1).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 1 expected for destination2", (String)DESTINATION_CATEGORY_ID_1, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination2).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 2 expected for destination3", (String)DESTINATION_CATEGORY_ID_2, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination3).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 2 expected for destination4", (String)DESTINATION_CATEGORY_ID_2, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination4).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 2 expected for destination5", (String)DESTINATION_CATEGORY_ID_2, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination5).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 3 expected for destination6", (String)DESTINATION_CATEGORY_ID_3, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination6).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 3 expected for destination7", (String)DESTINATION_CATEGORY_ID_3, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination7).iterator().next()).getId());
        SearchProviderConfigurationTest.assertEquals((String)"Destination category 4 expected for destination8", (String)DESTINATION_CATEGORY_ID_4, (String)((IDestinationCategoryDescription)this.searchProviderConfig.getDestinationCategoriesForDestination(this.searchDestination8).iterator().next()).getId());
    }

    public void testGetAvailableDestinationProviders() {
        List providers = this.searchProviderConfig.getAvailableDestinationProviders();
        SearchProviderConfigurationTest.assertEquals((String)"5 providers expected", (int)5, (int)providers.size());
        SearchProviderConfigurationTest.assertTrue((String)"destinationProviderDescr1 not found", (boolean)providers.contains(this.destinationProviderDescr1));
        SearchProviderConfigurationTest.assertTrue((String)"destinationProviderDescr2 not found", (boolean)providers.contains(this.destinationProviderDescr2));
        SearchProviderConfigurationTest.assertTrue((String)"destinationProviderDescr3 not found", (boolean)providers.contains(this.destinationProviderDescr3));
        SearchProviderConfigurationTest.assertTrue((String)"destinationProviderDescr4 not found", (boolean)providers.contains(this.destinationProviderDescr4));
        SearchProviderConfigurationTest.assertTrue((String)"destinationProviderDescr5 not found", (boolean)providers.contains(this.destinationProviderDescr5));
    }
}

