/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.core.internal.favorites.ISearchFavoritesControllerOutputView;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesController;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.jmock.core.Constraint;
import org.jmock.core.Stub;

public class SearchFavoritesControllerTestFixture {
    public Mock<IPersistenceUtil> persistenceUtil;
    public Mock<ISearchFavoritesControllerOutputView> favoritesView;
    public Mock<ILongOperationRunner> opRunner;
    public Mock<IDiscoveryEnvironment> env;
    public Mock<IErrorHandler> errorHandler;
    public Mock<IAdapterManager> adapterManager;
    public ISearchFavoritesMasterController controller;
    public Set<DestinationItemPair> loadedFromPeristence;
    public Mock<ISearchDestination> searchDestination;
    public final Object expectedObjectToShowInView = new Object();

    public SearchFavoritesControllerTestFixture(MockObjectTestCase tc) {
        this.persistenceUtil = tc.mock(IPersistenceUtil.class);
        this.favoritesView = tc.mock(ISearchFavoritesControllerOutputView.class);
        this.searchDestination = tc.mock(ISearchDestination.class);
        this.env = tc.mock(IDiscoveryEnvironment.class);
        this.errorHandler = tc.mock(IErrorHandler.class);
        this.env.stubs().method("errorHandler").will(tc.returnValue(this.errorHandler.proxy()));
        this.opRunner = tc.mock(ILongOperationRunner.class);
        this.env.stubs().method("operationRunner").will(tc.returnValue(this.opRunner.proxy()));
        this.adapterManager = tc.mock(IAdapterManager.class);
        this.loadedFromPeristence = new HashSet<DestinationItemPair>();
        this.loadedFromPeristence.add(new DestinationItemPair((ISearchDestination)this.searchDestination.proxy(), this.expectedObjectToShowInView));
        this.persistenceUtil.stubs().method("loadItems").with((Constraint)tc.same(this.opRunner.proxy())).will(tc.onConsecutiveCalls(new Stub[]{tc.returnValue(Collections.emptySet()), tc.returnValue(this.loadedFromPeristence)}));
        this.favoritesView.expects(tc.once()).method("showFavorites").with(tc.collectionWithElements(0, new Object[0]));
        this.controller = new SearchFavoritesController((ISearchFavoritesControllerOutputView)this.favoritesView.proxy(), (IDiscoveryEnvironment)this.env.proxy(), (IPersistenceUtil)this.persistenceUtil.proxy()){

            protected IAdapterManager getAdapterManager() {
                return (IAdapterManager)SearchFavoritesControllerTestFixture.this.adapterManager.proxy();
            }
        };
        tc.verify();
    }
}

