/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.ContextStructuredSelection;
import org.eclipse.platform.discovery.core.internal.favorites.DestinationItemPairArrayAdapterFactory;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.persistence.IDestinationItemPairAdapter;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.longop.CurrentThreadOperationRunner;

public class DestinationItemPairArrayAdapterFactoryTest
extends MockObjectTestCase {
    private DestinationItemPairArrayAdapterFactory factory;
    private Mock<ISearchDestination> destination;
    private Object item1;
    private Mock<ISearchContext> context;
    private Mock<ISearchParameters> parameters;
    private List<Object> items;
    private ILongOperationRunner opRunner;

    protected void setUp() throws Exception {
        this.items = new ArrayList<Object>();
        this.item1 = new Object();
        this.items.add(this.item1);
        this.factory = new DestinationItemPairArrayAdapterFactory();
        this.destination = this.mock(ISearchDestination.class);
        this.context = this.mock(ISearchContext.class);
        this.parameters = this.mock(ISearchParameters.class);
        this.parameters.stubs().method("getSearchDestination").withNoArguments().will(this.returnValue(this.destination.proxy()));
        this.context.stubs().method("searchParameters").withNoArguments().will(this.returnValue(this.parameters.proxy()));
        this.opRunner = new CurrentThreadOperationRunner((IProgressMonitor)new NullProgressMonitor());
    }

    public void testGetAdapterList() {
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((int)1, (int)this.factory.getAdapterList().length);
        DestinationItemPairArrayAdapterFactoryTest.assertEquals(IDestinationItemPairAdapter.class, (Object)this.factory.getAdapterList()[0]);
    }

    public void testGetAdapterWithAdaptableObject() {
        DestinationItemPairArrayAdapterFactoryTest.assertNull((Object)this.factory.getAdapter(new Object(), IDestinationItemPairAdapter.class));
    }

    public void testGetAdapterWithObjectAdapterType() {
        DestinationItemPairArrayAdapterFactoryTest.assertNull((Object)this.factory.getAdapter((Object)new ContextStructuredSelection(new LinkedList(), null), Object.class));
    }

    public void testGetAdapterWithCorrectParams() {
        Object item2 = new Object();
        this.items.add(item2);
        IDestinationItemPairAdapter result = (IDestinationItemPairAdapter)this.factory.getAdapter((Object)new ContextStructuredSelection(this.items, (ISearchContext)this.context.proxy()), IDestinationItemPairAdapter.class);
        DestinationItemPairArrayAdapterFactoryTest.assertNotNull((Object)result);
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((int)2, (int)result.adapt(this.opRunner).length);
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((Object)this.destination.proxy(), (Object)result.adapt(this.opRunner)[0].getDestination());
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((Object)this.item1, (Object)result.adapt(this.opRunner)[0].getItem());
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((Object)this.destination.proxy(), (Object)result.adapt(this.opRunner)[1].getDestination());
        DestinationItemPairArrayAdapterFactoryTest.assertEquals((Object)item2, (Object)result.adapt(this.opRunner)[1].getItem());
    }
}

