/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;
    private MethodOverrideTester fMethodOverrideTester;
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
        this.fMethodOverrideTester = null;
        this.fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyProvider, IType[] changedTypes) {
                if (changedTypes == null) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        TypeHierarchyContentProvider.this.fMethodOverrideTester = null;
                    }
                }
            }
        };
        lifecycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public final void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    private boolean initializeMethodOverrideTester(IMethod filterMethod, IType typeToFindIn) {
        IType focusType;
        IType filterType = filterMethod.getDeclaringType();
        ITypeHierarchy hierarchy = this.fTypeHierarchy.getHierarchy();
        boolean filterOverrides = JavaModelUtil.isSuperType(hierarchy, typeToFindIn, filterType);
        IType iType = focusType = filterOverrides ? filterType : typeToFindIn;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(focusType)) {
            this.fMethodOverrideTester = new MethodOverrideTester(focusType, hierarchy);
        }
        return filterOverrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompatibleMethods(IMethod filterMethod, IType typeToFindIn, List<IMember> children) throws JavaModelException {
        int flags = filterMethod.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || filterMethod.isConstructor()) {
            return;
        }
        ITypeHierarchyLifeCycleListener iTypeHierarchyLifeCycleListener = this.fTypeHierarchyLifeCycleListener;
        synchronized (iTypeHierarchyLifeCycleListener) {
            boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
            IMethod[] methods = typeToFindIn.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod curr = methods[i];
                flags = curr.getFlags();
                if (!(Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || curr.isConstructor() || !this.isCompatibleMethod(filterMethod, curr, filterMethodOverrides) || children.contains(curr))) {
                    children.add((IMember)curr);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasCompatibleMethod(IMethod filterMethod, IType typeToFindIn) throws JavaModelException {
        int flags = filterMethod.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || filterMethod.isConstructor()) {
            return false;
        }
        ITypeHierarchyLifeCycleListener iTypeHierarchyLifeCycleListener = this.fTypeHierarchyLifeCycleListener;
        synchronized (iTypeHierarchyLifeCycleListener) {
            boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
            IMethod[] methods = typeToFindIn.getMethods();
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return false;
                }
                IMethod curr = methods[i];
                flags = curr.getFlags();
                if (!Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !curr.isConstructor() && this.isCompatibleMethod(filterMethod, curr, filterMethodOverrides)) {
                    return true;
                }
                ++i;
            }
        }
    }

    private boolean isCompatibleMethod(IMethod filterMethod, IMethod method, boolean filterOverrides) throws JavaModelException {
        if (filterOverrides) {
            return this.fMethodOverrideTester.isSubsignature(filterMethod, method);
        }
        return this.fMethodOverrideTester.isSubsignature(method, filterMethod);
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    @Override
    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        ArrayList<IType> types = new ArrayList<IType>();
        this.getRootTypes(types);
        int i = types.size() - 1;
        while (i >= 0) {
            IType curr = types.get(i);
            try {
                if (!this.isInTree(curr)) {
                    types.remove(i);
                }
            }
            catch (JavaModelException javaModelException) {}
            --i;
        }
        return types.toArray();
    }

    protected void getRootTypes(List<IType> res) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            res.add(input);
        }
    }

    protected abstract void getTypesInHierarchy(IType var1, List<IType> var2);

    protected abstract IType getParentType(IType var1);

    private boolean isInHierarchyOfInputElements(IType type) {
        if (this.fWorkingSetFilter != null && !this.fWorkingSetFilter.select(null, null, (Object)type)) {
            return false;
        }
        IJavaElement[] input = this.fTypeHierarchy.getInputElements();
        int i = 0;
        while (i < input.length) {
            int inputType = input[i].getElementType();
            if (inputType == 7) {
                return true;
            }
            IJavaElement parent = type.getAncestor(inputType);
            if (inputType == 4 ? parent == null || parent.getElementName().equals(input[i].getElementName()) : input[i].equals(parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                ArrayList<IMember> children = new ArrayList<IMember>();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(type, children);
                }
                this.addTypeChildren(type, children);
                return children.toArray();
            }
            catch (JavaModelException javaModelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                return this.hasTypeChildren(type) || this.fMemberFilter != null && this.hasMemberFilterChildren(type);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMemberChildren(IType parent, List<IMember> children) throws JavaModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (parent.equals(member.getDeclaringType())) {
                if (!children.contains(member)) {
                    children.add(member);
                }
            } else if (member instanceof IMethod) {
                this.addCompatibleMethods((IMethod)member, parent, children);
            }
            ++i;
        }
    }

    private void addTypeChildren(IType type, List<IMember> children) throws JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = types.get(i);
            if (this.isInTree(curr)) {
                children.add((IMember)curr);
            }
            ++i;
        }
    }

    protected final boolean isInTree(IType type) throws JavaModelException {
        if (this.isInHierarchyOfInputElements(type)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(type) || this.hasTypeChildren(type);
            }
            return true;
        }
        return this.hasTypeChildren(type);
    }

    private boolean hasMemberFilterChildren(IType type) throws JavaModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (type.equals(member.getDeclaringType())) {
                return true;
            }
            if (member instanceof IMethod && this.hasCompatibleMethod((IMethod)member, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeChildren(IType type) throws JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = types.get(i);
            if (this.isInTree(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
        this.fTypeHierarchy.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                return this.getParentType((IType)member);
            }
            return member.getDeclaringType();
        }
        return null;
    }

    protected final boolean isAnonymous(IType type) {
        return type.getElementName().length() == 0;
    }

    protected final boolean isAnonymousFromInterface(IType type) {
        return this.isAnonymous(type) && this.fTypeHierarchy.getHierarchy().getSuperInterfaces(type).length != 0;
    }

    protected final boolean isObject(IType type) {
        return "Object".equals(type.getElementName()) && type.getDeclaringType() == null && "java.lang".equals(type.getPackageFragment().getElementName());
    }
}

