/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingService
implements IBindingService {
    @Inject
    private MApplication application;
    @Inject
    private EBindingService bindingService;
    @Inject
    private ECommandService commandService;
    @Inject
    private CommandManager commandManager;
    @Inject
    private BindingManager manager;
    @Inject
    @Optional
    private KeyBindingDispatcher dispatcher;
    private Map<String, MBindingContext> bindingContexts = new HashMap<String, MBindingContext>();
    private String[] activeSchemeIds;

    @Override
    public void dispose() {
    }

    @Override
    public void addBindingManagerListener(IBindingManagerListener listener) {
        this.manager.addBindingManagerListener(listener);
    }

    @Override
    public void removeBindingManagerListener(IBindingManagerListener listener) {
        this.manager.removeBindingManagerListener(listener);
    }

    @Override
    public TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        Collection seq = this.bindingService.getSequencesFor(parameterizedCommand);
        return seq.toArray(new TriggerSequence[seq.size()]);
    }

    @Override
    public TriggerSequence[] getActiveBindingsFor(String commandId) {
        return this.getActiveBindingsFor(this.commandService.createCommand(commandId, null));
    }

    @Override
    public Scheme getActiveScheme() {
        return this.manager.getActiveScheme();
    }

    @Override
    public TriggerSequence getBestActiveBindingFor(ParameterizedCommand command) {
        TriggerSequence seq = this.bindingService.getBestSequenceFor(command);
        return seq;
    }

    @Override
    public TriggerSequence getBestActiveBindingFor(String commandId) {
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, null);
        return this.bindingService.getBestSequenceFor(cmd);
    }

    @Override
    public String getBestActiveBindingFormattedFor(String commandId) {
        TriggerSequence sequence = this.bindingService.getBestSequenceFor(this.commandService.createCommand(commandId, null));
        return sequence == null ? null : sequence.format();
    }

    @Override
    public Binding[] getBindings() {
        return this.manager.getBindings();
    }

    @Override
    public TriggerSequence getBuffer() {
        if (this.dispatcher == null) {
            return KeySequence.getInstance();
        }
        return this.dispatcher.getBuffer();
    }

    @Override
    public String getDefaultSchemeId() {
        return BindingPersistence.getDefaultSchemeId();
    }

    @Override
    public Scheme[] getDefinedSchemes() {
        return this.manager.getDefinedSchemes();
    }

    @Override
    public String getLocale() {
        return this.manager.getLocale();
    }

    @Override
    public Map getPartialMatches(TriggerSequence trigger) {
        TriggerSequence[] prefixes = trigger.getPrefixes();
        int prefixesLength = prefixes.length;
        if (prefixesLength == 0) {
            return Collections.EMPTY_MAP;
        }
        Collection partialMatches = this.bindingService.getPartialMatches(trigger);
        HashMap prefixTable = new HashMap();
        for (Binding binding : partialMatches) {
            int i = 0;
            while (i < prefixesLength) {
                TriggerSequence prefix = prefixes[i];
                Object value = prefixTable.get(prefix);
                if (prefixTable.containsKey(prefix) && value instanceof Map) {
                    ((Map)value).put(prefixTable, binding);
                } else {
                    HashMap map = new HashMap();
                    prefixTable.put(prefix, map);
                    map.put(prefixTable, binding);
                }
                ++i;
            }
        }
        return prefixTable;
    }

    @Override
    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.getPerfectMatch(trigger);
    }

    @Override
    public String getPlatform() {
        return Util.getWS();
    }

    @Override
    public Scheme getScheme(String schemeId) {
        return this.manager.getScheme(schemeId);
    }

    @Override
    public boolean isKeyFilterEnabled() {
        return this.dispatcher == null ? false : this.dispatcher.getKeyDownFilter().isEnabled();
    }

    @Override
    public boolean isPartialMatch(TriggerSequence trigger) {
        return this.bindingService.isPartialMatch(trigger);
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.isPerfectMatch(trigger);
    }

    @Override
    public void openKeyAssistDialog() {
        this.dispatcher.openMultiKeyAssistShell();
    }

    @Override
    public void readRegistryAndPreferences(ICommandService commandService) {
        BindingPersistence bp = new BindingPersistence(this.manager, this.commandManager);
        bp.read();
    }

    private MCommand findCommand(String id) {
        for (MCommand cmd : this.application.getCommands()) {
            if (!id.equals(cmd.getElementId())) continue;
            return cmd;
        }
        return null;
    }

    private void saveLegacyPreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        BindingPersistence.write(activeScheme, bindings);
        try {
            this.manager.setActiveScheme(activeScheme);
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log("The active scheme is not currently defined.", WorkbenchPlugin.getStatus(e));
        }
        this.manager.setBindings(bindings);
    }

    @Override
    public void savePreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        MKeyBinding model;
        this.saveLegacyPreferences(activeScheme, bindings);
        this.writeSchemeToModel(activeScheme);
        this.activeSchemeIds = this.getSchemeIds(activeScheme.getId());
        HashSet activeBindings = new HashSet(this.manager.getActiveBindingsDisregardingContextFlat());
        HashMap<Binding, MKeyBinding> bindingToKey = new HashMap<Binding, MKeyBinding>();
        for (MBindingTable table : this.application.getBindingTables()) {
            for (MKeyBinding modelBinding : table.getBindings()) {
                Object obj = modelBinding.getTransientData().get("binding");
                if (!(obj instanceof Binding)) continue;
                bindingToKey.put((Binding)obj, modelBinding);
            }
        }
        HashSet deleted = new HashSet(bindingToKey.keySet());
        deleted.removeAll(activeBindings);
        for (Binding binding : deleted) {
            if (binding.getType() == 1) {
                this.removeBinding(binding);
                continue;
            }
            model = (MKeyBinding)bindingToKey.get(binding);
            if (model.getTags().contains("deleted")) continue;
            model.getTags().add("deleted");
        }
        for (Binding binding : activeBindings) {
            MKeyBinding toAddModel = model = (MKeyBinding)bindingToKey.get(binding);
            Binding toAddBinding = binding;
            Binding conflict = this.bindingService.getPerfectMatch(binding.getTriggerSequence());
            if (conflict != null && conflict.getContextId().equals(binding.getContextId())) {
                int rc = this.compareTo(conflict, binding);
                if (rc < 0) {
                    MKeyBinding conflictModel = (MKeyBinding)bindingToKey.get(conflict);
                    if (conflict.getType() == 1) {
                        this.removeBinding(conflict);
                    } else if (conflictModel != null && !conflictModel.getTags().contains("deleted")) {
                        conflictModel.getTags().add("deleted");
                    }
                } else if (rc > 0) {
                    if (binding.getType() == 1) {
                        this.removeBinding(binding);
                    } else if (model != null && !model.getTags().contains("deleted")) {
                        model.getTags().add("deleted");
                    }
                    toAddModel = null;
                    toAddBinding = null;
                }
            }
            if (toAddModel != null) {
                if (!toAddModel.getTags().contains("deleted")) continue;
                toAddModel.getTags().remove("deleted");
                continue;
            }
            if (toAddBinding == null) continue;
            this.addBinding(toAddBinding);
        }
    }

    private final String[] getSchemeIds(String schemeId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (schemeId != null) {
            strings.add(schemeId);
            try {
                schemeId = this.getScheme(schemeId).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    private final int compareSchemes(String schemeId1, String schemeId2) {
        if (this.activeSchemeIds == null) {
            return 0;
        }
        if (!schemeId2.equals(schemeId1)) {
            int i = 0;
            while (i < this.activeSchemeIds.length) {
                String schemePointer = this.activeSchemeIds[i];
                if (schemeId2.equals(schemePointer)) {
                    return 1;
                }
                if (schemeId1.equals(schemePointer)) {
                    return -1;
                }
                ++i;
            }
        }
        return 0;
    }

    private int compareTo(Binding current, Binding addition) {
        int rc;
        Scheme s2;
        Scheme s1 = this.manager.getScheme(current.getSchemeId());
        if (!s1.equals((Object)(s2 = this.manager.getScheme(addition.getSchemeId()))) && (rc = this.compareSchemes(s1.getId(), s2.getId())) != 0) {
            return rc > 0 ? -1 : 1;
        }
        return current.getType() - addition.getType();
    }

    private void writeSchemeToModel(Scheme activeScheme) {
        List tags = this.application.getTags();
        boolean found = false;
        Iterator i = tags.iterator();
        while (i.hasNext() && !found) {
            String tag = (String)i.next();
            if (!tag.startsWith("activeSchemeId")) continue;
            i.remove();
            found = true;
        }
        tags.add("activeSchemeId:" + activeScheme.getId());
    }

    @Override
    public void setKeyFilterEnabled(boolean enabled) {
        if (this.dispatcher != null) {
            this.dispatcher.getKeyDownFilter().setEnabled(enabled);
        }
    }

    @Override
    public Collection<Binding> getConflictsFor(TriggerSequence sequence) {
        return this.bindingService.getConflictsFor(sequence);
    }

    public MBindingContext getBindingContext(String id) {
        MBindingContext result = this.bindingContexts.get(id);
        if (result == null) {
            result = this.searchContexts(id, this.application.getRootContext());
            if (result == null) {
                result = MCommandsFactory.INSTANCE.createBindingContext();
                result.setElementId(id);
                result.setName("Auto::" + id);
                this.application.getRootContext().add(result);
            }
            if (result != null) {
                this.bindingContexts.put(id, result);
            }
        }
        return result;
    }

    private MBindingContext searchContexts(String id, List<MBindingContext> rootContext) {
        for (MBindingContext context : rootContext) {
            if (context.getElementId().equals(id)) {
                return context;
            }
            MBindingContext result = this.searchContexts(id, context.getChildren());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public final void addBinding(Binding binding) {
        MBindingTable table = this.getMTable(binding.getContextId());
        MKeyBinding keyBinding = this.createMKeyBinding(binding);
        if (keyBinding != null) {
            table.getBindings().add(keyBinding);
        }
    }

    private MBindingTable getMTable(String contextId) {
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContext().getElementId().equals(contextId)) continue;
            return bt;
        }
        MBindingTable table = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        table.setBindingContext(this.getBindingContext(contextId));
        table.setElementId(contextId);
        this.application.getBindingTables().add(table);
        return table;
    }

    private MKeyBinding createMKeyBinding(Binding binding) {
        MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        ParameterizedCommand parmCmd = binding.getParameterizedCommand();
        MCommand cmd = this.findCommand(parmCmd.getId());
        if (cmd == null) {
            return null;
        }
        keyBinding.setCommand(cmd);
        keyBinding.setKeySequence(binding.getTriggerSequence().format());
        Iterator iterator = parmCmd.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            MParameter p = CommandsFactoryImpl.eINSTANCE.createParameter();
            p.setElementId((String)entry.getKey());
            p.setName((String)entry.getKey());
            p.setValue((String)entry.getValue());
            keyBinding.getParameters().add(p);
        }
        List tags = keyBinding.getTags();
        if (binding.getSchemeId() != null && !binding.getSchemeId().equals(BindingPersistence.getDefaultSchemeId())) {
            tags.add("schemeId:" + binding.getSchemeId());
        }
        if (binding.getLocale() != null) {
            tags.add("locale:" + binding.getLocale());
        }
        if (binding.getPlatform() != null) {
            tags.add("platform:" + binding.getPlatform());
        }
        if (binding.getType() == 1) {
            tags.add("type:user");
        }
        keyBinding.getTransientData().put("binding", binding);
        return keyBinding;
    }

    private MKeyBinding findMKeyBinding(MBindingTable table, Binding binding) {
        String bindingSchemeId;
        List mBindings = table.getBindings();
        String string = bindingSchemeId = binding.getSchemeId() == null ? "org.eclipse.ui.defaultAcceleratorConfiguration" : binding.getSchemeId();
        if (binding.getParameterizedCommand() != null) {
            String commandId = binding.getParameterizedCommand().getId();
            for (MKeyBinding curr : mBindings) {
                Binding transientBinding = (Binding)curr.getTransientData().get("binding");
                if (transientBinding != null) {
                    if (!binding.equals((Object)transientBinding)) continue;
                    return curr;
                }
                if (!curr.getKeySequence().equals(binding.getTriggerSequence().format()) || curr.getCommand() == null || !curr.getCommand().getElementId().equals(commandId)) continue;
                String schemeId = "org.eclipse.ui.defaultAcceleratorConfiguration";
                List tags = curr.getTags();
                for (String tag : tags) {
                    if (!tag.startsWith("schemeId")) continue;
                    schemeId = tag.substring(9);
                    break;
                }
                if (!schemeId.equals(bindingSchemeId)) continue;
                return curr;
            }
        }
        return null;
    }

    public final void removeBinding(Binding binding) {
        MBindingTable table = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContext().getElementId().equals(binding.getContextId())) continue;
            table = bt;
            break;
        }
        if (table == null) {
            return;
        }
        if (binding.getType() == 1) {
            MKeyBinding mKeyBinding = this.findMKeyBinding(table, binding);
            if (mKeyBinding != null) {
                table.getBindings().remove(mKeyBinding);
            }
        } else {
            MKeyBinding mKeyBinding = this.findMKeyBinding(table, binding);
            if (mKeyBinding != null) {
                mKeyBinding.getTags().add("deleted");
            }
        }
    }

    public BindingManager getBindingManager() {
        return this.manager;
    }

    public Collection<Binding> getActiveBindings() {
        return this.bindingService.getActiveBindings();
    }

    public WorkbenchKeyboard getKeyboard() {
        return new WorkbenchKeyboard(this.dispatcher);
    }
}

