/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

abstract class PackageFragmentRootReorgChange
extends ResourceChange {
    private final String fRootHandle;
    private final INewNameQuery fNewNameQuery;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;
    private final IContainer fDestination;

    PackageFragmentRootReorgChange(IPackageFragmentRoot root, IContainer destination, INewNameQuery newNameQuery, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fRootHandle = root.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fUpdateClasspathQuery = updateClasspathQuery;
        this.fDestination = destination;
        this.setValidationMethod(0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(this.getName(), 2);
        try {
            String newName = this.getNewResourceName();
            IPackageFragmentRoot root = this.getRoot();
            ResourceMapping mapping = JavaElementResourceMapping.create(root);
            Change result = this.doPerformReorg(this.getDestinationProjectPath().append(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(root, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws JavaModelException;

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IResource getModifiedResource() {
        IPackageFragmentRoot root = this.getRoot();
        if (root != null) {
            return root.getResource();
        }
        return null;
    }

    protected IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fRootHandle);
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestination.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    protected IContainer getDestination() {
        return this.fDestination;
    }

    private String getNewResourceName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getRoot().getElementName();
        }
        return name;
    }

    protected int getUpdateModelFlags(boolean isCopy) throws JavaModelException {
        int otherProjects;
        int originating;
        if (isCopy) {
            originating = 0;
            otherProjects = 0;
        } else {
            originating = 2;
            otherProjects = 4;
        }
        IJavaElement javaElement = JavaCore.create((IResource)this.getDestination());
        if (javaElement == null || !javaElement.exists()) {
            return 0x10 | originating;
        }
        if (this.fUpdateClasspathQuery == null) {
            return 0x10 | originating | 8;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length <= 1) {
            return 0x10 | originating | 8;
        }
        boolean updateOtherProjectsToo = this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
        if (updateOtherProjectsToo) {
            return 0x10 | originating | 8 | otherProjects;
        }
        return 0x10 | originating | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }

    private void markAsExecuted(IPackageFragmentRoot root, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)root);
            log.markAsProcessed((Object)mapping);
        }
    }
}

