/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.net.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.ui.PlatformUI;

public class CVSScmUrlImportWizardPage
extends WizardPage
implements IScmUrlImportWizardPage {
    private RepositoryProviderType provider;
    private ScmUrlImportDescription[] descriptions;
    private Button useHead;
    private TableViewer bundlesViewer;
    private Label counterLabel;
    private static final String CVS_PAGE_USE_HEAD = "org.eclipse.team.cvs.ui.import.page.head";

    public CVSScmUrlImportWizardPage() {
        super("cvs", CVSUIMessages.CVSScmUrlImportWizardPage_0, null);
        this.setDescription(CVSUIMessages.CVSScmUrlImportWizardPage_1);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTUtils.createHVFillComposite((Composite)parent, (int)0, (int)1);
        Composite group = SWTUtils.createHFillComposite((Composite)comp, (int)0, (int)1);
        Button versions = SWTUtils.createRadioButton((Composite)group, (String)CVSUIMessages.CVSScmUrlImportWizardPage_3);
        this.useHead = SWTUtils.createRadioButton((Composite)group, (String)CVSUIMessages.CVSScmUrlImportWizardPage_2);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSScmUrlImportWizardPage.this.bundlesViewer.refresh(true);
            }
        };
        versions.addSelectionListener((SelectionListener)listener);
        this.useHead.addSelectionListener((SelectionListener)listener);
        Table table = new Table(comp, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.bundlesViewer = new TableViewer(table);
        this.bundlesViewer.setLabelProvider((IBaseLabelProvider)new CVSLabelProvider());
        this.bundlesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.bundlesViewer.setComparator(new ViewerComparator());
        this.counterLabel = new Label(comp, 0);
        this.counterLabel.setLayoutData((Object)new GridData(768));
        this.setControl((Control)comp);
        this.setPageComplete(true);
        IDialogSettings settings = this.getWizard().getDialogSettings();
        boolean useHEAD = settings != null && settings.getBoolean(CVS_PAGE_USE_HEAD);
        this.useHead.setSelection(useHEAD);
        versions.setSelection(!useHEAD);
        if (this.descriptions != null) {
            this.bundlesViewer.setInput((Object)this.descriptions);
            this.updateCount();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.cvs.ui.cvs_scm_url_import_page");
    }

    public boolean finish() {
        IDialogSettings settings;
        boolean head = false;
        if (this.getControl() != null) {
            head = this.useHead.getSelection();
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                settings.put(CVS_PAGE_USE_HEAD, head);
            }
        } else {
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                head = settings.getBoolean(CVS_PAGE_USE_HEAD);
            }
        }
        if (head) {
            int i = 0;
            while (i < this.descriptions.length) {
                URI scmUri = this.descriptions[i].getUri();
                this.descriptions[i].setUrl(CVSScmUrlImportWizardPage.removeTag(scmUri));
                ++i;
            }
        }
        return true;
    }

    public ScmUrlImportDescription[] getSelection() {
        return this.descriptions;
    }

    public void setSelection(ScmUrlImportDescription[] descriptions) {
        this.descriptions = descriptions;
        if (this.bundlesViewer != null) {
            this.bundlesViewer.setInput((Object)descriptions);
            this.updateCount();
        }
    }

    private void updateCount() {
        this.counterLabel.setText(NLS.bind((String)CVSUIMessages.CVSScmUrlImportWizardPage_4, (Object)new Integer(this.descriptions.length)));
        this.counterLabel.getParent().layout();
    }

    private static String getTag(URI scmUri) {
        return CVSURI.fromUri((URI)scmUri).getTag().getName();
    }

    private static String removeTag(URI scmUri) {
        StringBuffer sb = new StringBuffer();
        sb.append(scmUri.getScheme()).append(':');
        String ssp = scmUri.getSchemeSpecificPart();
        int j = ssp.indexOf(59);
        if (j != -1) {
            sb.append(ssp.substring(0, j));
            String[] params = ssp.substring(j).split(";");
            int k = 0;
            while (k < params.length) {
                if (!params[k].startsWith("tag=") && !params[k].startsWith("version=")) {
                    sb.append(params[k]);
                }
                ++k;
            }
        } else {
            sb.append(ssp);
        }
        return sb.toString();
    }

    private static String getServer(URI scmUri) {
        return CVSURI.fromUri((URI)scmUri).getRepository().getHost();
    }

    public void setProvider(RepositoryProviderType provider) {
        this.provider = provider;
    }

    public RepositoryProviderType getProvider() {
        return this.provider;
    }

    class CVSLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        CVSLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public void update(ViewerCell cell) {
            StyledString string = this.getStyledText(cell.getElement());
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof ScmUrlImportDescription) {
                ScmUrlImportDescription description = (ScmUrlImportDescription)element;
                String project = description.getProject();
                URI scmUrl = description.getUri();
                String version = CVSScmUrlImportWizardPage.getTag(scmUrl);
                String host = CVSScmUrlImportWizardPage.getServer(scmUrl);
                styledString.append(project);
                if (version != null) {
                    styledString.append(' ');
                    styledString.append(version, StyledString.DECORATIONS_STYLER);
                }
                styledString.append(' ');
                styledString.append('[', StyledString.DECORATIONS_STYLER);
                styledString.append(host, StyledString.DECORATIONS_STYLER);
                styledString.append(']', StyledString.DECORATIONS_STYLER);
                return styledString;
            }
            styledString.append(element.toString());
            return styledString;
        }
    }
}

