/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    public static final SharedASTProvider.WAIT_FLAG WAIT_YES = SharedASTProvider.WAIT_YES;
    public static final SharedASTProvider.WAIT_FLAG WAIT_ACTIVE_ONLY = SharedASTProvider.WAIT_ACTIVE_ONLY;
    public static final SharedASTProvider.WAIT_FLAG WAIT_NO = SharedASTProvider.WAIT_NO;
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    public static final int SHARED_AST_LEVEL = 4;
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private ITypeRoot fReconcilingJavaElement;
    private ITypeRoot fActiveJavaElement;
    private CompilationUnit fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private volatile boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return JavaPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activeJavaEditorChanged(IWorkbenchPart editor) {
        ITypeRoot javaElement = null;
        if (editor instanceof JavaEditor) {
            javaElement = ((JavaEditor)editor).getInputJavaElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActiveJavaElement = javaElement;
            this.cache(null, javaElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(javaElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingJavaElement == null || !this.fReconcilingJavaElement.equals(javaElement))) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            } else if (javaElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            }
        }
    }

    public boolean isCached(CompilationUnit ast) {
        return ast != null && this.fAST == ast;
    }

    public synchronized boolean isActive(ICompilationUnit cu) {
        return cu != null && cu.equals(this.fActiveJavaElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(ITypeRoot javaElement) {
        if (javaElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(javaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fReconcilingJavaElement = javaElement;
            this.fIsReconciling = true;
        }
        this.cache(null, javaElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveJavaElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(ITypeRoot javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(CompilationUnit ast) {
        if (ast == null) {
            return "null";
        }
        List types = ast.types();
        if (types != null && types.size() > 0) {
            return String.valueOf(((AbstractTypeDeclaration)types.get(0)).getName().getIdentifier()) + "(" + ast.hashCode() + ")";
        }
        return "AST without any type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(CompilationUnit ast, ITypeRoot javaElement) {
        if (this.fActiveJavaElement != null && !this.fActiveJavaElement.equals(javaElement)) {
            if (DEBUG && javaElement != null) {
                System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(javaElement));
            }
            return;
        }
        if (DEBUG && (javaElement != null || ast != null)) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnit getAST(ITypeRoot input, SharedASTProvider.WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        ITypeRoot activeElement;
        Object object;
        boolean isActiveElement;
        if (input == null) throw new IllegalArgumentException("input or wait flag are null");
        if (waitFlag == null) {
            throw new IllegalArgumentException("input or wait flag are null");
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = input.equals(this.fActiveJavaElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
                if (waitFlag == SharedASTProvider.WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + input.getElementName());
                    return null;
                }
            }
        }
        boolean canReturnNull = waitFlag == SharedASTProvider.WAIT_NO || waitFlag == SharedASTProvider.WAIT_ACTIVE_ONLY && (!isActiveElement || this.fAST != null);
        boolean isReconciling = false;
        if (isActiveElement) {
            object = this.fReconcileLock;
            synchronized (object) {
                activeElement = this.fReconcilingJavaElement;
                isReconciling = this.isReconciling(input);
                if (!isReconciling && !canReturnNull) {
                    this.aboutToBeReconciled(input);
                }
            }
        } else {
            activeElement = null;
        }
        if (isReconciling) {
            try {
                object = this.fWaitLock;
                synchronized (object) {
                    if (this.isReconciling(input)) {
                        if (DEBUG) {
                            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + input.getElementName());
                        }
                        this.fWaitLock.wait();
                    }
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveJavaElement) return this.getAST(input, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(input, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST: " + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (canReturnNull) {
            return null;
        }
        CompilationUnit ast = null;
        try {
            ast = ASTProvider.createAST(input, progressMonitor);
            if (progressMonitor == null) return ast;
            if (!progressMonitor.isCanceled()) return ast;
            ast = null;
            if (!DEBUG) return ast;
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + input.getElementName() + " - AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, input, null);
                    return this.fAST;
                }
                this.reconciled(ast, input, null);
            }
        }
    }

    private boolean isReconciling(ITypeRoot javaElement) {
        return javaElement != null && javaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling;
    }

    private static CompilationUnit createAST(final ITypeRoot input, final IProgressMonitor progressMonitor) {
        if (!ASTProvider.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((int)4);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setSource(input);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] root = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    if (DEBUG) {
                        System.err.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "creating AST for: " + input.getElementName());
                    }
                    root[0] = (CompilationUnit)parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], 4);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.ui", 0, "Error in JDT Core during AST creation", ex);
                JavaPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }

    private static boolean hasSource(ITypeRoot je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je.getBuffer() != null;
        }
        catch (JavaModelException ex) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 0, "Error in JDT Core during AST creation", (Throwable)ex);
            JavaPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(CompilationUnit ast, ITypeRoot javaElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
            if (javaElement == null || !javaElement.equals(this.fReconcilingJavaElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, javaElement);
        }
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.jdt.ui.ClassFileEditor".equals(id) || "org.eclipse.jdt.ui.CompilationUnitEditor".equals(id) || ref.getPart(false) instanceof JavaEditor;
        }
    }
}

