/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.TypeMarkerGroup;

public class MarkerGroup {
    private static MarkerGroupingEntry undefinedEntry = new MarkerGroupingEntry(MarkerMessages.FieldCategory_Uncategorized);
    protected IField field;
    protected MarkerField markerField;
    private Map typesToMappings = new HashMap();
    private IConfigurationElement configurationElement;
    private String id;

    public static MarkerGroup createMarkerGroup(IConfigurationElement element) {
        if (element.getAttribute("id").equals("org.eclipse.ui.ide.type")) {
            return new TypeMarkerGroup(element.getAttribute("label"));
        }
        return new MarkerGroup(element);
    }

    protected MarkerGroup(IConfigurationElement element) {
        this.configurationElement = element;
        if (element != null) {
            this.id = element.getAttribute("id");
        }
        this.createFields();
        this.processEntries();
    }

    private void processEntries() {
        if (this.configurationElement == null) {
            return;
        }
        IConfigurationElement[] markerEntryElements = this.configurationElement.getChildren("markerGroupingEntry");
        IConfigurationElement[] attributeGroupingElements = this.configurationElement.getChildren("markerAttributeGrouping");
        HashMap<String, MarkerGroupingEntry> idsToEntries = new HashMap<String, MarkerGroupingEntry>();
        int i = 0;
        while (i < markerEntryElements.length) {
            MarkerGroupingEntry entry = new MarkerGroupingEntry(markerEntryElements[i]);
            entry.setGroup(this);
            idsToEntries.put(entry.getId(), entry);
            ++i;
        }
        i = 0;
        while (i < attributeGroupingElements.length) {
            AttributeMarkerGrouping attributeGrouping = new AttributeMarkerGrouping(attributeGroupingElements[i]);
            String defaultEntryId = attributeGrouping.getDefaultGroupingEntry();
            if (defaultEntryId != null) {
                if (idsToEntries.containsKey(defaultEntryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)idsToEntries.get(defaultEntryId);
                    entry.setAsDefault(attributeGrouping.getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)defaultEntryId));
                }
            }
            IConfigurationElement[] mappings = attributeGrouping.getElement().getChildren("markerAttributeMapping");
            int mappingIndex = 0;
            while (mappingIndex < mappings.length) {
                String entryId = mappings[mappingIndex].getAttribute("markerGroupingEntry");
                if (idsToEntries.containsKey(entryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)idsToEntries.get(entryId);
                    entry.getMarkerGroup().mapAttribute(attributeGrouping, entry, mappings[mappingIndex].getAttribute("value"));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)defaultEntryId));
                }
                ++mappingIndex;
            }
            ++i;
        }
    }

    protected void createFields() {
        this.field = new FieldGroup(this);
        this.markerField = new GroupMarkerField();
    }

    private void addEntry(String markerType, EntryMapping entry) {
        MarkerType[] allDerived = this.getMarkerTypes(markerType);
        int i = 0;
        while (i < allDerived.length) {
            Collection<EntryMapping> entries = new HashSet<EntryMapping>();
            MarkerType type = allDerived[i];
            entries = this.typesToMappings.containsKey(type.getId()) ? (Collection)this.typesToMappings.get(markerType) : new HashSet();
            entries.add(entry);
            this.typesToMappings.put(type.getId(), entries);
            ++i;
        }
    }

    private MarkerGroupingEntry findGroupValue(ConcreteMarker concreteMarker) {
        String type = concreteMarker.getType();
        IMarker marker = concreteMarker.getMarker();
        return this.findGroupValue(type, marker);
    }

    public MarkerGroupingEntry findGroupValue(String type, IMarker marker) {
        if (this.typesToMappings.containsKey(type)) {
            EntryMapping defaultMapping = null;
            Iterator mappings = ((Collection)this.typesToMappings.get(type)).iterator();
            while (mappings.hasNext()) {
                EntryMapping mapping = (EntryMapping)mappings.next();
                if (mapping.hasAttributes()) {
                    MarkerGroupingEntry entry = mapping.testAttribute(marker);
                    if (entry == null) continue;
                    return entry;
                }
                defaultMapping = mapping;
            }
            if (defaultMapping != null) {
                return defaultMapping.groupingEntry;
            }
        }
        return undefinedEntry;
    }

    public IField getField() {
        return this.field;
    }

    public String getId() {
        return this.id;
    }

    private MarkerGroupingEntry getMapping(ConcreteMarker marker) {
        if (marker.getGroup() == null) {
            marker.setGroup(this.findGroupValue(marker));
        }
        return (MarkerGroupingEntry)marker.getGroup();
    }

    public MarkerField getMarkerField() {
        return this.markerField;
    }

    private MarkerType[] getMarkerTypes(String markerType) {
        MarkerTypesModel model = MarkerTypesModel.getInstance();
        HashSet<MarkerType> types = new HashSet<MarkerType>();
        MarkerType type = model.getType(markerType);
        if (type != null) {
            types.add(type);
            MarkerType[] subs = type.getAllSubTypes();
            int j = 0;
            while (j < subs.length) {
                types.add(subs[j]);
                ++j;
            }
        }
        if (types.isEmpty()) {
            return new MarkerType[0];
        }
        MarkerType[] typesArray = new MarkerType[types.size()];
        types.toArray(typesArray);
        return typesArray;
    }

    public String getTitle() {
        return this.configurationElement.getAttribute("label");
    }

    public void mapAttribute(AttributeMarkerGrouping attributeGrouping, MarkerGroupingEntry entry, String attributeValue) {
        this.addEntry(attributeGrouping.getMarkerType(), new AttributeMapping(entry, attributeGrouping.getAttribute(), attributeValue, attributeGrouping));
        attributeGrouping.addGroup(this);
    }

    public void remove(MarkerGroupingEntry entry) {
        Iterator entries = this.typesToMappings.values().iterator();
        ArrayList<EntryMapping> removeCollection = new ArrayList<EntryMapping>();
        while (entries.hasNext()) {
            Collection mappings = (Collection)entries.next();
            Iterator mappingsIterator = mappings.iterator();
            while (mappingsIterator.hasNext()) {
                EntryMapping next = (EntryMapping)mappingsIterator.next();
                if (!next.groupingEntry.equals(entry)) continue;
                removeCollection.add(next);
            }
            mappings.removeAll(removeCollection);
            removeCollection.clear();
        }
    }

    public void setAsDefault(String markerType, MarkerGroupingEntry entry) {
        this.addEntry(markerType, new EntryMapping(entry));
    }

    public void unmap(AttributeMarkerGrouping attributeMarkerGrouping) {
        String type = attributeMarkerGrouping.getMarkerType();
        ArrayList removed = new ArrayList();
        Collection entries = (Collection)this.typesToMappings.get(type);
        Iterator mappings = entries.iterator();
        while (mappings.hasNext()) {
            Object mapping = mappings.next();
            if (!(mapping instanceof AttributeMapping) || ((AttributeMapping)mapping).grouping != attributeMarkerGrouping) continue;
            removed.add(mapping);
        }
        entries.removeAll(removed);
        if (entries.size() == 0) {
            this.typesToMappings.remove(type);
        }
    }

    public Comparator getEntriesComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return -(((MarkerGroupingEntry)o1).getPriority() - ((MarkerGroupingEntry)o2).getPriority());
            }
        };
    }

    class AttributeMapping
    extends EntryMapping {
        String attribute;
        String attributeValue;
        AttributeMarkerGrouping grouping;

        AttributeMapping(MarkerGroupingEntry entry, String attributeName, String value, AttributeMarkerGrouping grouping) {
            super(entry);
            this.attribute = attributeName;
            this.attributeValue = value;
            this.grouping = grouping;
        }

        public boolean hasAttributes() {
            return true;
        }

        public MarkerGroupingEntry testAttribute(IMarker marker) {
            Object value;
            if (!marker.exists()) {
                return null;
            }
            try {
                value = marker.getAttribute(this.attribute);
            }
            catch (CoreException e) {
                Policy.handle(e);
                return null;
            }
            if (value != null && this.attributeValue.equals(value.toString())) {
                return this.groupingEntry;
            }
            return null;
        }
    }

    class EntryMapping {
        MarkerGroupingEntry groupingEntry;

        EntryMapping(MarkerGroupingEntry entry) {
            this.groupingEntry = entry;
        }

        public boolean hasAttributes() {
            return false;
        }

        public MarkerGroupingEntry testAttribute(IMarker marker) {
            return null;
        }
    }

    class FieldGroup
    implements IField {
        MarkerGroup markerGroup;
        private boolean showing;

        FieldGroup(MarkerGroup group) {
            this.markerGroup = group;
        }

        public int compare(Object obj1, Object obj2) {
            MarkerGroupingEntry entry1 = MarkerGroup.this.getMapping(((MarkerNode)obj1).getConcreteRepresentative());
            MarkerGroupingEntry entry2 = MarkerGroup.this.getMapping(((MarkerNode)obj2).getConcreteRepresentative());
            return entry2.getPriority() - entry1.getPriority();
        }

        public Image getColumnHeaderImage() {
            return null;
        }

        public String getColumnHeaderText() {
            return this.markerGroup.getTitle();
        }

        public int getDefaultDirection() {
            return 1;
        }

        public String getDescription() {
            return this.markerGroup.getTitle();
        }

        public Image getDescriptionImage() {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        public int getPreferredWidth() {
            return 75;
        }

        public String getValue(Object obj) {
            MarkerNode node = (MarkerNode)obj;
            if (node.isConcrete()) {
                MarkerGroupingEntry groupingEntry = this.markerGroup.getMapping((ConcreteMarker)node);
                return groupingEntry.getLabel();
            }
            return node.getDescription();
        }

        public boolean isShowing() {
            return this.showing;
        }

        public void setShowing(boolean showing) {
            this.showing = showing;
        }
    }

    class GroupMarkerField
    extends MarkerField {
        GroupMarkerField() {
        }

        public String getValue(MarkerItem item) {
            return MarkerSupportInternalUtilities.getGroupValue(MarkerGroup.this, item);
        }

        public int compare(MarkerItem item1, MarkerItem item2) {
            if (item1.getMarker() == null) {
                if (item2.getMarker() == null) {
                    return 0;
                }
                return 1;
            }
            if (item2.getMarker() == null) {
                return -1;
            }
            try {
                return MarkerGroup.this.findGroupValue(item2.getMarker().getType(), item2.getMarker()).getPriority() - MarkerGroup.this.findGroupValue(item1.getMarker().getType(), item1.getMarker()).getPriority();
            }
            catch (CoreException exception) {
                Policy.handle(exception);
                return 0;
            }
        }

        public String getName() {
            return MarkerGroup.this.getTitle();
        }
    }
}

