/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.ctxhelp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpCommand;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpContext;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpDescription;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpObject;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpRoot;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpTopic;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.CtxHelpContentProvider;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.CtxHelpMessages;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpAbstractAddAction;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpRemoveAction;
import org.eclipse.pde.internal.ua.ui.editor.toc.HelpEditorUtil;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.keys.IBindingService;

public class CtxHelpTreeSection
extends TreeSection {
    private CtxHelpModel fModel;
    private TreeViewer fTree;
    private FormFilteredTree fFilteredTree;
    private static final int F_BUTTON_ADD_CONTEXT = 0;
    private static final int F_BUTTON_ADD_TOPIC = 2;
    private static final int F_BUTTON_ADD_COMMAND = 3;
    private static final int F_BUTTON_REMOVE = 5;
    private static final int F_BUTTON_UP = 6;
    private static final int F_BUTTON_DOWN = 7;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;
    private CtxHelpAbstractAddAction fAddContextAction;
    private CtxHelpAbstractAddAction fAddTopicAction;
    private CtxHelpAbstractAddAction fAddCommandAction;
    private CtxHelpRemoveAction fRemoveObjectAction;
    private OpenLinkAction fOpenLinkAction;
    private CtxHelpObject fDropTargetParent;
    private CtxHelpObject fDropTargetSibling;
    private boolean fDragFromHere;
    static /* synthetic */ Class class$0;

    public CtxHelpTreeSection(PDEFormPage formPage, Composite parent) {
        String[] stringArray = new String[8];
        stringArray[0] = CtxHelpMessages.CtxHelpTreeSection_1;
        stringArray[2] = CtxHelpMessages.CtxHelpTreeSection_2;
        stringArray[3] = CtxHelpMessages.CtxHelpTreeSection_3;
        stringArray[5] = CtxHelpMessages.CtxHelpTreeSection_4;
        stringArray[6] = CtxHelpMessages.CtxHelpTreeSection_5;
        stringArray[7] = CtxHelpMessages.CtxHelpTreeSection_6;
        super(formPage, parent, 128, stringArray);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (CtxHelpModel)this.getPage().getModel();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setText(CtxHelpMessages.CtxHelpTreeSection_7);
        section.setDescription(CtxHelpMessages.CtxHelpTreeSection_8);
        section.setClient((Control)container);
        this.createCommands();
        this.initializeTreeViewer();
        this.createSectionToolbar(section, toolkit);
        this.fFilteredTree.createUIListenerEntryFilter((IContextPart)this);
    }

    private void createCommands() {
        this.fAddContextAction = new CtxHelpAbstractAddAction(){

            public void run() {
                if (this.fParentObject != null) {
                    CtxHelpContext context = this.fParentObject.getModel().getFactory().createContext();
                    String id = PDELabelUtility.generateName((String[])this.getChildNames(), (String)CtxHelpMessages.CtxHelpTreeSection_9);
                    context.setID(id);
                    this.addChild((CtxHelpObject)context);
                }
            }
        };
        this.fAddContextAction.setText(CtxHelpMessages.CtxHelpTreeSection_10);
        this.fAddTopicAction = new CtxHelpAbstractAddAction(){

            public void run() {
                if (this.fParentObject != null) {
                    CtxHelpTopic topic = this.fParentObject.getModel().getFactory().createTopic();
                    String label = PDELabelUtility.generateName((String[])this.getChildNames(), (String)CtxHelpMessages.CtxHelpTreeSection_11);
                    topic.setLabel(label);
                    this.addChild((CtxHelpObject)topic);
                }
            }
        };
        this.fAddTopicAction.setText(CtxHelpMessages.CtxHelpTreeSection_12);
        this.fAddCommandAction = new CtxHelpAbstractAddAction(){

            public void run() {
                if (this.fParentObject != null) {
                    CtxHelpCommand command = this.fParentObject.getModel().getFactory().createCommand();
                    String label = PDELabelUtility.generateName((String[])this.getChildNames(), (String)CtxHelpMessages.CtxHelpTreeSection_13);
                    command.setLabel(label);
                    this.addChild((CtxHelpObject)command);
                }
            }
        };
        this.fAddCommandAction.setText(CtxHelpMessages.CtxHelpTreeSection_14);
        this.fRemoveObjectAction = new CtxHelpRemoveAction();
        this.fOpenLinkAction = new OpenLinkAction();
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.add((IAction)new CollapseAction((AbstractTreeViewer)this.fTree, CtxHelpMessages.CtxHelpTreeSection_15, 1, (Object)this.fModel.getCtxHelpRoot()));
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fTree = treePart.getTreeViewer();
        this.fTree.setContentProvider((IContentProvider)new CtxHelpContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fTree.addPostSelectionChangedListener((ISelectionChangedListener)new PDEFormEditor.PDEFormEditorChangeListener(this.getPage().getPDEEditor()));
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.fFilteredTree = new FormFilteredTree(parent, style, new PatternFilter());
        parent.setData("filtered", (Object)Boolean.TRUE);
        return this.fFilteredTree.getViewer();
    }

    private void initializeTreeViewer() {
        if (this.fModel == null) {
            return;
        }
        CtxHelpRoot root = this.fModel.getCtxHelpRoot();
        this.fTree.setInput((Object)root);
        this.getTreePart().setButtonEnabled(0, this.isEditable());
        this.getTreePart().setButtonEnabled(3, this.isEditable());
        this.getTreePart().setButtonEnabled(2, this.isEditable());
        this.getTreePart().setButtonEnabled(5, false);
        this.getTreePart().setButtonEnabled(6, false);
        this.getTreePart().setButtonEnabled(7, false);
    }

    public boolean setFormInput(Object object) {
        if (object instanceof CtxHelpObject) {
            this.fTree.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTree.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public ISelection getSelection() {
        return this.fTree.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.fTree.setSelection(selection);
    }

    public void fireSelection() {
        this.fTree.setSelection(this.fTree.getSelection());
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public void updateButtons() {
        if (!this.fModel.isEditable()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        CtxHelpObject firstSelectedObject = (CtxHelpObject)selection.getFirstElement();
        this.getTreePart().setButtonEnabled(0, true);
        boolean enableAdd = false;
        if (firstSelectedObject != null) {
            if (firstSelectedObject.canAddSibling(3)) {
                enableAdd = true;
            } else if (firstSelectedObject.canAddChild(3)) {
                enableAdd = true;
            }
        }
        this.getTreePart().setButtonEnabled(2, enableAdd);
        enableAdd = false;
        if (firstSelectedObject != null) {
            if (firstSelectedObject.canAddSibling(4)) {
                enableAdd = true;
            } else if (firstSelectedObject.canAddChild(4)) {
                enableAdd = true;
            }
        }
        this.getTreePart().setButtonEnabled(3, enableAdd);
        this.getTreePart().setButtonEnabled(5, this.getRemovableObjectFromSelection(selection).size() > 0);
        boolean canMoveUp = true;
        boolean canMoveDown = true;
        if (firstSelectedObject == null || firstSelectedObject.getType() == 0 || firstSelectedObject.getType() == 2 || selection.size() > 1) {
            canMoveUp = false;
            canMoveDown = false;
        } else {
            CtxHelpObject parent = firstSelectedObject.getParent();
            if (parent != null) {
                int index = parent.indexOf((IDocumentElementNode)firstSelectedObject);
                if (index == 0) {
                    canMoveUp = false;
                }
                if (index >= parent.getChildCount() - 1) {
                    canMoveDown = false;
                }
            }
        }
        this.getTreePart().setButtonEnabled(6, canMoveUp);
        this.getTreePart().setButtonEnabled(7, canMoveDown);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        Object object = selection.getFirstElement();
        CtxHelpObject firstSelectedObject = (CtxHelpObject)object;
        if (firstSelectedObject != null) {
            MenuManager submenu = new MenuManager(CtxHelpMessages.CtxHelpTreeSection_16);
            boolean addMenu = false;
            if (this.updateAddContextActionWithSelection(firstSelectedObject)) {
                submenu.add((IAction)this.fAddContextAction);
                addMenu = true;
            }
            if (this.updateAddTopicActionWithSelection(firstSelectedObject)) {
                submenu.add((IAction)this.fAddTopicAction);
                addMenu = true;
            }
            if (this.updateAddCommandActionWithSelection(firstSelectedObject)) {
                submenu.add((IAction)this.fAddCommandAction);
                addMenu = true;
            }
            if (addMenu) {
                manager.add((IContributionItem)submenu);
                manager.add((IContributionItem)new Separator());
            }
        }
        if (firstSelectedObject instanceof CtxHelpTopic && ((CtxHelpTopic)firstSelectedObject).getLocation() != null) {
            this.fOpenLinkAction.setTarget((CtxHelpTopic)firstSelectedObject);
            manager.add((IAction)this.fOpenLinkAction);
            this.fillContextMenuShowInAction(manager);
            manager.add((IContributionItem)new Separator());
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        if (this.updateRemoveActionWithSelection(selection)) {
            manager.add((IAction)this.fRemoveObjectAction);
            manager.add((IContributionItem)new Separator());
        }
    }

    private void fillContextMenuShowInAction(IMenuManager manager) {
        String keyBinding;
        IBindingService bindingService;
        String showInLabel = CtxHelpMessages.CtxHelpTreeSection_17;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            showInLabel = String.valueOf(showInLabel) + '\t' + keyBinding;
        }
        MenuManager showInMenu = new MenuManager(showInLabel);
        showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getPage().getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)showInMenu);
    }

    private boolean updateAddContextActionWithSelection(CtxHelpObject selectedObject) {
        if (selectedObject != null && selectedObject.canAddSibling(1)) {
            this.fAddContextAction.setParentObject(selectedObject.getParent());
            this.fAddContextAction.setTargetObject(selectedObject);
            this.fAddContextAction.setEnabled(this.fModel.isEditable());
            return true;
        }
        if (selectedObject != null && selectedObject.canAddChild(1)) {
            this.fAddContextAction.setParentObject(selectedObject);
            this.fAddContextAction.setTargetObject(null);
            this.fAddContextAction.setEnabled(this.fModel.isEditable());
            return true;
        }
        if (this.fModel.getCtxHelpRoot().canAddChild(1)) {
            this.fAddContextAction.setParentObject((CtxHelpObject)this.fModel.getCtxHelpRoot());
            this.fAddContextAction.setTargetObject(null);
            this.fAddContextAction.setEnabled(this.fModel.isEditable());
            return true;
        }
        return false;
    }

    private boolean updateAddTopicActionWithSelection(CtxHelpObject selectedObject) {
        if (selectedObject != null) {
            if (selectedObject.canAddSibling(3)) {
                this.fAddTopicAction.setParentObject(selectedObject.getParent());
                this.fAddTopicAction.setTargetObject(selectedObject);
                this.fAddTopicAction.setEnabled(this.fModel.isEditable());
                return true;
            }
            if (selectedObject.canAddChild(3)) {
                this.fAddTopicAction.setParentObject(selectedObject);
                this.fAddTopicAction.setTargetObject(null);
                this.fAddTopicAction.setEnabled(this.fModel.isEditable());
                return true;
            }
        }
        return false;
    }

    private boolean updateAddCommandActionWithSelection(CtxHelpObject selectedObject) {
        if (selectedObject != null) {
            if (selectedObject.canAddSibling(4)) {
                this.fAddCommandAction.setParentObject(selectedObject.getParent());
                this.fAddCommandAction.setTargetObject(selectedObject);
                this.fAddCommandAction.setEnabled(this.fModel.isEditable());
                return true;
            }
            if (selectedObject.canAddChild(4)) {
                this.fAddCommandAction.setParentObject(selectedObject);
                this.fAddCommandAction.setTargetObject(null);
                this.fAddCommandAction.setEnabled(this.fModel.isEditable());
                return true;
            }
        }
        return false;
    }

    private boolean updateRemoveActionWithSelection(IStructuredSelection selection) {
        List objectsToRemove = this.getRemovableObjectFromSelection(selection);
        this.fRemoveObjectAction.setToRemove(objectsToRemove.toArray(new CtxHelpObject[objectsToRemove.size()]));
        this.fRemoveObjectAction.setEnabled(this.fModel.isEditable());
        return objectsToRemove.size() > 0;
    }

    private List getRemovableObjectFromSelection(IStructuredSelection selection) {
        ArrayList objectsToRemove = new ArrayList();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object currentObject = iterator.next();
            if (!(currentObject instanceof CtxHelpObject) || !((CtxHelpObject)currentObject).canBeRemoved()) continue;
            objectsToRemove.add(currentObject);
        }
        return objectsToRemove;
    }

    public boolean doGlobalAction(String actionId) {
        boolean cutAction = actionId.equals(ActionFactory.CUT.getId());
        if (cutAction || actionId.equals(ActionFactory.DELETE.getId())) {
            this.updateRemoveActionWithSelection((IStructuredSelection)this.fTree.getSelection());
            this.fRemoveObjectAction.run();
            return !cutAction;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return this.canDropCopy(targetObject, sourceObjects, 3);
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        this.doDropCopy(targetObject, sourceObjects, 3);
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof CtxHelpTopic) {
            this.open((CtxHelpTopic)selected);
        } else if (selected instanceof CtxHelpObject) {
            this.fTree.setExpandedState(selected, !this.fTree.getExpandedState(selected));
        }
    }

    public void open(CtxHelpTopic topic) {
        IPath resourcePath = topic.getLocation();
        if (!this.isEditable() || resourcePath == null || resourcePath.isEmpty()) {
            MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)CtxHelpMessages.CtxHelpTreeSection_18, (String)CtxHelpMessages.CtxHelpTreeSection_19);
            return;
        }
        IResource resource = this.fModel.getUnderlyingResource().getProject().findMember(resourcePath);
        if (resource != null && resource instanceof IFile) {
            IPath path = resource.getFullPath();
            if (HelpEditorUtil.hasValidPageExtension(path)) {
                try {
                    IDE.openEditor((IWorkbenchPage)PDEUserAssistanceUIPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
                }
                catch (PartInitException partInitException) {}
            } else {
                MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)CtxHelpMessages.CtxHelpTreeSection_20, (String)CtxHelpMessages.CtxHelpTreeSection_21);
            }
        } else {
            MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)CtxHelpMessages.CtxHelpTreeSection_22, (String)CtxHelpMessages.CtxHelpTreeSection_23);
        }
    }

    protected void buttonSelected(int index) {
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        Object object = selection.getFirstElement();
        CtxHelpObject firstSelectedObject = (CtxHelpObject)object;
        switch (index) {
            case 0: {
                this.updateAddContextActionWithSelection(firstSelectedObject);
                this.fAddContextAction.run();
                break;
            }
            case 2: {
                this.updateAddTopicActionWithSelection(firstSelectedObject);
                this.fAddTopicAction.run();
                break;
            }
            case 3: {
                this.updateAddCommandActionWithSelection(firstSelectedObject);
                this.fAddCommandAction.run();
                break;
            }
            case 5: {
                this.updateRemoveActionWithSelection(selection);
                this.fRemoveObjectAction.run();
                break;
            }
            case 6: {
                this.handleMoveAction(-1);
                break;
            }
            case 7: {
                this.handleMoveAction(1);
            }
        }
    }

    private void handleMoveAction(int positionFlag) {
        CtxHelpObject ctxHelpObject;
        CtxHelpObject parent;
        IStructuredSelection sel = (IStructuredSelection)this.fTree.getSelection();
        Object object = sel.getFirstElement();
        if (object == null) {
            return;
        }
        if (object instanceof CtxHelpObject && (parent = (ctxHelpObject = (CtxHelpObject)object).getParent()) != null) {
            parent.moveChild(ctxHelpObject, positionFlag);
            this.fTree.setSelection((ISelection)new StructuredSelection((Object)ctxHelpObject), true);
        }
    }

    public void dispose() {
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    protected boolean isDragAndDropEnabled() {
        return true;
    }

    public int getSupportedDNDOperations() {
        return 3;
    }

    public void doDropCopy(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (this.fDropTargetParent != null) {
            if (this.fDropTargetSibling != null) {
                if (targetLocation == 1) {
                    int i = 0;
                    while (i < sourceObjects.length) {
                        ((CtxHelpObject)sourceObjects[i]).reconnect((IDocumentElementNode)this.fDropTargetParent, (IModel)this.fModel);
                        this.fDropTargetParent.addChild((CtxHelpObject)sourceObjects[i], this.fDropTargetSibling, true);
                        ++i;
                    }
                } else {
                    int i = sourceObjects.length - 1;
                    while (i >= 0) {
                        ((CtxHelpObject)sourceObjects[i]).reconnect((IDocumentElementNode)this.fDropTargetParent, (IModel)this.fModel);
                        this.fDropTargetParent.addChild((CtxHelpObject)sourceObjects[i], this.fDropTargetSibling, false);
                        --i;
                    }
                }
            } else {
                int i = 0;
                while (i < sourceObjects.length) {
                    ((CtxHelpObject)sourceObjects[i]).reconnect((IDocumentElementNode)this.fDropTargetParent, (IModel)this.fModel);
                    this.fDropTargetParent.addChild((CtxHelpObject)sourceObjects[i]);
                    ++i;
                }
            }
        }
        this.fDropTargetParent = null;
        this.fDropTargetSibling = null;
    }

    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        this.doDropCopy(targetObject, sourceObjects, targetLocation);
    }

    public boolean canDropCopy(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (targetObject == null || !(targetObject instanceof CtxHelpObject) && ((CtxHelpObject)targetObject).getType() != 0) {
            int i = 0;
            while (i < sourceObjects.length) {
                if (!(sourceObjects[i] instanceof CtxHelpObject) || !this.fModel.getCtxHelpRoot().canAddChild(((CtxHelpObject)sourceObjects[i]).getType())) {
                    return false;
                }
                ++i;
            }
            this.fDropTargetParent = this.fModel.getCtxHelpRoot();
            this.fDropTargetSibling = null;
            return true;
        }
        CtxHelpObject dropTarget = (CtxHelpObject)targetObject;
        if (targetLocation == 3) {
            boolean result = true;
            int i = 0;
            while (i < sourceObjects.length) {
                if (!(sourceObjects[i] instanceof CtxHelpObject) || !dropTarget.canAddChild(((CtxHelpObject)sourceObjects[i]).getType())) {
                    result = false;
                    break;
                }
                ++i;
            }
            if (result) {
                this.fDropTargetParent = dropTarget;
                this.fDropTargetSibling = null;
                return true;
            }
        }
        int i = 0;
        while (i < sourceObjects.length) {
            if (!(sourceObjects[i] instanceof CtxHelpObject) || !dropTarget.canAddSibling(((CtxHelpObject)sourceObjects[i]).getType())) {
                return false;
            }
            ++i;
        }
        this.fDropTargetParent = dropTarget.getParent();
        this.fDropTargetSibling = dropTarget;
        return true;
    }

    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return this.canDropCopy(targetObject, sourceObjects, targetLocation);
    }

    public boolean canDragCopy(Object[] sourceObjects) {
        return true;
    }

    public boolean canDragMove(Object[] sourceObjects) {
        int i = 0;
        while (i < sourceObjects.length) {
            if (!(sourceObjects[i] instanceof CtxHelpObject) || !((CtxHelpObject)sourceObjects[i]).canBeRemoved()) {
                return false;
            }
            ++i;
        }
        this.fDragFromHere = true;
        return true;
    }

    public void doDragRemove(Object[] sourceObjects) {
        this.updateRemoveActionWithSelection((IStructuredSelection)new StructuredSelection(sourceObjects));
        this.fRemoveObjectAction.run();
        this.fDragFromHere = false;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3 && event.getChangedProperty().equals("type_swap")) {
            this.handleModelChangeTypeSwap(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
    }

    private void handleModelChangeTypeSwap(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        CtxHelpObject object = (CtxHelpObject)objects[0];
        if (object != null) {
            this.fTree.refresh((Object)object);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.markStale();
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        int i = 0;
        while (i < objects.length) {
            CtxHelpObject object;
            if (objects[i] instanceof CtxHelpObject && (object = (CtxHelpObject)objects[i]).getType() != 0) {
                this.fTree.refresh((Object)object.getParent());
                if (!(object instanceof CtxHelpDescription)) {
                    this.fTree.setSelection((ISelection)new StructuredSelection((Object)object), true);
                }
            }
            ++i;
        }
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof CtxHelpObject) {
                CtxHelpObject object = (CtxHelpObject)objects[i];
                this.fTree.remove((Object)object);
                CtxHelpObject nextSelection = this.fRemoveObjectAction.getNextSelection();
                if (nextSelection != null) {
                    this.fTree.refresh((Object)object.getParent());
                    if (!this.fDragFromHere) {
                        this.fTree.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
                    }
                    this.fRemoveObjectAction.clearNextSelection();
                }
            }
            ++i;
        }
    }

    private void handleModelChangeType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects[0] != null) {
            this.fTree.update(objects[0], null);
        }
    }

    class OpenLinkAction
    extends Action {
        private CtxHelpTopic fOpenTarget;

        public OpenLinkAction() {
            super(CtxHelpMessages.CtxHelpTreeSection_0);
        }

        public void setTarget(CtxHelpTopic target) {
            this.fOpenTarget = target;
        }

        public void run() {
            if (this.fOpenTarget != null) {
                CtxHelpTreeSection.this.open(this.fOpenTarget);
            }
        }
    }
}

