/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SurroundWithTemplateMenuAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.actions.SurroundWithTryCatchAction;
import org.eclipse.jdt.ui.actions.SurroundWithTryMultiCatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class SurroundWithActionGroup
extends ActionGroup {
    private CompilationUnitEditor fEditor;
    private SurroundWithTryCatchAction fSurroundWithTryCatchAction;
    private SurroundWithTryMultiCatchAction fSurroundWithTryMultiCatchAction;
    private final String fGroup;

    public SurroundWithActionGroup(CompilationUnitEditor editor, String group) {
        this.fEditor = editor;
        this.fGroup = group;
        this.fSurroundWithTryCatchAction = SurroundWithActionGroup.createSurroundWithTryCatchAction(this.fEditor);
        this.fSurroundWithTryMultiCatchAction = SurroundWithActionGroup.createSurroundWithTryMultiCatchAction(this.fEditor);
    }

    public void fillActionBars(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SurroundWithTryCatch", (IAction)this.fSurroundWithTryCatchAction);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SurroundWithTryMultiCatch", (IAction)this.fSurroundWithTryMultiCatchAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getLength() == 0) {
            return;
        }
        String menuText = ActionMessages.SurroundWithTemplateMenuAction_SurroundWithTemplateSubMenuName;
        MenuManager subMenu = new MenuManager(menuText, "org.eclipse.jdt.ui.edit.text.java.surround.with.quickMenu");
        subMenu.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.surround.with.quickMenu");
        menu.appendToGroup(this.fGroup, (IContributionItem)subMenu);
        subMenu.add((IAction)new Action(){});
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                SurroundWithTemplateMenuAction.fillMenu(manager, SurroundWithActionGroup.this.fEditor, SurroundWithActionGroup.this.fSurroundWithTryCatchAction, SurroundWithActionGroup.this.fSurroundWithTryMultiCatchAction);
            }
        });
    }

    private static SurroundWithTryCatchAction createSurroundWithTryCatchAction(CompilationUnitEditor editor) {
        SurroundWithTryCatchAction result = new SurroundWithTryCatchAction(editor);
        result.setText(ActionMessages.SurroundWithTemplateMenuAction_SurroundWithTryCatchActionName);
        result.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.surround.with.try.catch");
        editor.setAction("SurroundWithTryCatch", (IAction)result);
        return result;
    }

    private static SurroundWithTryMultiCatchAction createSurroundWithTryMultiCatchAction(CompilationUnitEditor editor) {
        SurroundWithTryMultiCatchAction result = new SurroundWithTryMultiCatchAction(editor);
        result.setText(ActionMessages.SurroundWithTemplateMenuAction_SurroundWithTryMultiCatchActionName);
        result.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.surround.with.try.multicatch");
        editor.setAction("SurroundWithTryMultiCatch", (IAction)result);
        return result;
    }
}

