/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.core.services.translation.TranslationProviderFactory;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.DefaultLoggerProvider;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.WorkbenchLogger;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.css.CSSStyleDeclaration;

public class E4Application
implements IApplication {
    private static final String PLUGIN_ID = "org.eclipse.e4.ui.workbench.swt";
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "2";
    private String[] args;
    private IModelResourceHandler handler;
    private Display display = null;
    private E4Workbench workbench = null;
    public static final String THEME_ID = "cssTheme";
    private Object lcManager;

    public Display getApplicationDisplay() {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        return this.display;
    }

    public Object start(IApplicationContext applicationContext) throws Exception {
        IProduct product = Platform.getProduct();
        if (product.getName() != null) {
            Display.setAppName((String)product.getName());
        }
        Display display = this.getApplicationDisplay();
        E4Workbench workbench = this.createE4Workbench(applicationContext, display);
        Location instanceLocation = (Location)workbench.getContext().get("instanceLocation");
        Shell shell = display.getActiveShell();
        if (shell == null) {
            shell = new Shell();
        }
        try {
            if (!this.checkInstanceLocation(instanceLocation, shell)) {
                Integer n = EXIT_OK;
                return n;
            }
            IEclipseContext workbenchContext = workbench.getContext();
            workbenchContext.set(Display.class, (Object)display);
            workbench.createAndRunUI((MApplicationElement)workbench.getApplication());
            if (this.lcManager != null) {
                ContextInjectionFactory.invoke((Object)this.lcManager, PreSave.class, (IEclipseContext)workbenchContext, null);
            }
            this.saveModel();
            workbench.close();
            Integer n = EXIT_OK;
            return n;
        }
        finally {
            if (display != null) {
                display.dispose();
            }
            if (instanceLocation != null) {
                instanceLocation.release();
            }
        }
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public E4Workbench createE4Workbench(IApplicationContext applicationContext, final Display display) {
        this.args = (String[])applicationContext.getArguments().get("application.args");
        IEclipseContext appContext = E4Application.createDefaultContext();
        appContext.set(Realm.class, (Object)SWTObservables.getRealm((Display)display));
        appContext.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                display.syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                display.asyncExec(runnable);
            }
        });
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        if (!appContext.containsKey("org.eclipse.e4.ui.workbench.modeling.EModelService")) {
            throw new IllegalStateException("Core services not available. Please make sure that a declarative service implementation (such as the bundle 'org.eclipse.equinox.ds') is available!");
        }
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        String lifeCycleURI = this.getArgValue("lifeCycleURI", applicationContext, false);
        if (lifeCycleURI != null) {
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null) {
                ContextInjectionFactory.invoke((Object)this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, null);
            }
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        String rtlMode = this.getArgValue("dir", applicationContext, false);
        appModel.getTransientData().put("dir", "rtl".equals(rtlMode));
        if (!E4Workbench.getServiceContext().containsKey(MApplication.class.getName())) {
            E4Workbench.getServiceContext().set(MApplication.class.getName(), (Object)appModel);
        }
        appContext.set(MApplication.class.getName(), (Object)appModel);
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        for (MContribution addon : appModel.getAddons()) {
            Object obj = factory.create(addon.getContributionURI(), appContext);
            addon.setObject(obj);
        }
        String xmiURI = this.getArgValue("applicationXMI", applicationContext, false);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = this.getArgValue(THEME_ID, applicationContext, false);
        appContext.set(THEME_ID, (Object)themeId);
        String cssURI = this.getArgValue("applicationCSS", applicationContext, false);
        if (cssURI != null) {
            appContext.set("applicationCSS", (Object)cssURI);
        }
        if (cssURI != null && !cssURI.startsWith("platform:")) {
            System.err.println("Warning " + cssURI + " changed its meaning it is used now to run without theme support");
            appContext.set(THEME_ID, (Object)cssURI);
        }
        String cssResourcesURI = this.getArgValue("applicationCSSResources", applicationContext, false);
        appContext.set("applicationCSSResources", (Object)cssResourcesURI);
        appContext.set("rendererFactoryUri", (Object)this.getArgValue("rendererFactoryUri", applicationContext, false));
        String presentationURI = this.getArgValue("presentationURI", applicationContext, false);
        if (presentationURI == null) {
            presentationURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
        }
        appContext.set("presentationURI", (Object)presentationURI);
        this.workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        return this.workbench;
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        Location instanceLocation = WorkbenchSWTActivator.getDefault().getInstanceLocation();
        String appModelPath = this.getArgValue("applicationXMI", appContext, false);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", (Object)instanceLocation);
        String value = this.getArgValue("persistState", appContext, false);
        boolean saveAndRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("persistState", (Object)saveAndRestore);
        value = this.getArgValue("clearPersistedState", appContext, true);
        boolean clearPersistedState = value != null && Boolean.parseBoolean(value);
        eclipseContext.set("clearPersistedState", (Object)clearPersistedState);
        value = this.getArgValue("deltaRestore", appContext, false);
        boolean deltaRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("deltaRestore", (Object)deltaRestore);
        String resourceHandler = this.getArgValue("modelResourceHandler", appContext, false);
        if (resourceHandler == null) {
            resourceHandler = "platform:/plugin/org.eclipse.e4.ui.workbench/" + ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        this.upgradeToMArea_M3(eclipseContext, theApp);
        return theApp;
    }

    private void upgradeToMArea_M3(IEclipseContext applicationContext, MApplication application) {
        EModelService service = (EModelService)applicationContext.get(EModelService.class);
        block0: for (MWindow window : application.getChildren()) {
            List sharedElements = window.getSharedElements();
            for (MUIElement shared : sharedElements) {
                if (!"org.eclipse.ui.editorss".equals(shared.getElementId()) || !(shared instanceof MPartSashContainer) || shared instanceof MArea) continue;
                MArea area = AdvancedFactoryImpl.eINSTANCE.createArea();
                area.setLabel("Editor Area");
                area.setElementId(shared.getElementId());
                area.getChildren().add((MPartSashContainerElement)shared);
                area.setCurSharedRef(shared.getCurSharedRef());
                shared.setCurSharedRef(null);
                sharedElements.remove(shared);
                sharedElements.add(area);
                for (MPlaceholder placeholder : service.findElements((MUIElement)window, "org.eclipse.ui.editorss", MPlaceholder.class, null)) {
                    if (placeholder.getRef() != shared) continue;
                    placeholder.setRef((MUIElement)area);
                }
                continue block0;
            }
        }
    }

    private String getArgValue(String argName, IApplicationContext appContext, boolean singledCmdArgValue) {
        int i;
        if (argName == null || argName.length() == 0) {
            return null;
        }
        if (singledCmdArgValue) {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i]) && i + 1 < this.args.length) {
                    return this.args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = appContext.getBrandingProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    public void stop() {
        if (this.workbench != null) {
            this.workbench.close();
        }
    }

    public static IEclipseContext createDefaultContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        final IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(Logger.class.getName(), ContextInjectionFactory.make(WorkbenchLogger.class, (IEclipseContext)appContext));
        String locale = Locale.getDefault().toString();
        appContext.set("org.eclipse.e4.core.locale", (Object)locale);
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)appContext);
        appContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        if (appContext.get(ILoggerProvider.class) == null) {
            appContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(DefaultLoggerProvider.class, (IEclipseContext)appContext)));
        }
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.set("partServiceRoot", (Object)new ContextFunction(){

            private void log() {
                StatusReporter statusReporter = (StatusReporter)appContext.get(StatusReporter.class.getName());
                statusReporter.report((IStatus)new Status(4, E4Application.PLUGIN_ID, "Internal error, please post the trace to bug 315270", (Throwable)new Exception()), 32, new Object[0]);
            }

            public Object compute(IEclipseContext context) {
                MContext perceivedRoot = (MContext)context.get(MWindow.class.getName());
                if (perceivedRoot == null && (perceivedRoot = (MContext)context.get(MApplication.class.getName())) == null) {
                    IEclipseContext ctxt = appContext.getActiveChild();
                    if (ctxt == null) {
                        return null;
                    }
                    this.log();
                    return ctxt.get(MWindow.class);
                }
                IEclipseContext current = perceivedRoot.getContext();
                if (current == null) {
                    IEclipseContext ctxt = appContext.getActiveChild();
                    if (ctxt == null) {
                        return null;
                    }
                    this.log();
                    return ctxt.get(MWindow.class);
                }
                IEclipseContext next = current.getActiveChild();
                MPerspective candidate = null;
                while (next != null) {
                    current = next;
                    MPerspective perspective = (MPerspective)current.get(MPerspective.class);
                    if (perspective != null) {
                        candidate = perspective;
                    }
                    next = current.getActiveChild();
                }
                if (candidate != null) {
                    return candidate;
                }
                MUIElement window = (MUIElement)current.get(MWindow.class.getName());
                if (window == null) {
                    IEclipseContext ctxt = appContext.getActiveChild();
                    if (ctxt == null) {
                        return null;
                    }
                    this.log();
                    return ctxt.get(MWindow.class);
                }
                MElementContainer parent = window.getParent();
                while (parent != null && !(parent instanceof MApplication)) {
                    window = parent;
                    parent = parent.getParent();
                }
                return window;
            }
        });
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }

            public CSSStyleDeclaration getStyle(Object widget) {
                return null;
            }

            public void setClassnameAndId(Object widget, String classname, String id) {
            }
        });
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return null;
            }
        });
        return appContext;
    }

    private boolean checkInstanceLocation(Location instanceLocation, Shell shell) {
        if (instanceLocation == null) {
            MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceMandatoryTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLocation.isSet()) {
            block8: {
                if (!this.checkValidWorkspace(shell, instanceLocation.getURL())) {
                    return false;
                }
                if (!instanceLocation.lock()) break block8;
                E4Application.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLocation.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotLockTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotLockMessage);
                } else {
                    MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotBeSetTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
                logger.error((Throwable)e);
                MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.InternalError, (String)e.getMessage());
            }
            return false;
        }
        return false;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = E4Application.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = WorkbenchSWTMessages.IDEApplication_versionTitle;
        String message = NLS.bind((String)WorkbenchSWTMessages.IDEApplication_versionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = E4Application.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
            logger.error((Throwable)e);
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = E4Application.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=2";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
                    logger.error((Throwable)e);
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }
}

