/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jface.preference.IPreferenceStore;

public class CleanUpConstants {
    public static final int DEFAULT_CLEAN_UP_OPTIONS = 1;
    public static final int DEFAULT_SAVE_ACTION_OPTIONS = 2;
    public static final String FORMAT_SOURCE_CODE = "cleanup.format_source_code";
    public static final String FORMAT_SOURCE_CODE_CHANGES_ONLY = "cleanup.format_source_code_changes_only";
    public static final String FORMAT_COMMENT = "cleanup.format_comment";
    public static final String FORMAT_SINGLE_LINE_COMMENT = "cleanup.format_single_line_comment";
    public static final String FORMAT_MULTI_LINE_COMMENT = "cleanup.format_multi_line_comment";
    public static final String FORMAT_JAVADOC = "cleanup.format_javadoc";
    public static final String FORMAT_REMOVE_TRAILING_WHITESPACES = "cleanup.remove_trailing_whitespaces";
    public static final String FORMAT_REMOVE_TRAILING_WHITESPACES_ALL = "cleanup.remove_trailing_whitespaces_all";
    public static final String FORMAT_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY = "cleanup.remove_trailing_whitespaces_ignore_empty";
    public static final String FORMAT_CORRECT_INDENTATION = "cleanup.correct_indentation";
    public static final String MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS = "cleanup.use_this_for_non_static_field_access";
    public static final String MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_ALWAYS = "cleanup.always_use_this_for_non_static_field_access";
    public static final String MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_IF_NECESSARY = "cleanup.use_this_for_non_static_field_access_only_if_necessary";
    public static final String MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS = "cleanup.use_this_for_non_static_method_access";
    public static final String MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_ALWAYS = "cleanup.always_use_this_for_non_static_method_access";
    public static final String MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_IF_NECESSARY = "cleanup.use_this_for_non_static_method_access_only_if_necessary";
    public static final String MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS = "cleanup.qualify_static_member_accesses_with_declaring_class";
    public static final String MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_FIELD = "cleanup.qualify_static_field_accesses_with_declaring_class";
    public static final String MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_METHOD = "cleanup.qualify_static_method_accesses_with_declaring_class";
    public static final String MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_SUBTYPE_ACCESS = "cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class";
    public static final String MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_INSTANCE_ACCESS = "cleanup.qualify_static_member_accesses_through_instances_with_declaring_class";
    public static final String CONTROL_STATEMENTS_USE_BLOCKS = "cleanup.use_blocks";
    public static final String CONTROL_STATMENTS_USE_BLOCKS_ALWAYS = "cleanup.always_use_blocks";
    public static final String CONTROL_STATMENTS_USE_BLOCKS_NO_FOR_RETURN_AND_THROW = "cleanup.use_blocks_only_for_return_and_throw";
    public static final String CONTROL_STATMENTS_USE_BLOCKS_NEVER = "cleanup.never_use_blocks";
    public static final String CONTROL_STATMENTS_CONVERT_FOR_LOOP_TO_ENHANCED = "cleanup.convert_to_enhanced_for_loop";
    public static final String EXPRESSIONS_USE_PARENTHESES = "cleanup.use_parentheses_in_expressions";
    public static final String EXPRESSIONS_USE_PARENTHESES_ALWAYS = "cleanup.always_use_parentheses_in_expressions";
    public static final String EXPRESSIONS_USE_PARENTHESES_NEVER = "cleanup.never_use_parentheses_in_expressions";
    public static final String VARIABLE_DECLARATIONS_USE_FINAL = "cleanup.make_variable_declarations_final";
    public static final String VARIABLE_DECLARATIONS_USE_FINAL_PRIVATE_FIELDS = "cleanup.make_private_fields_final";
    public static final String VARIABLE_DECLARATIONS_USE_FINAL_PARAMETERS = "cleanup.make_parameters_final";
    public static final String VARIABLE_DECLARATIONS_USE_FINAL_LOCAL_VARIABLES = "cleanup.make_local_variable_final";
    public static final String VARIABLE_DECLARATION_USE_TYPE_ARGUMENTS_FOR_RAW_TYPE_REFERENCES = "cleanup.use_arguments_for_raw_type_references";
    public static final String REMOVE_UNUSED_CODE_IMPORTS = "cleanup.remove_unused_imports";
    public static final String REMOVE_UNUSED_CODE_PRIVATE_MEMBERS = "cleanup.remove_unused_private_members";
    public static final String REMOVE_UNUSED_CODE_PRIVATE_TYPES = "cleanup.remove_unused_private_types";
    public static final String REMOVE_UNUSED_CODE_PRIVATE_CONSTRUCTORS = "cleanup.remove_private_constructors";
    public static final String REMOVE_UNUSED_CODE_PRIVATE_FELDS = "cleanup.remove_unused_private_fields";
    public static final String REMOVE_UNUSED_CODE_PRIVATE_METHODS = "cleanup.remove_unused_private_methods";
    public static final String REMOVE_UNUSED_CODE_LOCAL_VARIABLES = "cleanup.remove_unused_local_variables";
    public static final String REMOVE_UNNECESSARY_CASTS = "cleanup.remove_unnecessary_casts";
    public static final String REMOVE_UNNECESSARY_NLS_TAGS = "cleanup.remove_unnecessary_nls_tags";
    public static final String ADD_MISSING_ANNOTATIONS = "cleanup.add_missing_annotations";
    public static final String ADD_MISSING_ANNOTATIONS_OVERRIDE = "cleanup.add_missing_override_annotations";
    public static final String ADD_MISSING_ANNOTATIONS_OVERRIDE_FOR_INTERFACE_METHOD_IMPLEMENTATION = "cleanup.add_missing_override_annotations_interface_methods";
    public static final String ADD_MISSING_ANNOTATIONS_DEPRECATED = "cleanup.add_missing_deprecated_annotations";
    public static final String ADD_MISSING_SERIAL_VERSION_ID = "cleanup.add_serial_version_id";
    public static final String ADD_MISSING_SERIAL_VERSION_ID_GENERATED = "cleanup.add_generated_serial_version_id";
    public static final String ADD_MISSING_SERIAL_VERSION_ID_DEFAULT = "cleanup.add_default_serial_version_id";
    public static final String ADD_MISSING_NLS_TAGS = "cleanup.add_missing_nls_tags";
    public static final String ORGANIZE_IMPORTS = "cleanup.organize_imports";
    public static final String SORT_MEMBERS = "cleanup.sort_members";
    public static final String SORT_MEMBERS_ALL = "cleanup.sort_members_all";
    public static final String ADD_MISSING_METHODES = "cleanup.add_missing_methods";
    public static final String SHOW_CLEAN_UP_WIZARD = "cleanup.showwizard";
    public static final String CLEANUP_PROFILES = "org.eclipse.jdt.ui.cleanupprofiles";
    public static final String CLEANUP_PROFILE = "cleanup_profile";
    public static final String CLEANUP_ON_SAVE_PROFILE = "cleanup.on_save_profile_id";
    public static final String CLEANUP_SETTINGS_VERSION_KEY = "cleanup_settings_version";
    public static final String ECLIPSE_PROFILE = "org.eclipse.jdt.ui.default.eclipse_clean_up_profile";
    public static final String SAVE_PARTICIPANT_PROFILE = "org.eclipse.jdt.ui.default.save_participant_clean_up_profile";
    public static final String CLEANUP_ON_SAVE_ADDITIONAL_OPTIONS = "cleanup.on_save_use_additional_actions";
    public static final String DEFAULT_PROFILE = "org.eclipse.jdt.ui.default.eclipse_clean_up_profile";
    public static final String DEFAULT_SAVE_PARTICIPANT_PROFILE = "org.eclipse.jdt.ui.default.save_participant_clean_up_profile";

    private static void setEclipseDefaultSettings(CleanUpOptions options) {
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_ALWAYS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_IF_NECESSARY, "true");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_ALWAYS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_IF_NECESSARY, "true");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS, "true");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_FIELD, "false");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_METHOD, "false");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_SUBTYPE_ACCESS, "true");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_INSTANCE_ACCESS, "true");
        options.setOption(CONTROL_STATEMENTS_USE_BLOCKS, "false");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_ALWAYS, "true");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_NO_FOR_RETURN_AND_THROW, "false");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_NEVER, "false");
        options.setOption(CONTROL_STATMENTS_CONVERT_FOR_LOOP_TO_ENHANCED, "false");
        options.setOption(EXPRESSIONS_USE_PARENTHESES, "false");
        options.setOption(EXPRESSIONS_USE_PARENTHESES_NEVER, "true");
        options.setOption(EXPRESSIONS_USE_PARENTHESES_ALWAYS, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_LOCAL_VARIABLES, "true");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_PARAMETERS, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_PRIVATE_FIELDS, "true");
        options.setOption(REMOVE_UNUSED_CODE_IMPORTS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_MEMBERS, "false");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_CONSTRUCTORS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_FELDS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_METHODS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_TYPES, "true");
        options.setOption(REMOVE_UNUSED_CODE_LOCAL_VARIABLES, "false");
        options.setOption(REMOVE_UNNECESSARY_CASTS, "true");
        options.setOption(REMOVE_UNNECESSARY_NLS_TAGS, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_OVERRIDE, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_OVERRIDE_FOR_INTERFACE_METHOD_IMPLEMENTATION, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_DEPRECATED, "true");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID, "false");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID_GENERATED, "false");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID_DEFAULT, "true");
        options.setOption(ADD_MISSING_NLS_TAGS, "false");
        options.setOption(ADD_MISSING_METHODES, "false");
        options.setOption("cleanup.make_type_abstract_if_missing_method", "false");
        options.setOption(FORMAT_SOURCE_CODE, "false");
        options.setOption(FORMAT_SOURCE_CODE_CHANGES_ONLY, "false");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES, "false");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES_ALL, "true");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY, "false");
        options.setOption(FORMAT_CORRECT_INDENTATION, "false");
        options.setOption(ORGANIZE_IMPORTS, "false");
        options.setOption(SORT_MEMBERS, "false");
        options.setOption(SORT_MEMBERS_ALL, "false");
    }

    private static void setSaveParticipantSettings(CleanUpOptions options) {
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_ALWAYS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_FIELD_USE_THIS_IF_NECESSARY, "true");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_ALWAYS, "false");
        options.setOption(MEMBER_ACCESSES_NON_STATIC_METHOD_USE_THIS_IF_NECESSARY, "true");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS, "false");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_FIELD, "false");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_METHOD, "false");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_SUBTYPE_ACCESS, "true");
        options.setOption(MEMBER_ACCESSES_STATIC_QUALIFY_WITH_DECLARING_CLASS_INSTANCE_ACCESS, "true");
        options.setOption(CONTROL_STATEMENTS_USE_BLOCKS, "false");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_ALWAYS, "true");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_NO_FOR_RETURN_AND_THROW, "false");
        options.setOption(CONTROL_STATMENTS_USE_BLOCKS_NEVER, "false");
        options.setOption(CONTROL_STATMENTS_CONVERT_FOR_LOOP_TO_ENHANCED, "false");
        options.setOption(EXPRESSIONS_USE_PARENTHESES, "false");
        options.setOption(EXPRESSIONS_USE_PARENTHESES_NEVER, "true");
        options.setOption(EXPRESSIONS_USE_PARENTHESES_ALWAYS, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL, "true");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_LOCAL_VARIABLES, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_PARAMETERS, "false");
        options.setOption(VARIABLE_DECLARATIONS_USE_FINAL_PRIVATE_FIELDS, "true");
        options.setOption(REMOVE_UNUSED_CODE_IMPORTS, "false");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_MEMBERS, "false");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_CONSTRUCTORS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_FELDS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_METHODS, "true");
        options.setOption(REMOVE_UNUSED_CODE_PRIVATE_TYPES, "true");
        options.setOption(REMOVE_UNUSED_CODE_LOCAL_VARIABLES, "false");
        options.setOption(REMOVE_UNNECESSARY_CASTS, "true");
        options.setOption(REMOVE_UNNECESSARY_NLS_TAGS, "false");
        options.setOption(ADD_MISSING_ANNOTATIONS, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_OVERRIDE, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_OVERRIDE_FOR_INTERFACE_METHOD_IMPLEMENTATION, "true");
        options.setOption(ADD_MISSING_ANNOTATIONS_DEPRECATED, "true");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID, "false");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID_GENERATED, "false");
        options.setOption(ADD_MISSING_SERIAL_VERSION_ID_DEFAULT, "true");
        options.setOption(ADD_MISSING_NLS_TAGS, "false");
        options.setOption(ADD_MISSING_METHODES, "false");
        options.setOption("cleanup.make_type_abstract_if_missing_method", "false");
        options.setOption(FORMAT_SOURCE_CODE, "false");
        options.setOption(FORMAT_SOURCE_CODE_CHANGES_ONLY, "false");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES, "false");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES_ALL, "true");
        options.setOption(FORMAT_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY, "false");
        options.setOption(FORMAT_CORRECT_INDENTATION, "false");
        options.setOption(ORGANIZE_IMPORTS, "true");
        options.setOption(SORT_MEMBERS, "false");
        options.setOption(SORT_MEMBERS_ALL, "false");
        options.setOption(CLEANUP_ON_SAVE_ADDITIONAL_OPTIONS, "false");
    }

    public static void initDefaults(IPreferenceStore store) {
        MapCleanUpOptions settings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1);
        for (String key : settings.getKeys()) {
            store.setDefault(key, settings.getValue(key));
        }
        store.setDefault(SHOW_CLEAN_UP_WIZARD, true);
        store.setDefault(CLEANUP_PROFILE, "org.eclipse.jdt.ui.default.eclipse_clean_up_profile");
        store.setDefault(CLEANUP_ON_SAVE_PROFILE, "org.eclipse.jdt.ui.default.save_participant_clean_up_profile");
    }

    public static void setDefaultOptions(int kind, CleanUpOptions options) {
        switch (kind) {
            case 1: {
                CleanUpConstants.setEclipseDefaultSettings(options);
                break;
            }
            case 2: {
                CleanUpConstants.setSaveParticipantSettings(options);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)("Unknown Clean Up option kind: " + kind));
            }
        }
    }
}

