/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelServiceImpl
implements EModelService {
    private boolean match(MUIElement element, String id, Class clazz, List<String> tagsToMatch) {
        if (id != null && !id.equals(element.getElementId())) {
            return false;
        }
        if (clazz != null && !clazz.isInstance(element)) {
            return false;
        }
        if (tagsToMatch != null) {
            List elementTags = element.getTags();
            for (String tag : tagsToMatch) {
                if (elementTags.contains(tag)) continue;
                return false;
            }
        }
        return true;
    }

    private <T> void findElementsRecursive(MUIElement searchRoot, String id, Class<? extends T> type, List<String> tagsToMatch, List<T> elements, int searchFlags) {
        MPlaceholder ph;
        Assert.isLegal((searchRoot != null ? 1 : 0) != 0);
        if (searchFlags == 0) {
            return;
        }
        if (this.match(searchRoot, id, type, tagsToMatch) && !elements.contains(searchRoot)) {
            elements.add(searchRoot);
        }
        if (searchRoot instanceof MElementContainer) {
            List children;
            MElementContainer container;
            if (searchRoot instanceof MPerspectiveStack) {
                if ((searchFlags & 4) != 0) {
                    container = (MElementContainer)searchRoot;
                    children = container.getChildren();
                    for (Object child : children) {
                        this.findElementsRecursive((MUIElement)child, id, type, tagsToMatch, elements, searchFlags);
                    }
                } else if ((searchFlags & 2) != 0) {
                    MPerspective active = (MPerspective)((MPerspectiveStack)searchRoot).getSelectedElement();
                    if (active != null) {
                        this.findElementsRecursive((MUIElement)active, id, type, tagsToMatch, elements, searchFlags);
                    }
                } else if ((searchFlags & 8) != 0) {
                    List<MArea> areas = this.findElements(searchRoot, null, MArea.class, null);
                    for (MArea area : areas) {
                        this.findElementsRecursive((MUIElement)area, id, type, tagsToMatch, elements, searchFlags);
                    }
                }
            } else {
                container = (MElementContainer)searchRoot;
                children = container.getChildren();
                for (Object child : children) {
                    this.findElementsRecursive((MUIElement)child, id, type, tagsToMatch, elements, searchFlags);
                }
            }
        }
        if (searchRoot instanceof MTrimmedWindow && (searchFlags & 0x10) != 0) {
            MTrimmedWindow tw = (MTrimmedWindow)searchRoot;
            List bars = tw.getTrimBars();
            for (MTrimBar bar : bars) {
                this.findElementsRecursive((MUIElement)bar, id, type, tagsToMatch, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MWindow) {
            MWindow window = (MWindow)searchRoot;
            for (MWindow dw : window.getWindows()) {
                this.findElementsRecursive((MUIElement)dw, id, type, tagsToMatch, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MPerspective) {
            MPerspective persp = (MPerspective)searchRoot;
            for (MWindow dw : persp.getWindows()) {
                this.findElementsRecursive((MUIElement)dw, id, type, tagsToMatch, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MPlaceholder && (!((ph = (MPlaceholder)searchRoot).getRef() instanceof MArea) || (searchFlags & 8) != 0)) {
            this.findElementsRecursive(ph.getRef(), id, type, tagsToMatch, elements, searchFlags);
        }
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, id, clazz, tagsToMatch, elements, 29);
        return elements;
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch, int searchFlags) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, id, clazz, tagsToMatch, elements, searchFlags);
        return elements;
    }

    public <T> List<T> findPerspectiveElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, id, clazz, tagsToMatch, elements, 11);
        return elements;
    }

    @Override
    public MUIElement find(String id, MUIElement searchRoot) {
        if (id == null || id.length() == 0) {
            return null;
        }
        List elements = this.findElements(searchRoot, id, null, null);
        if (elements.size() > 0) {
            return (MUIElement)elements.get(0);
        }
        return null;
    }

    @Override
    public int countRenderableChildren(MUIElement element) {
        if (!(element instanceof MElementContainer)) {
            return 0;
        }
        MElementContainer container = (MElementContainer)element;
        int count = 0;
        List kids = container.getChildren();
        for (MUIElement kid : kids) {
            if (!kid.isToBeRendered()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public IEclipseContext getContainingContext(MUIElement element) {
        return ModelUtils.getContainingContext((MApplicationElement)element);
    }

    @Override
    public MUIElement cloneElement(MUIElement element, String cloneId, boolean saveAsSnippet) {
        MWindow topWin;
        EObject eObj = (EObject)element;
        MUIElement clone = (MUIElement)EcoreUtil.copy((EObject)eObj);
        clone.setElementId(cloneId);
        if (saveAsSnippet && (topWin = this.getTopLevelWindowFor(element)) != null) {
            MElementContainer appElement = topWin.getParent();
            MApplication app = (MApplication)appElement;
            app.getClonableSnippets().add(clone);
        }
        return clone;
    }

    @Override
    public MUIElement cloneSnippet(MApplication app, String snippetId) {
        if (snippetId == null || snippetId.length() == 0) {
            return null;
        }
        MApplicationElement appElement = null;
        for (MApplicationElement snippet : app.getClonableSnippets()) {
            if (!snippetId.equals(snippet.getElementId())) continue;
            appElement = snippet;
            break;
        }
        if (appElement == null) {
            return null;
        }
        EObject eObj = (EObject)appElement;
        MUIElement element = (MUIElement)EcoreUtil.copy((EObject)eObj);
        return element;
    }

    @Override
    public void bringToTop(MUIElement element) {
        if (element instanceof MApplication) {
            return;
        }
        MWindow window = this.getTopLevelWindowFor(element);
        if (window == element) {
            if (!element.isToBeRendered()) {
                element.setToBeRendered(true);
            }
            window.getParent().setSelectedElement((MUIElement)window);
        } else {
            this.showElementInWindow(window, element);
        }
    }

    private void showElementInWindow(MWindow window, MUIElement element) {
        MPlaceholder ph;
        MElementContainer parent;
        if (element instanceof MPartStack && !element.isVisible()) {
            MToolControl trimCtrl;
            String trimId = String.valueOf(element.getElementId()) + "(minimized)";
            MPerspective persp = this.getPerspectiveFor(element);
            if (persp != null) {
                trimId = String.valueOf(element.getElementId()) + '(' + persp.getElementId() + ')';
            }
            if ((trimCtrl = (MToolControl)this.find(trimId, (MUIElement)window)) != null && trimCtrl.getObject() != null) {
                IEclipseContext ctxt = EclipseContextFactory.create();
                ctxt.set("show", (Object)true);
                ContextInjectionFactory.invoke((Object)trimCtrl.getObject(), Execute.class, (IEclipseContext)ctxt);
                ctxt.dispose();
            }
        }
        if ((parent = element.getParent()) == null && (ph = this.findPlaceholderFor(window, element)) != null) {
            element = ph;
            parent = element.getParent();
        }
        if (parent == null && element instanceof MWindow) {
            parent = (MUIElement)((EObject)element).eContainer();
            if (parent != null) {
                if (!element.isToBeRendered()) {
                    element.setToBeRendered(true);
                }
                if (window != parent) {
                    this.showElementInWindow(window, (MUIElement)parent);
                }
            }
        } else if (parent != null) {
            if (!element.isToBeRendered()) {
                element.setToBeRendered(true);
            }
            parent.setSelectedElement(element);
            if (window != parent) {
                this.showElementInWindow(window, (MUIElement)parent);
            }
        }
    }

    @Override
    public MPlaceholder findPlaceholderFor(MWindow window, MUIElement element) {
        List<MPlaceholder> phList = this.findPerspectiveElements((MUIElement)window, null, MPlaceholder.class, null);
        ArrayList<MPlaceholder> elementRefs = new ArrayList<MPlaceholder>();
        for (MPlaceholder ph : phList) {
            if (ph.getRef() != element) continue;
            elementRefs.add(ph);
        }
        if (elementRefs.size() == 0) {
            return null;
        }
        if (elementRefs.size() == 1) {
            return (MPlaceholder)elementRefs.get(0);
        }
        for (MPlaceholder refPh : elementRefs) {
            int loc = this.getElementLocation((MUIElement)refPh);
            if ((loc & 8) == 0) continue;
            return refPh;
        }
        return (MPlaceholder)elementRefs.get(0);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent) {
        this.move(element, newParent, -1, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, boolean leavePlaceholder) {
        this.move(element, newParent, -1, leavePlaceholder);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index) {
        this.move(element, newParent, index, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index, boolean leavePlaceholder) {
        MElementContainer curParent = element.getParent();
        int curIndex = curParent.getChildren().indexOf(element);
        newParent.getChildren().add(index, element);
        if (leavePlaceholder) {
            MPlaceholder ph = MAdvancedFactory.INSTANCE.createPlaceholder();
            ph.setRef(element);
            curParent.getChildren().add(curIndex, ph);
        }
    }

    public void swap(MPlaceholder placeholder) {
        MUIElement element = placeholder.getRef();
        MElementContainer elementParent = element.getParent();
        int elementIndex = elementParent.getChildren().indexOf(element);
        MElementContainer phParent = placeholder.getParent();
        int phIndex = phParent.getChildren().indexOf(placeholder);
        elementParent.getChildren().remove(element);
        phParent.getChildren().remove(placeholder);
        boolean onTop = element.isOnTop();
        boolean vis = element.isVisible();
        boolean tbr = element.isToBeRendered();
        element.setOnTop(placeholder.isOnTop());
        element.setVisible(placeholder.isVisible());
        element.setToBeRendered(placeholder.isToBeRendered());
        placeholder.setOnTop(onTop);
        placeholder.setVisible(vis);
        placeholder.setToBeRendered(tbr);
        elementParent.getChildren().add(elementIndex, placeholder);
        phParent.getChildren().add(phIndex, element);
    }

    private void combine(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, MPartSashContainer newSash, boolean newFirst, int ratio) {
        MElementContainer curParent = relTo.getParent();
        int index = curParent.getChildren().indexOf(relTo);
        curParent.getChildren().remove(relTo);
        if (newFirst) {
            newSash.getChildren().add(toInsert);
            newSash.getChildren().add(relTo);
        } else {
            newSash.getChildren().add(relTo);
            newSash.getChildren().add(toInsert);
        }
        int adjustedPct = ratio * 100;
        toInsert.setContainerData(Integer.toString(adjustedPct));
        relTo.setContainerData(Integer.toString(10000 - adjustedPct));
        curParent.getChildren().add(index, newSash);
    }

    @Override
    public void insert(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, int where, int ratio) {
        if (toInsert == null || relTo == null) {
            return;
        }
        if (ratio == 0) {
            ratio = 1000;
        }
        if (ratio > 10000) {
            ratio = 9000;
        }
        boolean newFirst = where == 0 || where == 2;
        MElementContainer insertRoot = relTo.getParent();
        while (insertRoot != null && !(insertRoot instanceof MWindow) && !(insertRoot instanceof MPartSashContainer)) {
            relTo = (MPartSashContainerElement)insertRoot;
            insertRoot = insertRoot.getParent();
        }
        if (insertRoot instanceof MWindow || insertRoot instanceof MArea) {
            MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            newSash.setHorizontal(where == 2 || where == 3);
            this.combine(toInsert, relTo, newSash, newFirst, ratio);
        } else if (insertRoot instanceof MGenericTile) {
            MGenericTile curTile = (MGenericTile)insertRoot;
            if (curTile.isHorizontal() && (where == 0 || where == 1)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(false);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else if (!(curTile.isHorizontal() || where != 2 && where != 3)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(true);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else {
                int relToIndex = relTo.getParent().getChildren().indexOf(relTo);
                if (newFirst) {
                    curTile.getChildren().add(relToIndex, toInsert);
                } else {
                    curTile.getChildren().add(relToIndex + 1, toInsert);
                }
                int relToWeight = 100;
                if (relTo.getContainerData() != null) {
                    try {
                        relToWeight = Integer.parseInt(relTo.getContainerData());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                int toInsertWeight = (int)((double)ratio / 100.0 * (double)relToWeight + 0.5);
                relTo.setContainerData(Integer.toString(relToWeight -= toInsertWeight));
                toInsert.setContainerData(Integer.toString(toInsertWeight));
            }
        }
    }

    @Override
    public void detach(MPartSashContainerElement element, int x, int y, int width, int height) {
        MElementContainer curParent = element.getParent();
        MPartSashContainerElement current = element;
        MWindow window = this.getTopLevelWindowFor((MUIElement)element);
        while (!(curParent instanceof MPerspective) && !(curParent instanceof MWindow)) {
            if (curParent == null) {
                if ((current = this.findPlaceholderFor(window, (MUIElement)current)) == null) {
                    return;
                }
                curParent = current.getParent();
                if (curParent == null) {
                    return;
                }
            }
            current = curParent;
            curParent = current.getParent();
        }
        MTrimmedWindow newWindow = BasicFactoryImpl.INSTANCE.createTrimmedWindow();
        newWindow.setX(x);
        newWindow.setY(y);
        newWindow.setWidth(width);
        newWindow.setHeight(height);
        element.getParent().getChildren().remove(element);
        MWindowElement uiRoot = this.wrapElementForWindow(element);
        newWindow.getChildren().add(uiRoot);
        if (curParent instanceof MPerspective) {
            MPerspective persp = (MPerspective)curParent;
            persp.getWindows().add(newWindow);
        } else if (curParent instanceof MWindow) {
            ((MWindow)curParent).getWindows().add(newWindow);
        }
    }

    private MWindowElement wrapElementForWindow(MPartSashContainerElement element) {
        if (element instanceof MPlaceholder) {
            MUIElement ref = ((MPlaceholder)element).getRef();
            if (ref instanceof MPart) {
                MPartStack newPS = MBasicFactory.INSTANCE.createPartStack();
                newPS.getChildren().add((MPlaceholder)element);
                return newPS;
            }
        } else {
            if (element instanceof MPart) {
                MPartStack newPS = MBasicFactory.INSTANCE.createPartStack();
                newPS.getChildren().add((MPart)element);
                return newPS;
            }
            if (element instanceof MWindowElement) {
                return (MWindowElement)element;
            }
        }
        return null;
    }

    @Override
    public MTrimBar getTrim(MTrimmedWindow window, SideValue sv) {
        List bars = window.getTrimBars();
        for (MTrimBar bar : bars) {
            if (bar.getSide() != sv) continue;
            return bar;
        }
        MTrimBar newBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        newBar.setSide(sv);
        window.getTrimBars().add(newBar);
        return newBar;
    }

    @Override
    public MWindow getTopLevelWindowFor(MUIElement element) {
        EObject eObj = (EObject)element;
        while (eObj != null && !(eObj.eContainer() instanceof MApplication)) {
            eObj = eObj.eContainer();
        }
        if (eObj instanceof MWindow) {
            return (MWindow)eObj;
        }
        return null;
    }

    @Override
    public MPerspective getPerspectiveFor(MUIElement element) {
        while (true) {
            EObject container;
            MPlaceholder placeholder;
            if ((placeholder = element.getCurSharedRef()) != null) {
                element = placeholder;
            }
            if ((container = ((EObject)element).eContainer()) == null || container instanceof MApplication) {
                return null;
            }
            if (container instanceof MPerspectiveStack) {
                return (MPerspective)element;
            }
            element = (MUIElement)container;
        }
    }

    @Override
    public void resetPerspectiveModel(MPerspective persp, MWindow window) {
        if (persp == null) {
            return;
        }
        for (MWindow win : persp.getWindows()) {
            win.setToBeRendered(false);
        }
        persp.getWindows().clear();
        EPartService ps = (EPartService)window.getContext().get(EPartService.class);
        List<MArea> areas = this.findElements((MUIElement)window, null, MArea.class, null);
        if (areas.size() == 1) {
            MArea area = areas.get(0);
            List<MPlaceholder> phList = this.findElements((MUIElement)area, null, MPlaceholder.class, null);
            for (MPlaceholder ph : phList) {
                ps.hidePart((MPart)ph.getRef());
                ph.getParent().getChildren().remove(ph);
            }
            List<MPartStack> stacks = this.findElements((MUIElement)area, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                String generatedId = "PartStack@" + Integer.toHexString(stack.hashCode());
                stack.setElementId(generatedId);
            }
        }
        List<MTrimBar> bars = this.findElements((MUIElement)window, null, MTrimBar.class, null);
        ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
        for (MTrimBar bar : bars) {
            for (MUIElement barKid : bar.getChildren()) {
                String id;
                if (!(barKid instanceof MToolControl) || (id = barKid.getElementId()) == null || !id.contains(persp.getElementId())) continue;
                toRemove.add((MToolControl)barKid);
            }
        }
        IEclipseContext ctxt = EclipseContextFactory.create();
        ctxt.set("show", (Object)false);
        for (MToolControl toolControl : toRemove) {
            if (toolControl.getObject() != null && toolControl.getObject().getClass().getName().contains("TrimStack")) {
                ContextInjectionFactory.invoke((Object)toolControl.getObject(), Execute.class, (IEclipseContext)ctxt);
            }
            toolControl.setToBeRendered(false);
            toolControl.getParent().getChildren().remove(toolControl);
        }
        ctxt.dispose();
    }

    @Override
    public void removePerspectiveModel(MPerspective persp, MWindow window) {
        MElementContainer psElement = persp.getParent();
        MPerspectiveStack ps = (MPerspectiveStack)psElement;
        boolean foundNewSelection = false;
        if (ps.getSelectedElement() == persp) {
            for (MPerspective p : ps.getChildren()) {
                if (p == persp || !p.isToBeRendered()) continue;
                ps.setSelectedElement((MUIElement)p);
                foundNewSelection = true;
                break;
            }
            if (!foundNewSelection) {
                ps.setSelectedElement(null);
            }
        }
        this.resetPerspectiveModel(persp, window);
        persp.setToBeRendered(false);
        ps.getChildren().remove(persp);
    }

    @Override
    public MPerspective getActivePerspective(MWindow window) {
        List<MPerspectiveStack> pStacks = this.findElements((MUIElement)window, null, MPerspectiveStack.class, null);
        if (pStacks.size() == 1) {
            return (MPerspective)pStacks.get(0).getSelectedElement();
        }
        return null;
    }

    @Override
    public int toBeRenderedCount(MElementContainer<?> container) {
        int count = 0;
        for (MUIElement child : container.getChildren()) {
            if (!child.isToBeRendered()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MUIElement getContainer(MUIElement element) {
        if (element == null) {
            return null;
        }
        return (MUIElement)((EObject)element).eContainer();
    }

    @Override
    public int getElementLocation(MUIElement element) {
        if (element == null) {
            return 0;
        }
        MUIElement curElement = element;
        while (curElement != null) {
            EObject container;
            MElementContainer parent = curElement.getParent();
            if (parent instanceof MPerspective) {
                MElementContainer perspectiveParent = parent.getParent();
                if (perspectiveParent == null) {
                    return 0;
                }
                if (perspectiveParent.getSelectedElement() == parent) {
                    return 2;
                }
                return 4;
            }
            if (parent instanceof MApplication) {
                return 1;
            }
            if (parent instanceof MTrimBar) {
                return 16;
            }
            if (parent == null && (container = ((EObject)curElement).eContainer()) instanceof MWindow) {
                MWindow containerWin = (MWindow)container;
                if (containerWin.getSharedElements().contains(curElement)) {
                    return 8;
                }
                EObject containerParent = container.eContainer();
                if (containerParent instanceof MPerspective) {
                    MElementContainer perspectiveParent = ((MPerspective)containerParent).getParent();
                    if (perspectiveParent == null) {
                        return 0;
                    }
                    int location = 4;
                    if (perspectiveParent.getSelectedElement() == containerParent) {
                        location |= 2;
                    }
                    return location;
                }
                if (containerParent instanceof MWindow) {
                    return 1;
                }
                return 0;
            }
            curElement = parent;
        }
        return 0;
    }

    @Override
    public void hideLocalPlaceholders(MWindow window, MPerspective perspective) {
        List<MPlaceholder> globals = this.findElements((MUIElement)window, null, MPlaceholder.class, null, 9);
        List<MPerspective> persps = new ArrayList<MPerspective>();
        if (perspective != null) {
            persps.add(perspective);
        } else {
            persps = this.findElements((MUIElement)window, null, MPerspective.class, null);
        }
        for (MPerspective persp : persps) {
            List<MPlaceholder> locals = this.findElements((MUIElement)persp, null, MPlaceholder.class, null, 4);
            for (MPlaceholder local : locals) {
                for (MPlaceholder global : globals) {
                    if (global.getRef() != local.getRef()) continue;
                    local.setToBeRendered(false);
                    MElementContainer localParent = local.getParent();
                    this.setStackVisibility((MElementContainer<MUIElement>)localParent);
                }
            }
        }
    }

    private void setStackVisibility(MElementContainer<MUIElement> parent) {
        for (MUIElement child : parent.getChildren()) {
            if (!child.isToBeRendered() || !child.isVisible()) continue;
            parent.setToBeRendered(true);
            return;
        }
        parent.setToBeRendered(false);
    }

    @Override
    public boolean isLastEditorStack(MUIElement stack) {
        if (!(stack instanceof MPartStack)) {
            return false;
        }
        MElementContainer parent = stack.getParent();
        while (parent != null && !(parent instanceof MArea)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return false;
        }
        MArea area = (MArea)parent;
        List<MPartStack> stacks = this.findElements((MUIElement)area, null, MPartStack.class, null);
        int count = 0;
        for (MPartStack aStack : stacks) {
            if (!aStack.isToBeRendered()) continue;
            ++count;
        }
        return count < 2 && stack.isToBeRendered();
    }
}

