/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SplitDropAgent
extends DropAgent {
    private static final int NOWHERE = -1;
    private MPartStack dropStack;
    private CTabFolder dropCTF;
    private Rectangle clientBounds;
    private String weight;
    private int curDockLocation = -1;
    private Rectangle ctfBounds;
    private MUIElement outerRelTo;
    private Rectangle ocBounds;
    private boolean outerDock;

    public SplitDropAgent(DnDManager manager) {
        super(manager);
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        this.dropStack = null;
        if (info.curElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)info.curElement;
            if (this.dndManager.getModelService().isLastEditorStack((MUIElement)stack)) {
                this.dropStack = stack;
            }
        }
        if (this.dropStack == null) {
            if (!(info.curElement instanceof MStackElement) && !this.dndManager.getModelService().isLastEditorStack(info.curElement)) {
                return false;
            }
            MElementContainer parent = info.curElement.getParent();
            if (info.curElement instanceof MPart && info.curElement.getCurSharedRef() != null) {
                parent = info.curElement.getCurSharedRef().getParent();
            }
            if (!(parent instanceof MPartStack) || !(parent.getWidget() instanceof CTabFolder)) {
                return false;
            }
            this.dropStack = (MPartStack)parent;
        }
        this.weight = this.dropStack.getContainerData();
        this.dropCTF = (CTabFolder)this.dropStack.getWidget();
        return true;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        MElementContainer relToParent;
        super.dragEnter(dragElement, info);
        this.clientBounds = this.dropCTF.getClientArea();
        this.clientBounds = Display.getCurrent().map((Control)this.dropCTF, null, this.clientBounds);
        this.ctfBounds = this.dropCTF.getBounds();
        this.ctfBounds = Display.getCurrent().map((Control)this.dropCTF.getParent(), null, this.ctfBounds);
        this.outerRelTo = this.dropStack.getParent();
        if (this.outerRelTo instanceof MPartSashContainer) {
            while (this.outerRelTo != null && !(this.outerRelTo.getWidget() instanceof Composite)) {
                this.outerRelTo = this.outerRelTo.getParent();
            }
        }
        this.outerRelTo = this.outerRelTo instanceof MArea ? this.outerRelTo.getCurSharedRef() : (this.outerRelTo instanceof MPartSashContainer ? ((relToParent = this.outerRelTo.getParent()) instanceof MArea ? relToParent.getCurSharedRef() : (relToParent instanceof MPerspective ? relToParent.getParent() : null)) : null);
        if (this.outerRelTo != null) {
            Composite outerComposite = (Composite)this.outerRelTo.getWidget();
            this.ocBounds = outerComposite.getBounds();
            this.ocBounds = Display.getCurrent().map((Control)outerComposite.getParent(), null, this.ocBounds);
        } else {
            this.ocBounds = null;
        }
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 3) {
            this.unDock(dragElement);
        }
        this.dndManager.clearOverlay();
        this.curDockLocation = -1;
        super.dragLeave(dragElement, info);
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 1 && this.curDockLocation != -1) {
            this.dock(dragElement, this.curDockLocation);
        }
        return true;
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (!this.clientBounds.contains(info.cursorPos)) {
            return false;
        }
        boolean curOuter = this.outerDock;
        int dockLocation = this.getDockLocation(info);
        if (dockLocation == this.curDockLocation && curOuter == this.outerDock) {
            return true;
        }
        if (this.dropStack == dragElement && !this.outerDock) {
            return false;
        }
        this.curDockLocation = dockLocation;
        if (this.curDockLocation != -1) {
            Rectangle dockBounds = this.getDockBounds(this.curDockLocation);
            if (this.dndManager.getFeedbackStyle() == 1) {
                this.dock(dragElement, this.curDockLocation);
            } else if (this.dndManager.getFeedbackStyle() == 2) {
                this.dndManager.setHostBounds(dockBounds);
            }
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.unDock(dragElement);
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
        }
        return true;
    }

    private Rectangle getDockBounds(int location) {
        if (!this.outerDock) {
            Rectangle bounds = new Rectangle(this.ctfBounds.x, this.ctfBounds.y, this.ctfBounds.width, this.ctfBounds.height);
            this.dndManager.frameRect(this.ctfBounds);
            if (location == 0) {
                bounds.height /= 2;
            } else if (location == 1) {
                bounds.height /= 2;
                bounds.y += bounds.height;
            } else if (location == 2) {
                bounds.width /= 2;
            } else if (location == 3) {
                bounds.width /= 2;
                bounds.x += bounds.width;
            }
            bounds.x += 8;
            bounds.y += 8;
            bounds.width -= 16;
            bounds.height -= 16;
            this.dndManager.addFrame(bounds);
        } else {
            Rectangle bounds = new Rectangle(this.ocBounds.x, this.ocBounds.y, this.ocBounds.width, this.ocBounds.height);
            int splitWidth = (int)((double)bounds.width * 0.34);
            int splitHeight = (int)((double)bounds.height * 0.34);
            if (location == 0) {
                Rectangle topRect = new Rectangle(bounds.x, bounds.y, bounds.width, splitHeight);
                Rectangle bottomRect = new Rectangle(bounds.x, bounds.y + splitHeight + 3, bounds.width, bounds.height - splitHeight - 3);
                this.dndManager.frameRect(topRect);
                this.dndManager.frameRect(bottomRect);
            } else if (location == 1) {
                Rectangle topRect = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - splitHeight);
                Rectangle bottomRect = new Rectangle(bounds.x, bounds.y + bounds.height - splitHeight + 8, bounds.width, splitHeight - 8);
                this.dndManager.frameRect(topRect);
                this.dndManager.addFrame(bottomRect);
            } else if (location == 2) {
                Rectangle leftRect = new Rectangle(bounds.x, bounds.y, splitWidth, bounds.height);
                Rectangle rightRect = new Rectangle(bounds.x + splitWidth + 8, bounds.y, bounds.width - splitWidth - 8, bounds.height);
                this.dndManager.frameRect(leftRect);
                this.dndManager.addFrame(rightRect);
            } else if (location == 3) {
                Rectangle leftRect = new Rectangle(bounds.x, bounds.y, bounds.width - splitWidth, bounds.height);
                Rectangle rightRect = new Rectangle(bounds.x + bounds.width - splitWidth + 8, bounds.y, splitWidth - 8, bounds.height);
                this.dndManager.frameRect(leftRect);
                this.dndManager.addFrame(rightRect);
            }
        }
        return null;
    }

    private int getDockLocation(DnDInfo info) {
        int minDy;
        if (this.outerRelTo != null) {
            if (info.cursorPos.x - this.ocBounds.x < 30) {
                this.outerDock = true;
                return 2;
            }
            if (this.ocBounds.x + this.ocBounds.width - info.cursorPos.x < 30) {
                this.outerDock = true;
                return 3;
            }
            if (info.cursorPos.y - this.ocBounds.y < 30) {
                this.outerDock = true;
                return 0;
            }
            if (this.ocBounds.y + this.ocBounds.height - info.cursorPos.y < 30) {
                this.outerDock = true;
                return 1;
            }
        }
        this.outerDock = false;
        int dx = info.cursorPos.x - this.clientBounds.x;
        int dy = info.cursorPos.y - this.clientBounds.y;
        int dxr = this.clientBounds.x + this.clientBounds.width - info.cursorPos.x;
        int dyr = this.clientBounds.y + this.clientBounds.height - info.cursorPos.y;
        int minDx = Math.min(dx, dxr);
        if (minDx < (minDy = Math.min(dy, dyr))) {
            return dx < dxr ? 2 : 3;
        }
        return dy < dyr ? 0 : 1;
    }

    protected void unDock(MUIElement dragElement) {
        this.dndManager.clearOverlay();
        this.dndManager.setHostBounds(null);
        this.dndManager.setDragHostVisibility(true);
    }

    protected boolean dock(MUIElement dragElement, int where) {
        MPartStack toInsert;
        this.dndManager.setDragHostVisibility(false);
        MPartStack relTo = this.dropStack;
        if (this.outerDock) {
            relTo = (MPartSashContainerElement)this.outerRelTo;
        }
        if (dragElement instanceof MPartStack) {
            toInsert = (MPartStack)dragElement;
            toInsert.getParent().getChildren().remove(toInsert);
        } else {
            MStackElement stackElement = (MStackElement)dragElement;
            toInsert = BasicFactoryImpl.eINSTANCE.createPartStack();
            toInsert.getChildren().add(stackElement);
            toInsert.setSelectedElement((MUIElement)stackElement);
        }
        int ratio = this.outerDock ? 34 : 50;
        MElementContainer relToParent = relTo.getParent();
        this.dndManager.getModelService().insert((MPartSashContainerElement)toInsert, (MPartSashContainerElement)relTo, where, ratio);
        if (relTo.getParent() != relToParent && !this.outerDock) {
            relTo.getParent().setContainerData(this.weight);
        }
        this.dndManager.update();
        return true;
    }
}

