/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.MenuTrackingData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int handle;
    short id;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean modified;
    boolean closed;
    boolean ignoreMatch;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    MenuItem lastTarget;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            Point where = new Point();
            TrayItem trayItem = this.display.currentTrayItem;
            if (trayItem != null) {
                this.display.trayItemMenu = this;
                org.eclipse.swt.graphics.Point pt = trayItem.getMenuLocation();
                where.h = (short)pt.x;
                where.v = (short)pt.y;
            } else if (this.hasLocation) {
                where.h = (short)this.x;
                where.v = (short)this.y;
            } else {
                OS.GetGlobalMouse(where);
            }
            this.sendEvent(22);
            this.modified = false;
            OS.ContextualMenuSelect(this.handle, where, false, 3, null, null, new int[1], new short[1], new short[1]);
        } else {
            OS.CancelMenuTracking(this.handle, true, 0);
        }
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        int[] outMenuRef = new int[1];
        OS.CreateNewMenu(this.id, 0, outMenuRef);
        if (outMenuRef[0] == 0) {
            this.display.removeMenu(this);
            this.error(2);
        }
        this.handle = outMenuRef[0];
    }

    void createItem(MenuItem item, int index) {
        int result;
        this.checkWidget();
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        int attributes = 2560;
        if ((item.style & 2) != 0) {
            attributes = 64;
        }
        if ((result = OS.InsertMenuItemTextWithCFString(this.handle, 0, (short)index, attributes, 0)) != 0) {
            this.error(14);
        }
        if (this.itemCount == this.items.length) {
            MenuItem[] newItems = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        this.modified = true;
        int emptyMenu = item.createEmptyMenu();
        if (emptyMenu != 0) {
            OS.SetMenuItemHierarchicalMenu(this.handle, (short)(index + 1), emptyMenu);
            OS.ReleaseMenu(emptyMenu);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void destroyItem(MenuItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.modified = true;
        OS.DeleteMenuItem(this.handle, (short)(index + 1));
    }

    void destroyWidget() {
        int theMenu = this.handle;
        this.releaseHandle();
        if (theMenu != 0) {
            OS.DisposeMenu(theMenu);
        }
    }

    void fixMenus(Decorations newParent) {
        this.parent = newParent;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            Menu menu = this.display._getMenuBar();
            if (this != menu) {
                return new Rectangle(0, 0, 0, 0);
            }
            int height = OS.GetMBarHeight();
            int gdevice = OS.GetMainDevice();
            int[] ptr = new int[1];
            OS.memmove(ptr, gdevice, 4);
            GDevice device = new GDevice();
            OS.memmove(device, ptr[0], 62);
            return new Rectangle(0, 0, device.right - device.left, height);
        }
        OS.CalcMenuSize(this.handle);
        return new Rectangle(this.x, this.y, 0, 0);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] result = new MenuItem[this.itemCount];
        int index = 0;
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    result[index++] = item;
                }
                ++i;
            }
        }
        if (index != result.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(result, 0, newItems, 0, index);
            result = newItems;
        }
        return result;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        MenuTrackingData outData;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.GetMenuTrackingData(this.handle, outData = new MenuTrackingData()) == 0;
    }

    void hookEvents() {
        super.hookEvents();
        int menuProc = this.display.menuProc;
        int[] mask = new int[]{1835363957, 1004, 1835363957, 5, 1835363957, 1005, 1835363957, 102, 1835363957, 103, 1835363957, 100, 1835363957, 4, 1835363957, 6, 1835363957, 7};
        int menuTarget = OS.GetMenuEventTarget(this.handle);
        OS.InstallEventHandler(menuTarget, menuProc, mask.length / 2, mask, this.handle, null);
    }

    int kEventMenuCalculateSize(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuCalculateSize(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 1668575852, 1668575852, null, 4, null, theControl);
        int menuProc = this.display.menuProc;
        int[] mask = new int[]{1835363957, 1006};
        int controlTarget = OS.GetControlEventTarget(theControl[0]);
        OS.InstallEventHandler(controlTarget, menuProc, mask.length / 2, mask, this.handle, null);
        return result;
    }

    int kEventMenuClosed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuClosed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.closed = true;
        boolean send = true;
        if (this.cascade != null && !this.cascade.getEnabled()) {
            send = false;
        }
        if (send) {
            this.sendEvent(23);
        }
        return -9874;
    }

    int kEventMenuCreateFrameView(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuCreateFrameView(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 1668575852, 1668575852, null, 4, null, theControl);
        int menuProc = this.display.menuProc;
        int[] mask = new int[]{1835363957, 1006};
        int controlTarget = OS.GetControlEventTarget(theControl[0]);
        OS.InstallEventHandler(controlTarget, menuProc, mask.length / 2, mask, this.handle, null);
        return -9874;
    }

    int kEventMenuDrawItem(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuDrawItem(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        return -9874;
    }

    int kEventMenuDrawItemContent(int nextHandler, int theEvent, int userData) {
        String accelText;
        int length;
        int accelIndex;
        int result = super.kEventMenuDrawItemContent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        short[] index = new short[1];
        OS.GetEventParameter(theEvent, 1769235821, 1835623544, null, 2, null, index);
        if (index[0] <= 0 || index[0] > this.itemCount) {
            return result;
        }
        MenuItem item = this.items[index[0] - 1];
        if (item.accelerator == 0 && !item.acceleratorSet && (accelIndex = item.text.indexOf(9)) != -1 && (length = (accelText = item.text.substring(accelIndex + 1)).length()) != 0) {
            result = OS.CallNextEventHandler(nextHandler, theEvent);
            Rect rect = new Rect();
            OS.GetEventParameter(theEvent, 1835627618, 1902408308, null, 8, null, rect);
            int[] context = new int[1];
            OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
            int modifierIndex = this.modifierIndex(accelText);
            char[] buffer = new char[length - modifierIndex - 1];
            accelText.getChars(modifierIndex + 1, length, buffer, 0);
            int themeFont = 101;
            if (buffer.length > 1) {
                themeFont = 103;
            }
            byte[] family = new byte[256];
            short[] size = new short[1];
            byte[] style = new byte[1];
            OS.GetThemeFont((short)themeFont, (short)-1, family, size, style);
            short id = OS.FMGetFontFamilyFromName(family);
            int[] font = new int[1];
            OS.FMGetFontFromFontFamilyInstance(id, style[0], font, null);
            int atsFont = OS.FMGetATSFontRefFromFont(font[0]);
            ATSFontMetrics fontMetrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(atsFont, 0, fontMetrics);
            OS.ATSFontGetHorizontalMetrics(atsFont, 0, fontMetrics);
            int[] metric = new int[1];
            OS.GetThemeMetric(69, metric);
            int str = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            Point size1 = new Point();
            OS.GetThemeTextDimensions(str, (short)themeFont, 0, false, size1, null);
            rect.left = (short)(rect.right - Math.max((int)(fontMetrics.maxAdvanceWidth * (float)size[0]), size1.h) - metric[0]);
            OS.DrawThemeTextBox(str, (short)themeFont, 1, false, rect, (short)-2, context[0]);
            OS.CFRelease(str);
            if (modifierIndex != -1) {
                buffer = new char[modifierIndex + 1];
                accelText.getChars(0, buffer.length, buffer, 0);
                str = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                OS.GetThemeTextDimensions(str, (short)103, 0, false, size1, null);
                rect.right = rect.left;
                rect.left = (short)(rect.right - size1.h);
                OS.DrawThemeTextBox(str, (short)103, 1, false, rect, (short)-2, context[0]);
                OS.CFRelease(str);
            }
            return result;
        }
        return -9874;
    }

    int kEventMenuGetFrameBounds(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuGetFrameBounds(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        return result;
    }

    int kEventMenuMatchKey(int nextHandler, int theEvent, int userData) {
        if (this.ignoreMatch) {
            return -9874;
        }
        int[] menuIndex = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1835363957, null, 4, null, menuIndex);
        int[] eventRef = new int[1];
        OS.GetEventParameter(theEvent, 1702260340, 1702261350, null, 4, null, eventRef);
        int options = 7;
        short[] index = new short[1];
        this.ignoreMatch = true;
        boolean isMenuKeyEvent = OS.IsMenuKeyEvent(menuIndex[0], eventRef[0], options, null, index);
        this.ignoreMatch = false;
        if (isMenuKeyEvent && index[0] >= 0 && index[0] < this.items.length) {
            MenuItem item = this.items[index[0] - 1];
            if (item.accelerator == 0) {
                return -5622;
            }
        }
        return -9874;
    }

    int kEventMenuMeasureItemWidth(int nextHandler, int theEvent, int userData) {
        String accelText;
        int accelIndex;
        int result = super.kEventMenuMeasureItemWidth(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        short[] index = new short[1];
        OS.GetEventParameter(theEvent, 1769235821, 1835623544, null, 2, null, index);
        if (index[0] <= 0 || index[0] > this.itemCount) {
            return result;
        }
        MenuItem item = this.items[index[0] - 1];
        if (item.accelerator == 0 && !item.acceleratorSet && (accelIndex = item.text.indexOf(9)) != -1 && (accelText = item.text.substring(accelIndex + 1)).length() != 0) {
            result = OS.CallNextEventHandler(nextHandler, theEvent);
            char[] buffer = new char[accelText.length()];
            accelText.getChars(0, buffer.length, buffer, 0);
            int str = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            Point size = new Point();
            OS.GetThemeTextDimensions(str, (short)103, 0, false, size, null);
            OS.CFRelease(str);
            short[] width = new short[1];
            OS.GetEventParameter(theEvent, 1835627639, 1936224114, null, 2, null, width);
            int[] metric = new int[1];
            OS.GetThemeMetric(67, metric);
            width[0] = (short)(width[0] + (metric[0] + size.h));
            OS.SetEventParameter(theEvent, 1835627639, 1936224114, 2, width);
            return result;
        }
        return -9874;
    }

    int kEventMenuOpening(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuOpening(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.closed = false;
        if ((this.style & 8) == 0) {
            boolean send = true;
            if (this.cascade != null && !this.cascade.getEnabled()) {
                send = false;
            }
            if (send) {
                this.sendEvent(22);
                this.modified = false;
            }
        }
        return -9874;
    }

    int kEventMenuTargetItem(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuTargetItem(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.lastTarget = null;
        short[] index = new short[1];
        if (OS.GetEventParameter(theEvent, 1769235821, 1835623544, null, 2, null, index) == 0) {
            if (index[0] > 0 && index[0] <= this.itemCount) {
                this.lastTarget = this.items[index[0] - 1];
            }
            if (this.lastTarget != null) {
                this.lastTarget.sendEvent(30);
            }
        }
        return -9874;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int modifierIndex(String accelText) {
        int start;
        int index = start = accelText.length() - 1;
        while (index >= 0) {
            char c = accelText.charAt(index);
            switch (c) {
                case ' ': {
                    if (index == start) break;
                    return index;
                }
                case '\u21e7': 
                case '\u2303': 
                case '\u2318': 
                case '\u2325': {
                    return index;
                }
            }
            --index;
        }
        return -1;
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.lastTarget = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            this.state &= 0xFFFFFFF7;
            OS.EnableMenuItem(this.handle, (short)0);
        } else {
            this.state |= 8;
            OS.DisableMenuItem(this.handle, (short)0);
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

