/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.properties;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.properties.PropertiesMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class ApiFiltersPropertyPage
extends PropertyPage {
    TreeViewer fViewer = null;
    Button fRemoveButton;
    Button fEditButton = null;
    Text fCommentText = null;
    private IProject fProject = null;
    ArrayList fDeleteSet = new ArrayList();
    ArrayList fEditSet = new ArrayList();
    private ArrayList fInputset = null;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createWrapLabel(comp, PropertiesMessages.ApiFiltersPropertyPage_55, 2);
        Tree tree = new Tree(comp, 68354);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && e.stateMask == 0) {
                    ApiFiltersPropertyPage.this.handleRemove((IStructuredSelection)ApiFiltersPropertyPage.this.fViewer.getSelection());
                }
            }
        });
        this.fViewer = new TreeViewer(tree);
        this.fViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ApiToolsLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new ApiFilterComparator());
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !ApiFiltersPropertyPage.this.fDeleteSet.contains(element);
            }
        });
        try {
            IApiFilterStore store = this.getFilterStore();
            if (store != null) {
                this.fInputset = new ArrayList<IResource>(Arrays.asList(store.getResources()));
                this.fViewer.setInput((Object)this.fInputset);
            }
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                int size = ss.size();
                ApiFiltersPropertyPage.this.fRemoveButton.setEnabled(size > 0);
                if (size == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof IApiProblemFilter) {
                        IApiProblemFilter filter = (IApiProblemFilter)element;
                        String comment = filter.getComment();
                        ApiFiltersPropertyPage.this.fEditButton.setEnabled(true);
                        if (comment != null) {
                            ApiFiltersPropertyPage.this.fCommentText.setText(comment);
                        } else {
                            ApiFiltersPropertyPage.this.fCommentText.setText("");
                        }
                    } else {
                        ApiFiltersPropertyPage.this.fEditButton.setEnabled(false);
                        ApiFiltersPropertyPage.this.fCommentText.setText("");
                    }
                } else {
                    ApiFiltersPropertyPage.this.fEditButton.setEnabled(false);
                    ApiFiltersPropertyPage.this.fCommentText.setText("");
                }
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (ApiFiltersPropertyPage.this.fViewer.isExpandable(o)) {
                    ApiFiltersPropertyPage.this.fViewer.setExpandedState(o, !ApiFiltersPropertyPage.this.fViewer.getExpandedState(o));
                } else if (o instanceof IApiProblemFilter) {
                    IApiProblemFilter filter = (IApiProblemFilter)o;
                    ApiFiltersPropertyPage.this.handleEdit(filter);
                }
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1040, 0, 0);
        this.fEditButton = SWTFactory.createPushButton(bcomp, PropertiesMessages.ApiFiltersPropertyPage_edit_button, null, 16384);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ApiFiltersPropertyPage.this.fViewer.getSelection();
                ApiFiltersPropertyPage.this.handleEdit((IApiProblemFilter)ss.getFirstElement());
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = SWTFactory.createPushButton(bcomp, PropertiesMessages.ApiFiltersPropertyPage_57, null, 16384);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ApiFiltersPropertyPage.this.fViewer.getSelection();
                ApiFiltersPropertyPage.this.handleRemove(ss);
            }
        });
        this.fRemoveButton.setEnabled(false);
        SWTFactory.createLabel(comp, PropertiesMessages.ApiFiltersPropertyPage_comment, 2);
        this.fCommentText = SWTFactory.createText(comp, 2880, 2, 200, 100, 768);
        this.fCommentText.setEditable(false);
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            this.fViewer.setSelection((ISelection)new StructuredSelection(item.getData()), true);
            this.fViewer.expandToLevel(item.getData(), 1);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APITOOLS_FILTERS_PROPERTY_PAGE);
        return comp;
    }

    void handleEdit(IApiProblemFilter filter) {
        String orignal;
        String comment = orignal = filter.getComment();
        InputDialog dialog = new InputDialog(this.getShell(), PropertiesMessages.ApiFiltersPropertyPage_edit_comment, PropertiesMessages.ApiFiltersPropertyPage_edit_filter_comment, comment, null);
        if (dialog.open() == 0) {
            comment = dialog.getValue();
            if (comment != null && comment.length() < 1) {
                comment = null;
            }
            ((ApiProblemFilter)filter).setComment(comment);
            CommentChange change = new CommentChange(filter, orignal);
            int idx = this.fEditSet.indexOf(change);
            if (idx < 0) {
                this.fEditSet.add(change);
            }
            this.fViewer.refresh((Object)filter, true);
            this.fViewer.setSelection(this.fViewer.getSelection(), true);
        }
    }

    void handleRemove(IStructuredSelection selection) {
        ArrayList comments = new ArrayList();
        HashSet deletions = this.collectDeletions(selection, comments);
        boolean refresh = false;
        if (deletions.size() > 0) {
            this.fDeleteSet.addAll(deletions);
            int[] indexes = this.getIndexes(selection);
            this.fViewer.remove(deletions.toArray());
            this.updateParents();
            refresh = true;
            this.updateSelection(indexes);
        }
        if (comments.size() > 0) {
            int i = 0;
            while (i < comments.size()) {
                ApiProblemFilter filter = (ApiProblemFilter)comments.get(i);
                CommentChange change = new CommentChange((IApiProblemFilter)filter, filter.getComment());
                int idx = this.fEditSet.indexOf(filter);
                if (idx < 0) {
                    this.fEditSet.add(change);
                }
                filter.setComment(null);
                refresh = true;
                ++i;
            }
        }
        if (refresh) {
            this.fViewer.refresh(true);
            this.fViewer.setSelection(this.fViewer.getSelection(), true);
        }
    }

    private int[] getIndexes(IStructuredSelection selection) {
        int[] indexes = new int[2];
        TreeSelection tsel = (TreeSelection)selection;
        TreePath path = tsel.getPaths()[0];
        TreeItem parent = (TreeItem)this.fViewer.testFindItem(path.getFirstSegment());
        if (parent != null) {
            Tree tree = this.fViewer.getTree();
            indexes[0] = tree.indexOf(parent);
            TreeItem item = (TreeItem)this.fViewer.testFindItem(path.getLastSegment());
            if (item != null) {
                indexes[1] = parent.indexOf(item);
            }
        }
        return indexes;
    }

    private void updateSelection(int[] indexes) {
        Tree tree = this.fViewer.getTree();
        TreeItem parent = null;
        if (tree.getItemCount() == 0) {
            return;
        }
        if (indexes[0] < tree.getItemCount()) {
            TreeItem child = null;
            parent = tree.getItem(indexes[0]);
            int childcount = parent.getItemCount();
            if (childcount < 1 || indexes[1] < 0) {
                this.fViewer.setSelection((ISelection)new StructuredSelection(parent.getData()));
                return;
            }
            child = indexes[1] < childcount ? parent.getItem(indexes[1]) : parent.getItem(childcount - 1);
            this.fViewer.setSelection((ISelection)new StructuredSelection(child.getData()));
        } else {
            parent = tree.getItem(tree.getItemCount() - 1);
            this.fViewer.setSelection((ISelection)new StructuredSelection(parent.getData()));
        }
    }

    private void updateParents() {
        Tree tree = this.fViewer.getTree();
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getItems().length < 1) {
                this.fInputset.remove(items[i].getData());
            }
            ++i;
        }
    }

    private HashSet collectDeletions(IStructuredSelection selection, ArrayList comments) {
        HashSet<Object> filters = new HashSet<Object>();
        Object node = null;
        Object[] children = null;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            TreeItem item;
            node = iter.next();
            if (node instanceof IResource) {
                children = ((TreeContentProvider)this.fViewer.getContentProvider()).getChildren(node);
                filters.addAll(Arrays.asList(children));
                this.fInputset.remove(node);
                continue;
            }
            if (node instanceof IApiProblemFilter) {
                filters.add(node);
                continue;
            }
            if (!(node instanceof String) || (item = (TreeItem)this.fViewer.testFindItem(node)) == null) continue;
            comments.add(item.getParentItem().getData());
        }
        return filters;
    }

    private IProject getProject() {
        if (this.fProject == null) {
            IAdaptable iAdaptable = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fProject = (IProject)iAdaptable.getAdapter((Class)clazz);
        }
        return this.fProject;
    }

    IApiFilterStore getFilterStore() throws CoreException {
        IApiComponent component;
        IProject project = this.getProject();
        IApiFilterStore store = null;
        if (project != null && (component = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project)) != null) {
            return component.getFilterStore();
        }
        return store;
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this.fEditSet.size()) {
            CommentChange change = (CommentChange)this.fEditSet.get(i);
            ((ApiProblemFilter)change.filter).setComment(change.comment);
            ++i;
        }
        this.fEditSet.clear();
        return super.performCancel();
    }

    public boolean performOk() {
        try {
            IWorkspace workspace;
            boolean needsbuild = false;
            if (this.fDeleteSet.size() > 0) {
                IApiProblemFilter[] apiProblemFilters = this.fDeleteSet.toArray(new IApiProblemFilter[this.fDeleteSet.size()]);
                this.getFilterStore().removeFilters(apiProblemFilters);
                int i = 0;
                int max = apiProblemFilters.length;
                while (i < max) {
                    IResource resource;
                    String resourcePath;
                    IApiProblemFilter filter = apiProblemFilters[i];
                    IApiProblem apiProblem = filter.getUnderlyingProblem();
                    if (apiProblem != null && (resourcePath = apiProblem.getResourcePath()) != null && (resource = this.fProject.findMember(resourcePath)) != null) {
                        Util.touchCorrespondingResource((IProject)this.fProject, (IResource)resource, (String)apiProblem.getTypeName());
                    }
                    ++i;
                }
                needsbuild = true;
            } else if (this.fEditSet.size() > 0) {
                ApiFilterStore store = (ApiFilterStore)this.getFilterStore();
                store.needsSaving();
                store.persistApiFilters();
            }
            if (needsbuild && !(workspace = ResourcesPlugin.getWorkspace()).isAutoBuilding() && MessageDialog.openQuestion((Shell)this.getShell(), (String)PropertiesMessages.ApiFiltersPropertyPage_58, (String)MessageFormat.format((String)PropertiesMessages.ApiFiltersPropertyPage_59, (Object[])new String[]{this.fProject.getName()}))) {
                Util.getBuildJob((IProject[])new IProject[]{this.fProject}, (int)10).schedule();
            }
            this.fEditSet.clear();
            this.fDeleteSet.clear();
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return super.performOk();
    }

    static class ApiFilterComparator
    extends WorkbenchViewerComparator {
        ApiFilterComparator() {
        }

        public int category(Object element) {
            if (element instanceof IApiProblemFilter) {
                return ((IApiProblemFilter)element).getUnderlyingProblem().getCategory();
            }
            return -1;
        }
    }

    class CommentChange {
        IApiProblemFilter filter = null;
        String comment = null;

        public CommentChange(IApiProblemFilter filter, String orig) {
            this.filter = filter;
            this.comment = orig;
        }

        public boolean equals(Object obj) {
            return this.filter.equals(obj);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IResource) {
                try {
                    return ApiFiltersPropertyPage.this.getFilterStore().getFilters((IResource)parentElement);
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IResource) {
                try {
                    return ApiFiltersPropertyPage.this.getFilterStore().getFilters((IResource)element).length > 0;
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

