/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExceptionAnalyzer
extends ASTVisitor {
    private List<ITypeBinding> fCurrentExceptions;
    private Stack<List<ITypeBinding>> fTryStack = new Stack();

    protected AbstractExceptionAnalyzer() {
        this.fCurrentExceptions = new ArrayList<ITypeBinding>(1);
        this.fTryStack.push(this.fCurrentExceptions);
    }

    public abstract boolean visit(ThrowStatement var1);

    public abstract boolean visit(MethodInvocation var1);

    public abstract boolean visit(ClassInstanceCreation var1);

    public boolean visit(TypeDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    public boolean visit(EnumDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(TryStatement node) {
        this.fCurrentExceptions = new ArrayList<ITypeBinding>(1);
        this.fTryStack.push(this.fCurrentExceptions);
        node.getBody().accept((ASTVisitor)this);
        List catchClauses = node.catchClauses();
        if (!catchClauses.isEmpty()) {
            this.handleCatchArguments(catchClauses);
        }
        List<ITypeBinding> current = this.fTryStack.pop();
        this.fCurrentExceptions = this.fTryStack.peek();
        Iterator<Object> iter = current.iterator();
        while (iter.hasNext()) {
            this.addException(iter.next());
        }
        iter = catchClauses.iterator();
        while (iter.hasNext()) {
            ((CatchClause)iter.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    protected void addExceptions(ITypeBinding[] exceptions) {
        if (exceptions == null) {
            return;
        }
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i]);
            ++i;
        }
    }

    protected void addException(ITypeBinding exception) {
        if (!this.fCurrentExceptions.contains(exception)) {
            this.fCurrentExceptions.add(exception);
        }
    }

    protected List<ITypeBinding> getCurrentExceptions() {
        return this.fCurrentExceptions;
    }

    private void handleCatchArguments(List<CatchClause> catchClauses) {
        for (CatchClause clause : catchClauses) {
            ITypeBinding catchTypeBinding = clause.getException().getType().resolveBinding();
            if (catchTypeBinding == null) continue;
            for (ITypeBinding throwTypeBinding : new ArrayList<ITypeBinding>(this.fCurrentExceptions)) {
                if (!this.catches(catchTypeBinding, throwTypeBinding)) continue;
                this.fCurrentExceptions.remove(throwTypeBinding);
            }
        }
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }
}

