/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodSelectionDialog
extends ElementListSelectionDialog {
    private IJavaElement fElement;

    public TestMethodSelectionDialog(Shell shell, IJavaElement element) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(2050));
        this.fElement = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.junit.test_selection_context");
    }

    public int open() {
        Object[] elements;
        IType testType = this.findTestType();
        if (testType == null) {
            return 1;
        }
        try {
            elements = this.searchTestMethods(this.fElement, testType);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.TestMethodSelectionDialog_error_title, (String)e.getTargetException().getMessage());
            return 1;
        }
        if (elements.length == 0) {
            String msg = Messages.format((String)JUnitMessages.TestMethodSelectionDialog_notfound_message, (Object)JavaElementLabels.getElementLabel((IJavaElement)this.fElement, (long)JavaElementLabels.ALL_DEFAULT));
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)JUnitMessages.TestMethodSelectionDialog_no_tests_title, (String)msg);
            return 1;
        }
        this.setElements(elements);
        return super.open();
    }

    private IType findTestType() {
        String qualifiedName = "junit.framework.Test";
        HashSet<IType> result = new HashSet<IType>();
        try {
            IJavaProject[] projects;
            IJavaProject[] iJavaProjectArray = projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject project = iJavaProjectArray[n2];
                IType type = project.findType(qualifiedName);
                if (type != null) {
                    result.add(type);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.TestMethodSelectionDialog_error_notfound_title, (String)JUnitMessages.TestMethodSelectionDialog_error_notfound_message, (IStatus)e.getStatus());
            return null;
        }
        if (result.size() == 0) {
            String msg = Messages.format((String)JUnitMessages.TestMethodSelectionDialog_test_not_found, (Object)BasicElementLabels.getJavaElementName((String)"junit.framework.Test"));
            MessageDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.TestMethodSelectionDialog_select_dialog_title, (String)msg);
            return null;
        }
        if (result.size() == 1) {
            return (IType)result.toArray()[0];
        }
        return this.selectTestType(result);
    }

    private IType selectTestType(Set<IType> result) {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(66);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getParentShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(JUnitMessages.TestMethodSelectionDialog_dialog_title);
        String msg = Messages.format((String)JUnitMessages.TestMethodSelectionDialog_testproject, (Object)BasicElementLabels.getJavaElementName((String)"junit.framework.Test"));
        dialog.setMessage(msg);
        Object[] projects = new IJavaProject[result.size()];
        IType[] testTypes = result.toArray(new IType[result.size()]);
        int i = 0;
        while (i < projects.length) {
            projects[i] = testTypes[i].getJavaProject();
            ++i;
        }
        dialog.setElements(projects);
        if (dialog.open() == 1) {
            return null;
        }
        IJavaProject project = (IJavaProject)dialog.getFirstResult();
        IType[] iTypeArray = testTypes;
        int n = testTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType testType = iTypeArray[n2];
            if (testType.getJavaProject().equals(project)) {
                return testType;
            }
            ++n2;
        }
        return null;
    }

    public Object[] searchTestMethods(final IJavaElement element, final IType testType) throws InvocationTargetException, InterruptedException {
        final TestReferenceCollector[] col = new TestReferenceCollector[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    col[0] = TestMethodSelectionDialog.this.doSearchTestMethods(element, testType, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        return col[0].getResult();
    }

    private TestReferenceCollector doSearchTestMethods(IJavaElement element, IType testType, IProgressMonitor pm) throws CoreException {
        int matchRule = 24;
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)2, (int)matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)testType);
        TestReferenceCollector requestor = new TestReferenceCollector();
        new SearchEngine().search(pattern, participants, scope, (SearchRequestor)requestor, pm);
        return requestor;
    }

    public static class TestReferenceCollector
    extends SearchRequestor {
        Set<IJavaElement> fResult = new HashSet<IJavaElement>(200);

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IJavaElement enclosingElement = (IJavaElement)match.getElement();
            if (enclosingElement.getElementName().startsWith("test")) {
                this.fResult.add(enclosingElement);
            }
        }

        public Object[] getResult() {
            return this.fResult.toArray();
        }
    }
}

