/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewElement;

public class ViewProvider
extends QuickAccessProvider {
    private MApplication application;
    private MWindow window;
    private Map<String, QuickAccessElement> idToElement = new HashMap<String, QuickAccessElement>();

    public ViewProvider(MApplication application, MWindow window) {
        this.application = application;
        this.window = window;
    }

    public String getId() {
        return "org.eclipse.e4.ui.parts";
    }

    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return this.idToElement.get(id);
    }

    public QuickAccessElement[] getElements() {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return new QuickAccessElement[0];
        }
        if (this.idToElement.isEmpty()) {
            List descriptors = this.application.getDescriptors();
            int i = 0;
            while (i < descriptors.size()) {
                String id;
                MPartDescriptor descriptor = (MPartDescriptor)descriptors.get(i);
                String uri = descriptor.getContributionURI();
                if (uri != null && !uri.equals("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor") && (id = descriptor.getElementId()) != null) {
                    ViewElement element = new ViewElement(this, this.window, (MPartDescriptor)descriptors.get(i));
                    this.idToElement.put(element.getId(), element);
                }
                ++i;
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
    }

    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_VIEW_DEFAULTVIEW_MISC");
    }

    public String getName() {
        return QuickAccessMessages.QuickAccess_Views;
    }

    protected void doReset() {
        this.idToElement.clear();
    }
}

