/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.sourcelookup;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.sourcelookup.PDESourceLookupQuery;

public class PDESourceLookupDirector
extends AbstractSourceLookupDirector {
    private Map fSourceContainerMap = new HashMap();
    private static Set fFilteredTypes = new HashSet(3);
    private double fOSGiRuntimeVersion = Double.MIN_VALUE;

    static {
        fFilteredTypes.add(ProjectSourceContainer.TYPE_ID);
        fFilteredTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fFilteredTypes.add("org.eclipse.debug.ui.containerType.workingSet");
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new JavaSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return !fFilteredTypes.contains(type.getId());
    }

    public Object getSourceElement(Object element) {
        PDESourceLookupQuery query = new PDESourceLookupQuery(this, element);
        SafeRunner.run((ISafeRunnable)query);
        Object result = query.getResult();
        return result != null ? result : super.getSourceElement(element);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = null;
        if (object instanceof IJavaStackFrame || object instanceof IJavaObject || object instanceof IJavaReferenceType) {
            sourceElements = new Object[]{this.getSourceElement(object)};
        }
        if (sourceElements == null) {
            sourceElements = super.findSourceElements(object);
        }
        return sourceElements;
    }

    ISourceContainer[] getSourceContainers(String location, String id) throws CoreException {
        ISourceContainer[] containers = (ISourceContainer[])this.fSourceContainerMap.get(location);
        if (containers != null) {
            return containers;
        }
        ArrayList<IRuntimeClasspathEntry> result = new ArrayList<IRuntimeClasspathEntry>();
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        boolean match = false;
        IPluginModelBase[] models = entry.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            if (this.isPerfectMatch(models[i], (IPath)new Path(location))) {
                IResource resource = models[i].getUnderlyingResource();
                if (resource != null) {
                    this.addProjectSourceContainers(resource.getProject(), result);
                }
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            ISourceContainer container;
            File file = new File(location);
            if (file.isFile() && (container = this.getArchiveSourceContainer(location)) != null) {
                containers = new ISourceContainer[]{container};
                this.fSourceContainerMap.put(location, containers);
                return containers;
            }
            models = entry.getExternalModels();
            int i2 = 0;
            while (i2 < models.length) {
                if (this.isPerfectMatch(models[i2], (IPath)new Path(location))) {
                    IClasspathEntry[] entries = PDEClasspathContainer.getExternalEntries((IPluginModelBase)models[i2]);
                    int j = 0;
                    while (j < entries.length) {
                        IRuntimeClasspathEntry rte = this.convertClasspathEntry(entries[j]);
                        if (rte != null) {
                            result.add(rte);
                        }
                        ++j;
                    }
                    break;
                }
                ++i2;
            }
        }
        IRuntimeClasspathEntry[] entries = result.toArray(new IRuntimeClasspathEntry[result.size()]);
        containers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])entries);
        this.fSourceContainerMap.put(location, containers);
        return containers;
    }

    private boolean isPerfectMatch(IPluginModelBase model, IPath path) {
        return model == null ? false : path.equals((Object)new Path(model.getInstallLocation()));
    }

    private IRuntimeClasspathEntry convertClasspathEntry(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath srcPath = entry.getSourceAttachmentPath();
        if (srcPath != null && srcPath.segmentCount() > 0) {
            IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
            rte.setSourceAttachmentPath(srcPath);
            rte.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
            return rte;
        }
        return null;
    }

    private ISourceContainer getArchiveSourceContainer(String location) throws JavaModelException {
        IWorkspaceRoot root = PDELaunchingPlugin.getWorkspace().getRoot();
        IFile[] containers = root.findFilesForLocationURI(URIUtil.toURI((String)location));
        int i = 0;
        while (i < containers.length) {
            IPackageFragmentRoot archive;
            IPath path;
            IJavaElement element = JavaCore.create((IFile)containers[i]);
            if (element instanceof IPackageFragmentRoot && (path = (archive = (IPackageFragmentRoot)element).getSourceAttachmentPath()) != null && path.segmentCount() != 0) {
                IPath rootPath = archive.getSourceAttachmentRootPath();
                boolean detectRootPath = rootPath != null && rootPath.segmentCount() > 0;
                IFile archiveFile = root.getFile(path);
                if (archiveFile.exists()) {
                    return new ArchiveSourceContainer(archiveFile, detectRootPath);
                }
                File file = path.toFile();
                if (file.exists()) {
                    return new ExternalArchiveSourceContainer(file.getAbsolutePath(), detectRootPath);
                }
            }
            ++i;
        }
        return null;
    }

    private void addProjectSourceContainers(IProject project, ArrayList result) throws CoreException {
        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        result.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jProject));
        IClasspathEntry[] entries = jProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry rte;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 1 && (rte = this.convertClasspathEntry(entry)) != null) {
                result.add(rte);
            }
            ++i;
        }
    }

    public synchronized void dispose() {
        Iterator iterator = this.fSourceContainerMap.values().iterator();
        while (iterator.hasNext()) {
            ISourceContainer[] containers = (ISourceContainer[])iterator.next();
            int i = 0;
            while (i < containers.length) {
                containers[i].dispose();
                ++i;
            }
        }
        this.fSourceContainerMap.clear();
        super.dispose();
    }

    double getOSGiRuntimeVersion() {
        if (this.fOSGiRuntimeVersion == Double.MIN_VALUE) {
            this.fOSGiRuntimeVersion = TargetPlatformHelper.getTargetVersion();
        }
        return this.fOSGiRuntimeVersion;
    }
}

