/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ZipFileStructureCreator;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.CompareWithOtherResourceDialog;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ResourceCompareInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private boolean fThreeWay = false;
    private Object fRoot;
    private IStructureComparator fAncestor;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;
    private IResource fAncestorResource;
    private IResource fLeftResource;
    private IResource fRightResource;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    ResourceCompareInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (ResourceCompareInput.this.fOpenAction == null) {
                    ResourceCompareInput.this.fOpenAction = (IAction)new Action(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1, null);
                        }
                    };
                    Utilities.initAction(ResourceCompareInput.this.fOpenAction, this.getBundle(), "action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement te = ((MyDiffNode)element).getId();
                        if (te != null) {
                            enable = !"FOLDER".equals(te.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                ResourceCompareInput.this.fOpenAction.setEnabled(enable);
                manager.add(ResourceCompareInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }

            static /* synthetic */ void access$0(2 var0, SelectionEvent selectionEvent) {
                var0.handleOpen(selectionEvent);
            }
        };
        return this.fDiffViewer;
    }

    boolean setSelection(ISelection s, Shell shell, boolean showSelectAncestorDialog) {
        if (!showSelectAncestorDialog) {
            return this.showCompareWithOtherResourceDialog(shell, s);
        }
        IResource[] selection = Utilities.getResources(s);
        boolean bl = this.fThreeWay = selection.length == 3;
        if (this.fThreeWay) {
            SelectAncestorDialog dialog = new SelectAncestorDialog(shell, selection);
            int code = dialog.open();
            if (code != 0) {
                return false;
            }
            this.fAncestorResource = dialog.ancestorResource;
            this.fAncestor = this.getStructure(this.fAncestorResource);
            this.fLeftResource = dialog.leftResource;
            this.fRightResource = dialog.rightResource;
        } else {
            this.fAncestorResource = null;
            this.fAncestor = null;
            this.fLeftResource = selection[0];
            this.fRightResource = selection[1];
        }
        this.fLeft = this.getStructure(this.fLeftResource);
        this.fRight = this.getStructure(this.fRightResource);
        return true;
    }

    private boolean showCompareWithOtherResourceDialog(Shell shell, ISelection s) {
        CompareWithOtherResourceDialog dialog = new CompareWithOtherResourceDialog(shell, s);
        if (dialog.open() != 0) {
            return false;
        }
        IResource[] selection = dialog.getResult();
        if (!this.checkSelection(selection)) {
            return false;
        }
        boolean bl = this.fThreeWay = selection.length == 3;
        if (this.fThreeWay) {
            this.fAncestorResource = selection[0];
            this.fAncestor = this.getStructure(this.fAncestorResource);
            this.fLeftResource = selection[1];
            this.fRightResource = selection[2];
        } else {
            this.fAncestorResource = null;
            this.fAncestor = null;
            this.fLeftResource = selection[0];
            this.fRightResource = selection[1];
        }
        this.fLeft = this.getStructure(this.fLeftResource);
        this.fRight = this.getStructure(this.fRightResource);
        return true;
    }

    private boolean checkSelection(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(ISelection s) {
        boolean threeWay;
        IResource[] selection = Utilities.getResources(s);
        if (selection.length < 2 || selection.length > 3) {
            return false;
        }
        boolean bl = threeWay = selection.length == 3;
        if (threeWay) {
            return this.comparable(selection[0], selection[1]) && this.comparable(selection[0], selection[2]) && this.comparable(selection[1], selection[2]);
        }
        return this.comparable(selection[0], selection[1]);
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeftResource != null) {
            cc.setLeftLabel(this.buildLabel(this.fLeftResource));
            cc.setLeftImage(CompareUIPlugin.getImage((IAdaptable)this.fLeftResource));
        }
        if (this.fRightResource != null) {
            cc.setRightLabel(this.buildLabel(this.fRightResource));
            cc.setRightImage(CompareUIPlugin.getImage((IAdaptable)this.fRightResource));
        }
        if (this.fThreeWay && this.fAncestorResource != null) {
            cc.setAncestorLabel(this.buildLabel(this.fAncestorResource));
            cc.setAncestorImage(CompareUIPlugin.getImage((IAdaptable)this.fAncestorResource));
        }
    }

    private boolean comparable(IResource c1, IResource c2) {
        return this.hasStructure(c1) == this.hasStructure(c2);
    }

    private boolean hasStructure(IResource input) {
        IFile file;
        String type;
        if (input instanceof IContainer) {
            return true;
        }
        if (input instanceof IFile && (type = (file = (IFile)input).getFileExtension()) != null) {
            return "JAR".equals(type = ResourceCompareInput.normalizeCase(type)) || "ZIP".equals(type);
        }
        return false;
    }

    private IStructureComparator getStructure(IResource input) {
        if (input instanceof IContainer) {
            return new FilteredBufferedResourceNode(input);
        }
        if (input instanceof IFile) {
            FilteredBufferedResourceNode rn = new FilteredBufferedResourceNode(input);
            IFile file = (IFile)input;
            String type = ResourceCompareInput.normalizeCase(file.getFileExtension());
            if ("JAR".equals(type) || "ZIP".equals(type)) {
                return new ZipFileStructureCreator().getStructure(rn);
            }
            return rn;
        }
        return null;
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            String title;
            String format;
            this.fLeftResource.refreshLocal(2, pm);
            this.fRightResource.refreshLocal(2, pm);
            if (this.fThreeWay && this.fAncestorResource != null) {
                this.fAncestorResource.refreshLocal(2, pm);
            }
            pm.beginTask(Utilities.getString("ResourceCompare.taskName"), -1);
            String leftLabel = this.fLeftResource.getName();
            String rightLabel = this.fRightResource.getName();
            if (this.fThreeWay) {
                format = Utilities.getString("ResourceCompare.threeWay.title");
                String ancestorLabel = this.fAncestorResource.getName();
                title = MessageFormat.format((String)format, (Object[])new String[]{ancestorLabel, leftLabel, rightLabel});
            } else {
                format = Utilities.getString("ResourceCompare.twoWay.title");
                title = MessageFormat.format((String)format, (Object[])new String[]{leftLabel, rightLabel});
            }
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(this.fThreeWay, pm, null, this.fAncestor, this.fLeft, this.fRight);
            return object;
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex);
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        if (this.fLeftResource != null && this.fRightResource != null) {
            String leftLabel = this.fLeftResource.getFullPath().makeRelative().toString();
            String rightLabel = this.fRightResource.getFullPath().makeRelative().toString();
            if (this.fThreeWay) {
                String format = Utilities.getString("ResourceCompare.threeWay.tooltip");
                String ancestorLabel = this.fAncestorResource.getFullPath().makeRelative().toString();
                return MessageFormat.format((String)format, (Object[])new String[]{ancestorLabel, leftLabel, rightLabel});
            }
            String format = Utilities.getString("ResourceCompare.twoWay.tooltip");
            return MessageFormat.format((String)format, (Object[])new String[]{leftLabel, rightLabel});
        }
        return super.getToolTipText();
    }

    private String buildLabel(IResource r) {
        if (r.isLinked() && r.getProject().isHidden()) {
            return r.getLocation().toString();
        }
        String n = r.getFullPath().toString();
        if (n.charAt(0) == '/') {
            return n.substring(1);
        }
        return n;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                ResourceCompareInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                if (this.fDiffViewer != null) {
                    this.fDiffViewer.refresh();
                }
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    ResourceCompareInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            IFile[] files;
            NullProgressMonitor pm = new NullProgressMonitor();
            this.flushViewers((IProgressMonitor)pm);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IFile;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((files = (IFile[])this.getAdapter(clazz2)) != null && files.length > 0) {
                return files[0];
            }
            return null;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IFile;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            HashSet collector = new HashSet();
            this.collectDirtyResources(this.fRoot, collector);
            return collector.toArray(new IFile[collector.size()]);
        }
        return super.getAdapter(adapter);
    }

    private void collectDirtyResources(Object o, Set collector) {
        if (o instanceof DiffNode) {
            IDiffElement[] children;
            IResource resource;
            BufferedResourceNode bn;
            ITypedElement right;
            IResource resource2;
            BufferedResourceNode bn2;
            DiffNode node = (DiffNode)o;
            ITypedElement left = node.getLeft();
            if (left instanceof BufferedResourceNode && (bn2 = (BufferedResourceNode)left).isDirty() && (resource2 = bn2.getResource()) instanceof IFile) {
                collector.add(resource2);
            }
            if ((right = node.getRight()) instanceof BufferedResourceNode && (bn = (BufferedResourceNode)right).isDirty() && (resource = bn.getResource()) instanceof IFile) {
                collector.add(resource);
            }
            if ((children = node.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    IDiffElement element = children[i];
                    if (element instanceof DiffNode) {
                        this.collectDirtyResources(element, collector);
                    }
                    ++i;
                }
            }
        }
    }

    private static String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    public boolean canRunAsJob() {
        return true;
    }

    static class FilteredBufferedResourceNode
    extends BufferedResourceNode {
        FilteredBufferedResourceNode(IResource resource) {
            super(resource);
        }

        protected IStructureComparator createChild(IResource child) {
            String name = child.getName();
            if (CompareUIPlugin.getDefault().filter(name, child instanceof IContainer, false)) {
                return null;
            }
            return new FilteredBufferedResourceNode(child);
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty = false;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
            ResourceCompareInput.this.setDirty(true);
            this.fDirty = true;
            if (ResourceCompareInput.this.fDiffViewer != null) {
                ResourceCompareInput.this.fDiffViewer.refresh(this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return String.valueOf('<') + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }

    class SelectAncestorDialog
    extends MessageDialog {
        private IResource[] theResources;
        IResource ancestorResource;
        IResource leftResource;
        IResource rightResource;
        private Button[] buttons;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ SelectAncestorDialog this$1;
            {
                this.this$1 = selectAncestorDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button selectedButton = (Button)e.widget;
                if (!selectedButton.getSelection()) {
                    return;
                }
                int i = 0;
                while (i < 3) {
                    if (selectedButton == SelectAncestorDialog.access$0(this.this$1)[i]) {
                        SelectAncestorDialog.access$1(this.this$1, i);
                    }
                    ++i;
                }
            }
        };

        public SelectAncestorDialog(Shell parentShell, IResource[] theResources) {
            super(parentShell, CompareMessages.SelectAncestorDialog_title, null, CompareMessages.SelectAncestorDialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.theResources = theResources;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.buttons = new Button[3];
            int i = 0;
            while (i < 3) {
                this.buttons[i] = new Button(composite, 16);
                this.buttons[i].addSelectionListener(this.selectionListener);
                this.buttons[i].setText(NLS.bind((String)CompareMessages.SelectAncestorDialog_option, (Object)this.theResources[i].getFullPath().toPortableString()));
                this.buttons[i].setFont(parent.getFont());
                this.buttons[i].setSelection(i == 0);
                ++i;
            }
            this.pickAncestor(0);
            return composite;
        }

        private void pickAncestor(int i) {
            this.ancestorResource = this.theResources[i];
            this.leftResource = this.theResources[i == 0 ? 1 : 0];
            this.rightResource = this.theResources[i == 2 ? 1 : 2];
        }

        static /* synthetic */ Button[] access$0(SelectAncestorDialog selectAncestorDialog) {
            return selectAncestorDialog.buttons;
        }

        static /* synthetic */ void access$1(SelectAncestorDialog selectAncestorDialog, int n) {
            selectAncestorDialog.pickAncestor(n);
        }
    }
}

