/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.ActivityPersistanceHelper;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.LocalWorkingSetManager;
import org.eclipse.ui.internal.MakeHandlersGo;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.SelectionConversionService;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchIntroManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ActiveContextSourceProvider;
import org.eclipse.ui.internal.contexts.ContextService;
import org.eclipse.ui.internal.contexts.WorkbenchContextSupport;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.help.WorkbenchHelpSystem;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.menus.FocusControlSourceProvider;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.model.ContributionService;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.services.EvaluationService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.MenuSourceProvider;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.ServiceLocatorCreator;
import org.eclipse.ui.internal.services.SourceProviderService;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.splash.EclipseSplashHandler;
import org.eclipse.ui.internal.splash.SplashHandlerFactory;
import org.eclipse.ui.internal.testing.WorkbenchTestable;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.tweaklets.GrabFocus;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.IContributionService;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workbench
extends EventManager
implements IWorkbench {
    public static final String EARLY_STARTUP_FAMILY = "earlyStartup";
    static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private static WorkbenchTestable testableObject;
    private static boolean createSplash;
    private static AbstractSplashHandler splash;
    private Display display;
    private EditorHistory editorHistory;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private boolean windowsClosed = false;
    private int returnCode = 2;
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    private final ServiceLocator serviceLocator;
    private int progressCount = -1;
    private ListenerList workbenchListeners = new ListenerList(1);
    private ServiceRegistration workbenchService;
    private MApplication application;
    private IEclipseContext e4Context;
    private IEventBroker eventBroker;
    boolean initializationDone = false;
    private static ServiceTracker instanceAppContext;
    private ArrayList<MCommand> commandsToRemove = new ArrayList();
    private ArrayList<MCategory> categoriesToRemove = new ArrayList();
    private Map<String, MBindingContext> bindingContexts = new HashMap<String, MBindingContext>();
    private WorkbenchActivitySupport workbenchActivitySupport;
    private WorkbenchCommandSupport workbenchCommandSupport;
    private WorkbenchContextSupport workbenchContextSupport;
    private BindingManager bindingManager;
    private CommandManager commandManager;
    private ContextManager contextManager;
    private ActivityPersistanceHelper activityHelper;
    private WorkbenchIntroManager introManager;
    private IntroDescriptor introDescriptor;
    private IExtensionTracker tracker;
    private IRegistryChangeListener startupRegistryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.ui", "startup");
            if (deltas.length == 0) {
                return;
            }
            String disabledPlugins = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            int i = 0;
            while (i < deltas.length) {
                IExtension extension = deltas[i].getExtension();
                if (deltas[i].getKind() != 2 && disabledPlugins.indexOf(extension.getNamespace()) == -1) {
                    SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                }
                ++i;
            }
        }
    };
    private String factoryID;
    private MenuSourceProvider menuSourceProvider;

    static {
        createSplash = true;
    }

    private Workbench(Display display, WorkbenchAdvisor advisor, MApplication app, IEclipseContext appContext) {
        StartupThreading.setWorkbench(this);
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.Workbench_CreatingWorkbenchTwice);
        }
        Assert.isNotNull((Object)display);
        Assert.isNotNull((Object)advisor);
        this.advisor = advisor;
        this.display = display;
        this.application = app;
        this.e4Context = appContext;
        instance = this;
        this.eventBroker = (IEventBroker)this.e4Context.get(IEventBroker.class.getName());
        appContext.set(this.getClass().getName(), (Object)this);
        appContext.set(IWorkbench.class.getName(), (Object)this);
        this.extensionEventHandler = new ExtensionEventHandler(this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        ServiceLocatorCreator slc = new ServiceLocatorCreator();
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(null, null, new IDisposable(){

            public void dispose() {
                Display display = Workbench.this.getDisplay();
                if (display != null && !display.isDisposed()) {
                    MessageDialog.openInformation(null, (String)WorkbenchMessages.Workbench_NeedsClose_Title, (String)WorkbenchMessages.Workbench_NeedsClose_Message);
                    Workbench.this.close(1, true);
                }
            }
        });
        this.serviceLocator.setContext(appContext);
        this.serviceLocator.registerService(IServiceLocatorCreator.class, slc);
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.services.IWorkbench", this, null, null, null, null, 0));
    }

    public static final Workbench getInstance() {
        return instance;
    }

    public static final int createAndRunWorkbench(final Display display, final WorkbenchAdvisor advisor) {
        final int[] returnCode = new int[1];
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                ULocale.setDefault((ULocale)new ULocale(String.valueOf(Platform.getNL()) + Platform.getNLExtensions()));
                System.setProperty("applicationXMI", "org.eclipse.ui.workbench/LegacyIDE.e4xmi");
                Object obj = Workbench.getApplication(Platform.getCommandLineArgs());
                if (obj instanceof E4Application) {
                    E4Application e4app = (E4Application)obj;
                    E4Workbench e4Workbench = e4app.createE4Workbench(Workbench.getApplicationContext(), display);
                    IEclipseContext workbenchContext = e4Workbench.getContext();
                    workbenchContext.set(Display.class, (Object)display);
                    Workbench workbench = new Workbench(display, advisor, e4Workbench.getApplication(), e4Workbench.getContext(), null);
                    returnCode[0] = workbench.runUI();
                    e4Workbench.createAndRunUI((MApplicationElement)e4Workbench.getApplication());
                    WorkbenchMenuService wms = (WorkbenchMenuService)e4Workbench.getContext().get(IMenuService.class);
                    wms.dispose();
                    e4app.saveModel();
                    e4Workbench.close();
                    returnCode[0] = workbench.returnCode;
                }
            }
        });
        return returnCode[0];
    }

    static IApplicationContext getApplicationContext() {
        if (instanceAppContext == null) {
            instanceAppContext = new ServiceTracker(WorkbenchPlugin.getDefault().getBundleContext(), IApplicationContext.class.getName(), null);
            instanceAppContext.open();
        }
        return (IApplicationContext)instanceAppContext.getService();
    }

    static Object getApplication(String[] args) {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", "org.eclipse.e4.ui.workbench.swt.E4Application");
        Assert.isNotNull((Object)extension);
        try {
            Object runnable;
            IConfigurationElement[] runs;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && ((runnable = runs[0].createExecutableExtension("class")) instanceof IPlatformRunnable || runnable instanceof IApplication)) {
                return runnable;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Display createDisplay() {
        Display newDisplay;
        String applicationName = WorkbenchPlugin.getDefault().getAppName();
        if (applicationName != null) {
            Display.setAppName((String)applicationName);
        }
        if ((newDisplay = Display.getCurrent()) == null) {
            if (Policy.DEBUG_SWT_GRAPHICS || Policy.DEBUG_SWT_DEBUG) {
                DeviceData data = new DeviceData();
                if (Policy.DEBUG_SWT_GRAPHICS) {
                    data.tracking = true;
                }
                if (Policy.DEBUG_SWT_DEBUG) {
                    data.debug = true;
                }
                newDisplay = new Display(data);
            } else {
                newDisplay = new Display();
            }
        }
        newDisplay.setWarnings(false);
        Thread.currentThread().setPriority(Math.min(10, 6));
        Workbench.initializeImages();
        return newDisplay;
    }

    private void createSplashWrapper() {
        final Display display = this.getDisplay();
        String splashLoc = System.getProperty("org.eclipse.equinox.launcher.splash.location");
        final Image background = this.loadImage(splashLoc);
        SafeRunnable run = new SafeRunnable(){

            public void run() throws Exception {
                if (!WorkbenchPlugin.isSplashHandleSpecified()) {
                    createSplash = false;
                    return;
                }
                Workbench.getSplash();
                if (splash == null) {
                    createSplash = false;
                    return;
                }
                Shell splashShell = splash.getSplash();
                if (splashShell == null) {
                    splashShell = WorkbenchPlugin.getSplashShell(display);
                    if (splashShell == null) {
                        return;
                    }
                    if (background != null) {
                        splashShell.setBackgroundImage(background);
                    }
                }
                Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
                ((Dictionary)properties).put("service.ranking", new Integer(Integer.MAX_VALUE));
                BundleContext context = WorkbenchPlugin.getDefault().getBundleContext();
                final ServiceRegistration[] registration = new ServiceRegistration[1];
                StartupMonitor startupMonitor = new StartupMonitor(){

                    public void applicationRunning() {
                        splash.dispose();
                        if (background != null) {
                            background.dispose();
                        }
                        registration[0].unregister();
                        WorkbenchPlugin.unsetSplashShell(display);
                    }

                    public void update() {
                    }
                };
                registration[0] = context.registerService(StartupMonitor.class.getName(), (Object)startupMonitor, properties);
                splash.init(splashShell);
            }

            public void handleException(Throwable e) {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Could not instantiate splash", e));
                createSplash = false;
                splash = null;
                if (background != null) {
                    background.dispose();
                }
            }
        };
        SafeRunner.run((ISafeRunnable)run);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image loadImage(String splashLoc) {
        Image background = null;
        if (splashLoc == null) return background;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(splashLoc));
            background = new Image((Device)this.display, input);
        }
        catch (SWTException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, e));
            if (input == null) return background;
            try {
                input.close();
                return background;
            }
            catch (IOException iOException) {}
            return background;
        }
        catch (IOException e) {
            try {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, e));
                if (input == null) return background;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
                return background;
            }
            catch (IOException iOException) {}
            return background;
        }
        if (input == null) return background;
        try {
            input.close();
            return background;
        }
        catch (IOException iOException) {}
        return background;
    }

    private static AbstractSplashHandler getSplash() {
        if (!createSplash) {
            return null;
        }
        if (splash == null) {
            IProduct product = Platform.getProduct();
            if (product != null) {
                splash = SplashHandlerFactory.findSplashHandlerFor(product);
            }
            if (splash == null) {
                splash = new EclipseSplashHandler();
            }
        }
        return splash;
    }

    public static WorkbenchTestable getWorkbenchTestable() {
        if (testableObject == null) {
            testableObject = new WorkbenchTestable();
        }
        return testableObject;
    }

    @Override
    public void addWorkbenchListener(IWorkbenchListener listener) {
        this.workbenchListeners.add((Object)listener);
    }

    @Override
    public void removeWorkbenchListener(IWorkbenchListener listener) {
        this.workbenchListeners.remove((Object)listener);
    }

    boolean firePreShutdown(final boolean forced) {
        Object[] list = this.workbenchListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWorkbenchListener l = (IWorkbenchListener)list[i];
            final boolean[] result = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    result[0] = l.preShutdown(Workbench.this, forced);
                }
            });
            if (!result[0]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void firePostShutdown() {
        Object[] list = this.workbenchListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWorkbenchListener l = (IWorkbenchListener)list[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.postShutdown(Workbench.this);
                }
            });
            ++i;
        }
    }

    @Override
    public void addWindowListener(IWindowListener l) {
        this.addListenerObject(l);
    }

    @Override
    public void removeWindowListener(IWindowListener l) {
        this.removeListenerObject(l);
    }

    protected void fireWindowOpened(final IWorkbenchWindow window) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowOpened(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow window) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowClosed(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow window) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowActivated(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow window) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowDeactivated(window);
                }
            });
            ++i;
        }
    }

    private boolean busyClose(final boolean force) {
        boolean closeEditors;
        this.isClosing = this.advisor.preShutdown();
        if (!force && !this.isClosing) {
            return false;
        }
        this.isClosing = this.firePreShutdown(force);
        if (!force && !this.isClosing) {
            return false;
        }
        this.isClosing = this.saveAllEditors(!force, true);
        if (!force && !this.isClosing) {
            return false;
        }
        boolean bl = closeEditors = !force && PrefUtil.getAPIPreferenceStore().getBoolean("CLOSE_EDITORS_ON_EXIT");
        if (closeEditors) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            Workbench.this.isClosing = Workbench.this.isClosing && pages[j].closeAllEditors(false);
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            if (!force && !this.isClosing) {
                return false;
            }
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        List<EditorReference> editorReferences = ((WorkbenchPage)pages[j]).getInternalEditorReferences();
                        ArrayList<EditorReference> referencesToClose = new ArrayList<EditorReference>();
                        for (EditorReference reference : editorReferences) {
                            IEditorPart editor = reference.getEditor(false);
                            if (editor == null || reference.persist()) continue;
                            referencesToClose.add(reference);
                        }
                        for (EditorReference reference : referencesToClose) {
                            ((WorkbenchPage)pages[j]).closeEditor(reference);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IViewReference[] references = pages[j].getViewReferences();
                        int k = 0;
                        while (k < references.length) {
                            if (references[k].getView(false) != null) {
                                ((ViewReference)references[k]).persist();
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        if (!force && !this.isClosing) {
            return false;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                if (Workbench.this.isClosing || force) {
                    E4Util.unsupported("Need to close since no windowManager");
                    MWindow selectedWindow = (MWindow)Workbench.this.application.getSelectedElement();
                    WorkbenchWindow selected = null;
                    IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.this.getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        WorkbenchWindow ww = (WorkbenchWindow)window;
                        if (ww.getModel() == selectedWindow) {
                            selected = ww;
                        } else {
                            ((WorkbenchWindow)window).close(false);
                        }
                        ++n2;
                    }
                    if (selected != null) {
                        selected.close(false);
                    }
                    Workbench.this.windowsClosed = true;
                }
            }
        });
        if (!force && !this.isClosing) {
            return false;
        }
        this.shutdown();
        IPresentationEngine engine = (IPresentationEngine)this.application.getContext().get(IPresentationEngine.class);
        engine.stop();
        this.runEventLoop = false;
        return true;
    }

    @Override
    public boolean saveAllEditors(boolean confirm) {
        return this.saveAllEditors(confirm, false);
    }

    private boolean saveAllEditors(boolean confirm, boolean closing) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            if (page != null && !((WorkbenchPage)page).saveAllEditors(confirm, closing)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean close() {
        return this.close(0, false);
    }

    boolean close(int returnCode, final boolean force) {
        this.returnCode = returnCode;
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = Workbench.this.busyClose(force);
            }
        });
        return ret[0];
    }

    @Override
    public IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() == null || !this.initializationDone) {
            return null;
        }
        if (this.windowsClosed) {
            return null;
        }
        if (this.e4Context.get(IPresentationEngine.class) == null) {
            return null;
        }
        MWindow activeWindow = (MWindow)this.application.getSelectedElement();
        if (activeWindow == null && !this.application.getChildren().isEmpty()) {
            activeWindow = (MWindow)this.application.getChildren().get(0);
        }
        return this.createWorkbenchWindow(this.getDefaultPageInput(), this.getPerspectiveRegistry().findPerspectiveWithId(this.getDefaultPerspectiveId()), activeWindow, false);
    }

    IWorkbenchWindow createWorkbenchWindow(IAdaptable input, IPerspectiveDescriptor descriptor, MWindow window, boolean newWindow) {
        WorkbenchWindow result;
        IEclipseContext windowContext = window.getContext();
        if (windowContext == null) {
            windowContext = E4Workbench.initializeContext((IEclipseContext)this.e4Context, (MContext)window);
            E4Workbench.processHierarchy((Object)window);
        }
        if ((result = (WorkbenchWindow)windowContext.get(IWorkbenchWindow.class.getName())) == null) {
            result = new WorkbenchWindow(input, descriptor);
            if (newWindow) {
                Point size = result.getWindowConfigurer().getInitialSize();
                window.setWidth(size.x);
                window.setHeight(size.y);
                this.application.getChildren().add(window);
                this.application.setSelectedElement((MUIElement)window);
            }
            ContextInjectionFactory.inject((Object)result, (IEclipseContext)windowContext);
            windowContext.set(IWorkbenchWindow.class.getName(), (Object)result);
            if (this.application.getSelectedElement() == window) {
                this.application.getContext().set("activeWorkbenchWindow", (Object)result);
                this.application.getContext().set("activeWorkbenchWindowShell", (Object)result.getShell());
            }
            this.fireWindowOpened(result);
            result.fireWindowOpened();
        }
        return result;
    }

    public EditorHistory getEditorHistory() {
        if (this.editorHistory == null) {
            this.editorHistory = new EditorHistory();
        }
        return this.editorHistory;
    }

    @Override
    public IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    @Override
    public IWorkbenchOperationSupport getOperationSupport() {
        return WorkbenchPlugin.getDefault().getOperationSupport();
    }

    @Override
    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    @Override
    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    @Override
    public int getWorkbenchWindowCount() {
        return this.getWorkbenchWindows().length;
    }

    @Override
    public IWorkbenchWindow[] getWorkbenchWindows() {
        ArrayList<IWorkbenchWindow> windows = new ArrayList<IWorkbenchWindow>();
        for (MWindow window : this.application.getChildren()) {
            IWorkbenchWindow wwindow;
            IEclipseContext context = window.getContext();
            if (context == null || (wwindow = (IWorkbenchWindow)context.get(IWorkbenchWindow.class.getName())) == null) continue;
            windows.add(wwindow);
        }
        return windows.toArray(new IWorkbenchWindow[windows.size()]);
    }

    @Override
    public IWorkingSetManager getWorkingSetManager() {
        return WorkbenchPlugin.getDefault().getWorkingSetManager();
    }

    @Override
    public ILocalWorkingSetManager createLocalWorkingSetManager() {
        return new LocalWorkingSetManager(WorkbenchPlugin.getDefault().getBundleContext());
    }

    private boolean init() {
        this.application.getContext().set("activeEditorId", (Object)new ActiveWorkbenchWindowQueryContextFunction("activeEditorId"));
        this.application.getContext().set("activeEditor", (Object)new ActiveWorkbenchWindowQueryContextFunction("activeEditor"));
        this.application.getContext().set("activeEditorInput", (Object)new ActiveWorkbenchWindowQueryContextFunction("activeEditorInput"));
        this.application.getContext().set("showInInput", (Object)new ActiveWorkbenchWindowQueryContextFunction("showInInput"));
        this.application.getContext().set("showInSelection", (Object)new ActiveWorkbenchWindowQueryContextFunction("showInSelection"));
        this.application.getContext().set("activePart", (Object)new ActiveWorkbenchWindowQueryContextFunction("activePart"));
        this.application.getContext().set("activePartId", (Object)new ActiveWorkbenchWindowQueryContextFunction("activePartId"));
        this.application.getContext().set("activeSite", (Object)new ActiveWorkbenchWindowQueryContextFunction("activeSite"));
        this.application.getContext().set("org.eclipse.core.runtime.Platform", Platform.class);
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        JFaceUtil.initializeJFacePreferences();
        final EvaluationService evaluationService = new EvaluationService(this.e4Context);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Workbench.this.serviceLocator.registerService(IEvaluationService.class, evaluationService);
            }
        });
        this.initializeLazyServices();
        this.activityHelper = ActivityPersistanceHelper.getInstance();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                WorkbenchImages.getImageRegistry();
            }
        });
        this.initializeE4Services();
        this.initializeDefaultServices();
        this.initializeFonts();
        this.initializeColors();
        this.initializeApplicationColors();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Workbench.this.advisor.internalBasicInitialize(Workbench.this.getWorkbenchConfigurer());
            }
        });
        boolean useColorIcons = PrefUtil.getInternalPreferenceStore().getBoolean("COLOR_ICONS");
        ActionContributionItem.setUseColorIconsInToolbars((boolean)useColorIcons);
        this.initializeSingleClickOption();
        this.initializeWorkbenchImages();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                ((GrabFocus)Tweaklets.get(GrabFocus.KEY)).init(Workbench.this.getDisplay());
            }
        });
        try {
            UIStats.start(4, "Workbench");
            final boolean[] bail = new boolean[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    Workbench.this.advisor.preStartup();
                    Workbench.this.initializationDone = true;
                    if (Workbench.this.isClosing()) {
                        bail[0] = true;
                    }
                }
            });
            if (bail[0]) {
                return false;
            }
        }
        finally {
            UIStats.end(4, this, "Workbench");
        }
        return true;
    }

    private void initializeWorkbenchImages() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                WorkbenchImages.getDescriptors();
            }
        });
    }

    private void initializeCommandResolver() {
        ExternalActionManager.getInstance().setCallback((ExternalActionManager.ICallback)new ExternalActionManager.CommandCallback(this.bindingManager, this.commandManager, new ExternalActionManager.IActiveChecker(){

            public final boolean isActive(String commandId) {
                return Workbench.this.workbenchActivitySupport.getActivityManager().getIdentifier(commandId).isEnabled();
            }
        }, new ExternalActionManager.IExecuteApplicable(){

            public boolean isApplicable(IAction action) {
                return !(action instanceof CommandAction);
            }
        }));
    }

    private void initializeApplicationColors() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                ColorDefinition[] colorDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getColors();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), colorDefinitions, PrefUtil.getInternalPreferenceStore());
            }
        });
    }

    private void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private void initializeFonts() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                FontDefinition[] fontDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getCurrentTheme(), fontDefinitions, PrefUtil.getInternalPreferenceStore());
            }
        });
    }

    private static void initializeImages() {
        ImageDescriptor[] windowImages = WorkbenchPlugin.getDefault().getWindowImages();
        if (windowImages == null) {
            return;
        }
        Image[] images = new Image[windowImages.length];
        int i = 0;
        while (i < windowImages.length) {
            images[i] = windowImages[i].createImage();
            ++i;
        }
        Window.setDefaultImages((Image[])images);
    }

    private void uninitializeImages() {
        WorkbenchImages.dispose();
        Image[] images = Window.getDefaultImages();
        Window.setDefaultImage(null);
        int i = 0;
        while (i < images.length) {
            images[i].dispose();
            ++i;
        }
    }

    private void initializeColors() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                WorkbenchColors.startup();
            }
        });
    }

    @Override
    public boolean isClosing() {
        return this.isClosing;
    }

    private final void initializeE4Services() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), new EventHandler(){

            public void handleEvent(Event event) {
                IWorkbenchWindow wwindow;
                MWindow window;
                IEclipseContext windowContext;
                if (Workbench.this.application == event.getProperty("ChangedElement") && "REMOVE".equals(event.getProperty("EventType")) && (windowContext = (window = (MWindow)event.getProperty("OldValue")).getContext()) != null && (wwindow = (IWorkbenchWindow)windowContext.get(IWorkbenchWindow.class.getName())) != null) {
                    Workbench.this.fireWindowClosed(wwindow);
                }
            }
        });
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), new EventHandler(){

            public void handleEvent(Event event) {
                IWorkbenchWindow wwindow;
                MWindow window;
                if (Workbench.this.application == event.getProperty("ChangedElement") && "SET".equals(event.getProperty("EventType")) && (window = (MWindow)event.getProperty("NewValue")) != null && (wwindow = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class.getName())) != null) {
                    Workbench.this.e4Context.set("activeWorkbenchWindow", (Object)wwindow);
                    Workbench.this.e4Context.set("activeWorkbenchWindowShell", (Object)wwindow.getShell());
                }
            }
        });
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), new EventHandler(){

            public void handleEvent(Event event) {
                Object element;
                if (Boolean.TRUE.equals(event.getProperty("NewValue")) && (element = event.getProperty("ChangedElement")) instanceof MPart) {
                    MPart part = (MPart)element;
                    Workbench.this.createReference(part);
                }
            }
        });
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Context", (String)"context"), new EventHandler(){

            public void handleEvent(Event event) {
                MPart part;
                IEclipseContext context;
                Object element = event.getProperty("ChangedElement");
                if (element instanceof MPart && (context = (part = (MPart)element).getContext()) != null) {
                    Workbench.this.setReference(part, context);
                }
            }
        });
        MPartDescriptor descriptor = BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.getTags().add("Editor");
        descriptor.setCloseable(true);
        descriptor.setAllowMultiple(true);
        descriptor.setElementId("org.eclipse.e4.ui.compatibility.editor");
        descriptor.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor");
        descriptor.setCategory("org.eclipse.e4.primaryDataStack");
        this.application.getDescriptors().add(descriptor);
        WorkbenchPlugin.getDefault().getViewRegistry();
    }

    private WorkbenchPage getWorkbenchPage(MPart part) {
        IEclipseContext context = this.getWindowContext(part);
        WorkbenchPage page = (WorkbenchPage)context.get(IWorkbenchPage.class.getName());
        if (page == null) {
            MWindow window = (MWindow)context.get(MWindow.class.getName());
            Workbench workbench = (Workbench)PlatformUI.getWorkbench();
            workbench.openWorkbenchWindow(this.getDefaultPageInput(), this.getPerspectiveRegistry().findPerspectiveWithId(this.getDefaultPerspectiveId()), window, false);
            page = (WorkbenchPage)context.get(IWorkbenchPage.class.getName());
        }
        return page;
    }

    private void setReference(MPart part, IEclipseContext context) {
        String uri = part.getContributionURI();
        if ("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(uri)) {
            WorkbenchPage page = this.getWorkbenchPage(part);
            ViewReference ref = page.getViewReference(part);
            if (ref == null) {
                ref = this.createViewReference(part, page);
            }
            context.set(ViewReference.class.getName(), (Object)ref);
        } else if ("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor".equals(uri)) {
            WorkbenchPage page = this.getWorkbenchPage(part);
            EditorReference ref = page.getEditorReference(part);
            if (ref == null) {
                ref = this.createEditorReference(part, page);
            }
            context.set(EditorReference.class.getName(), (Object)ref);
        }
    }

    private ViewReference createViewReference(MPart part, WorkbenchPage page) {
        WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
        IViewDescriptor desc = window.getWorkbench().getViewRegistry().find(part.getElementId());
        ViewReference ref = new ViewReference(window.getModel().getContext(), page, part, (ViewDescriptor)desc);
        page.addViewReference(ref);
        return ref;
    }

    private EditorReference createEditorReference(MPart part, WorkbenchPage page) {
        WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
        EditorReference ref = new EditorReference(window.getModel().getContext(), page, part, null, null, null);
        page.addEditorReference(ref);
        return ref;
    }

    private void createReference(MPart part) {
        WorkbenchPage page;
        EditorReference ref;
        String uri = part.getContributionURI();
        if ("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(uri)) {
            WorkbenchPage page2 = this.getWorkbenchPage(part);
            ViewReference ref2 = page2.getViewReference(part);
            if (ref2 == null) {
                this.createViewReference(part, page2);
            }
        } else if ("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor".equals(uri) && (ref = (page = this.getWorkbenchPage(part)).getEditorReference(part)) == null) {
            this.createEditorReference(part, page);
        }
    }

    private IEclipseContext getWindowContext(MPart part) {
        MElementContainer parent = (MElementContainer)((EObject)part).eContainer();
        while (!(parent instanceof MWindow)) {
            parent = (MElementContainer)((EObject)parent).eContainer();
        }
        return ((MWindow)parent).getContext();
    }

    private final void initializeLazyServices() {
        this.e4Context.set(IExtensionTracker.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (Workbench.this.tracker == null) {
                    Workbench.this.tracker = (IExtensionTracker)new UIExtensionTracker(Workbench.this.getDisplay());
                }
                return Workbench.this.tracker;
            }
        });
        this.e4Context.set(IWorkbenchActivitySupport.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (Workbench.this.workbenchActivitySupport == null) {
                    Workbench.this.workbenchActivitySupport = new WorkbenchActivitySupport();
                }
                return Workbench.this.workbenchActivitySupport;
            }
        });
        this.e4Context.set(IProgressService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return ProgressManager.getInstance();
            }
        });
        WorkbenchPlugin.getDefault().initializeContext(this.e4Context);
    }

    private CommandService initializeCommandService(IEclipseContext appContext) {
        CommandService service = new CommandService(this.commandManager);
        appContext.set(ICommandService.class.getName(), (Object)service);
        service.readRegistry();
        MakeHandlersGo allHandlers = new MakeHandlersGo(this);
        Command[] cmds = this.commandManager.getAllCommands();
        int i = 0;
        while (i < cmds.length) {
            Command cmd = cmds[i];
            cmd.setHandler((IHandler)allHandlers);
            ++i;
        }
        return service;
    }

    public MBindingContext getBindingContext(String id) {
        MBindingContext result = this.bindingContexts.get(id);
        if (result == null) {
            result = this.searchContexts(id, this.application.getRootContext());
            if (result == null) {
                result = MCommandsFactory.INSTANCE.createBindingContext();
                result.setElementId(id);
                result.setName("Auto::" + id);
                this.application.getRootContext().add(result);
            }
            this.bindingContexts.put(id, result);
        }
        return result;
    }

    private MBindingContext searchContexts(String id, List<MBindingContext> rootContext) {
        for (MBindingContext context : rootContext) {
            if (context.getElementId().equals(id)) {
                return context;
            }
            MBindingContext result = this.searchContexts(id, context.getChildren());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void defineBindingTable(String id) {
        List bindingTables = this.application.getBindingTables();
        if (this.contains(bindingTables, id)) {
            return;
        }
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.log("Defining a binding table: " + id);
        }
        MBindingTable bt = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        bt.setBindingContext(this.getBindingContext(id));
        bindingTables.add(bt);
    }

    private boolean contains(List<MBindingTable> bindingTables, String id) {
        for (MBindingTable bt : bindingTables) {
            if (!id.equals(bt.getBindingContext().getElementId())) continue;
            return true;
        }
        return false;
    }

    private final void initializeDefaultServices() {
        IContextService cxs;
        ContributionService contributionService = new ContributionService(this.getAdvisor());
        this.serviceLocator.registerService(IContributionService.class, contributionService);
        final IEvaluationService evaluationService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Workbench.this.serviceLocator.registerService(ISaveablesLifecycleListener.class, new SaveablesList());
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Command.DEBUG_COMMAND_EXECUTION = Policy.DEBUG_COMMANDS;
                Workbench.this.commandManager = (CommandManager)Workbench.this.e4Context.get(CommandManager.class);
            }
        });
        final CommandService[] commandService = new CommandService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                commandService[0] = Workbench.this.initializeCommandService(Workbench.this.e4Context);
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                ContextManager.DEBUG = Policy.DEBUG_CONTEXTS;
                Workbench.this.contextManager = (ContextManager)Workbench.this.e4Context.get(ContextManager.class);
            }
        });
        final IContextService contextService = cxs = (IContextService)ContextInjectionFactory.make(ContextService.class, (IEclipseContext)this.e4Context);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Workbench.this.contextManager.addContextManagerListener(new IContextManagerListener(){

                    public void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
                        String id;
                        if (contextManagerEvent.isContextChanged() && (id = contextManagerEvent.getContextId()) != null) {
                            Workbench.this.defineBindingTable(id);
                        }
                    }
                });
                EContextService ecs = (EContextService)Workbench.this.e4Context.get(EContextService.class);
                ecs.activateContext("org.eclipse.ui.contexts.dialogAndWindow");
            }
        });
        this.serviceLocator.registerService(IContextService.class, contextService);
        final IBindingService[] bindingService = new BindingService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                BindingManager.DEBUG = Policy.DEBUG_KEY_BINDINGS;
                Workbench.this.bindingManager = new BindingManager(Workbench.this.contextManager, Workbench.this.commandManager);
                Workbench.this.serviceLocator.registerService(BindingManager.class, Workbench.this.bindingManager);
                bindingService[0] = (IBindingService)ContextInjectionFactory.make(BindingService.class, (IEclipseContext)Workbench.this.e4Context);
            }
        });
        bindingService[0].readRegistryAndPreferences(commandService[0]);
        this.serviceLocator.registerService(IBindingService.class, bindingService[0]);
        CommandImageManager commandImageManager = new CommandImageManager();
        CommandImageService commandImageService = new CommandImageService(commandImageManager, commandService[0]);
        commandImageService.readRegistry();
        this.serviceLocator.registerService(ICommandImageService.class, commandImageService);
        final WorkbenchMenuService menuService = new WorkbenchMenuService(this.serviceLocator, this.e4Context);
        this.serviceLocator.registerService(IMenuService.class, menuService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                menuService.readRegistry();
            }
        });
        final SourceProviderService sourceProviderService = new SourceProviderService(this.serviceLocator);
        this.serviceLocator.registerService(ISourceProviderService.class, sourceProviderService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                sourceProviderService.readRegistry();
                ISourceProvider[] sp = sourceProviderService.getSourceProviders();
                int i = 0;
                while (i < sp.length) {
                    evaluationService.addSourceProvider(sp[i]);
                    if (!(sp[i] instanceof ActiveContextSourceProvider)) {
                        contextService.addSourceProvider(sp[i]);
                    }
                    ++i;
                }
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                FocusControlSourceProvider focusControl = (FocusControlSourceProvider)sourceProviderService.getSourceProvider("activeFocusControlId");
                Workbench.this.serviceLocator.registerService(IFocusService.class, focusControl);
                Workbench.this.menuSourceProvider = (MenuSourceProvider)sourceProviderService.getSourceProvider("activeMenu");
            }
        });
        final IHandlerService[] handlerService = new IHandlerService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() {
                handlerService[0] = new LegacyHandlerService(Workbench.this.e4Context);
                Workbench.this.e4Context.set(IHandlerService.class.getName(), (Object)handlerService[0]);
                handlerService[0].readRegistry();
            }
        });
        this.workbenchContextSupport = new WorkbenchContextSupport(this, this.contextManager);
        this.workbenchCommandSupport = new WorkbenchCommandSupport(this.bindingManager, this.commandManager, this.contextManager, handlerService[0]);
        this.initializeCommandResolver();
        this.serviceLocator.registerService(ISelectionConversionService.class, new SelectionConversionService());
    }

    @Override
    public boolean isStarting() {
        return this.isStarting && this.isRunning();
    }

    void forceOpenPerspective() {
        if (this.getWorkbenchWindowCount() == 0) {
            return;
        }
        String perspId = null;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length - 1) {
            if (commandLineArgs[i].equalsIgnoreCase("-perspective")) {
                perspId = commandLineArgs[i + 1];
                break;
            }
            ++i;
        }
        if (perspId == null) {
            return;
        }
        IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspId);
        if (desc == null) {
            return;
        }
        IWorkbenchWindow win = this.getActiveWorkbenchWindow();
        if (win == null) {
            win = this.getWorkbenchWindows()[0];
        }
        final String threadPerspId = perspId;
        final IWorkbenchWindow threadWin = win;
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() throws Throwable {
                try {
                    Workbench.this.showPerspective(threadPerspId, threadWin);
                }
                catch (WorkbenchException e) {
                    String msg = "Workbench exception showing specified command line perspective on startup.";
                    WorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)((Object)e)));
                }
            }
        });
    }

    void openFirstTimeWindow() {
        boolean showProgress = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_PROGRESS_ON_STARTUP");
        if (!showProgress) {
            this.doOpenFirstTimeWindow();
        } else {
            int expectedProgressCount = Math.max(1, WorkbenchPlugin.getDefault().getBundleCount() / 10);
            this.runStartupWithProgress(expectedProgressCount, new Runnable(){

                public void run() {
                    Workbench.this.doOpenFirstTimeWindow();
                }
            });
        }
    }

    private void doOpenFirstTimeWindow() {
        try {
            final IAdaptable[] input = new IAdaptable[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    input[0] = Workbench.this.getDefaultPageInput();
                }
            });
            this.openWorkbenchWindow(this.getDefaultPerspectiveId(), input[0]);
        }
        catch (WorkbenchException e) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            });
        }
    }

    private void runStartupWithProgress(int expectedProgressCount, Runnable runnable) {
        this.progressCount = 0;
        AbstractSplashHandler handler = Workbench.getSplash();
        IProgressMonitor progressMonitor = null;
        if (handler != null) {
            progressMonitor = handler.getBundleProgressMonitor();
        }
        if (progressMonitor == null) {
            runnable.run();
        } else {
            progressMonitor.beginTask("", expectedProgressCount);
            StartupProgressBundleListener bundleListener = new StartupProgressBundleListener(progressMonitor, (int)((double)expectedProgressCount * 0.95));
            WorkbenchPlugin.getDefault().addBundleListener((BundleListener)bundleListener);
            try {
                runnable.run();
                progressMonitor.subTask(WorkbenchMessages.Startup_Done);
                int remainingWork = expectedProgressCount - Math.min(this.progressCount, (int)((double)expectedProgressCount * 0.95));
                progressMonitor.worked(remainingWork);
                progressMonitor.done();
            }
            finally {
                WorkbenchPlugin.getDefault().removeBundleListener((BundleListener)bundleListener);
            }
        }
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getDefaultPerspectiveId(), input);
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(String perspectiveId, IAdaptable input) throws WorkbenchException {
        IPerspectiveDescriptor descriptor = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (descriptor == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
        }
        try {
            MTrimmedWindow window = org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
            return this.openWorkbenchWindow(input, descriptor, (MWindow)window, true);
        }
        catch (InjectionException e) {
            throw new WorkbenchException(e.getMessage(), e);
        }
    }

    public WorkbenchWindow openWorkbenchWindow(IAdaptable input, IPerspectiveDescriptor descriptor, MWindow window, boolean newWindow) {
        return (WorkbenchWindow)this.createWorkbenchWindow(input, descriptor, window, newWindow);
    }

    @Override
    public boolean restart() {
        return this.close(1, false);
    }

    public String[] getEarlyActivatedPlugins() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] extensions = point.getExtensions();
        ArrayList<String> pluginIds = new ArrayList<String>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            String id = extensions[i].getNamespace();
            if (!pluginIds.contains(id)) {
                pluginIds.add(id);
            }
            ++i;
        }
        return pluginIds.toArray(new String[pluginIds.size()]);
    }

    public String[] getDisabledEarlyActivatedPlugins() {
        String pref = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        return Util.getArrayFromList(pref, ";");
    }

    private void startPlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui", "startup");
        final IExtension[] extensions = point.getExtensions();
        if (extensions.length == 0) {
            return;
        }
        Job job = new Job("Workbench early startup"){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet<String> disabledPlugins = new HashSet<String>(Arrays.asList(Workbench.this.getDisabledEarlyActivatedPlugins()));
                monitor.beginTask(WorkbenchMessages.Workbench_startingPlugins, extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    if (monitor.isCanceled() || !Workbench.this.isRunning()) {
                        return Status.CANCEL_STATUS;
                    }
                    IExtension extension = extensions[i];
                    if (!disabledPlugins.contains(extension.getNamespace())) {
                        monitor.subTask(extension.getNamespace());
                        SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return Workbench.EARLY_STARTUP_FAMILY.equals(family);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private int runUI() {
        UISynchronizer synchronizer;
        UIStats.start(5, "Workbench");
        boolean avoidDeadlock = true;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-allowDeadlock")) {
                avoidDeadlock = false;
            }
            ++i;
        }
        if (avoidDeadlock) {
            UILockListener uiLockListener = new UILockListener(this.display);
            Job.getJobManager().setLockListener((LockListener)uiLockListener);
            synchronizer = new UISynchronizer(this.display, uiLockListener);
            this.display.setSynchronizer((Synchronizer)synchronizer);
            UISynchronizer.startupThread.set(Boolean.TRUE);
        } else {
            synchronizer = null;
        }
        if (createSplash) {
            this.createSplashWrapper();
        }
        ModalContext.setAllowReadAndDispatch((boolean)false);
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (Workbench.this.isStarting()) {
                        WorkbenchPlugin.log(StatusUtil.newStatus(2, "Event loop should not be run while the Workbench is starting.", (Throwable)new RuntimeException()));
                    }
                }
            });
        }
        Listener closeListener = new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                event.doit = Workbench.this.close();
            }
        };
        ExceptionHandler handler = ExceptionHandler.getInstance();
        try {
            this.display.addListener(21, closeListener);
            Window.setExceptionHandler((Window.IExceptionHandler)handler);
            final boolean[] initOK = new boolean[1];
            if (Workbench.getSplash() != null) {
                final boolean[] initDone = new boolean[1];
                final Throwable[] error = new Throwable[1];
                Thread initThread = new Thread(){

                    public void run() {
                        try {
                            try {
                                UISynchronizer.startupThread.set(Boolean.TRUE);
                                initOK[0] = Workbench.this.init();
                            }
                            catch (Throwable e) {
                                error[0] = e;
                                initDone[0] = true;
                                Workbench.this.display.wake();
                            }
                        }
                        finally {
                            initDone[0] = true;
                            Workbench.this.display.wake();
                        }
                    }
                };
                initThread.start();
                while (true) {
                    if (this.display.readAndDispatch()) {
                        continue;
                    }
                    if (initDone[0]) break;
                    this.display.sleep();
                }
                Throwable throwable = error[0];
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new Error(throwable);
                }
            } else {
                initOK[0] = this.init();
            }
            if (initOK[0]) {
                this.advisor.postStartup();
            }
            if (initOK[0] && this.runEventLoop) {
                this.workbenchService = WorkbenchPlugin.getDefault().getBundleContext().registerService(IWorkbench.class.getName(), (Object)this, null);
                this.startPlugins();
                this.addStartupRegistryListener();
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        UIStats.end(5, this, "Workbench");
                        UIStats.startupComplete();
                    }
                });
                Workbench.getWorkbenchTestable().init(this.display, this);
                ModalContext.setAllowReadAndDispatch((boolean)true);
                this.isStarting = false;
                if (synchronizer != null) {
                    synchronizer.started();
                }
            }
            this.returnCode = 0;
        }
        catch (Exception e) {
            if (!this.display.isDisposed()) {
                handler.handleException(e);
            }
            String msg = "Exception in Workbench.runUI after display was disposed";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, (Throwable)e));
        }
        return this.returnCode;
    }

    @Override
    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
        return this.showPerspective(perspectiveId, window, null);
    }

    private boolean activate(String perspectiveId, IWorkbenchPage page, IAdaptable input, boolean checkPerspective) {
        if (page != null) {
            IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getOpenPerspectives();
            int n = iPerspectiveDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPerspectiveDescriptor openedPerspective = iPerspectiveDescriptorArray[n2];
                if ((!checkPerspective || openedPerspective.getId().equals(perspectiveId)) && page.getInput() == input) {
                    WorkbenchWindow wwindow = (WorkbenchWindow)page.getWorkbenchWindow();
                    MWindow model = wwindow.getModel();
                    this.application.setSelectedElement((MUIElement)model);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow targetWindow, IAdaptable input) throws WorkbenchException {
        IWorkbenchPage page;
        Assert.isNotNull((Object)perspectiveId);
        IPerspectiveDescriptor targetPerspective = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (targetPerspective == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
        }
        if (targetWindow != null && this.activate(perspectiveId, page = targetWindow.getActivePage(), input, true)) {
            return page;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page2 = window.getActivePage();
            if (this.activate(perspectiveId, page2, input, true)) {
                return page2;
            }
            ++n2;
        }
        if (targetWindow != null) {
            page = targetWindow.getActivePage();
            if (this.activate(perspectiveId, page, input, false)) {
                return page;
            }
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
            if (2 != mode) {
                targetWindow.getShell().open();
                if (page == null) {
                    page = targetWindow.openPage(perspectiveId, input);
                } else {
                    page.setPerspective(targetPerspective);
                }
                return page;
            }
        }
        return this.openWorkbenchWindow(perspectiveId, input).getActivePage();
    }

    private void shutdown() {
        try {
            this.advisor.postShutdown();
        }
        catch (Exception ex) {
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Exceptions during shutdown", (Throwable)ex));
        }
        this.firePostShutdown();
        this.workbenchListeners.clear();
        this.cancelEarlyStartup();
        if (this.workbenchService != null) {
            this.workbenchService.unregister();
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.startupRegistryListener);
        ((GrabFocus)Tweaklets.get(GrabFocus.KEY)).dispose();
        this.serviceLocator.dispose();
        this.application.getCommands().removeAll(this.commandsToRemove);
        this.application.getCategories().removeAll(this.categoriesToRemove);
        this.workbenchActivitySupport.dispose();
        WorkbenchHelpSystem.disposeIfNecessary();
        WorkbenchColors.shutdown();
        this.activityHelper.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        WorkbenchThemeManager.getInstance().dispose();
        PropertyPageContributorManager.getManager().dispose();
        ObjectActionContributorManager.getManager().dispose();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private void cancelEarlyStartup() {
        Job.getJobManager().cancel((Object)EARLY_STARTUP_FAMILY);
    }

    @Override
    public IDecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        String defaultId = this.getPerspectiveRegistry().getDefaultPerspective();
        return defaultId == null ? this.getAdvisor().getInitialWindowPerspectiveId() : defaultId;
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        String id = this.getAdvisor().getMainPreferencePageId();
        return id;
    }

    @Override
    public IElementFactory getElementFactory(String factoryId) {
        Assert.isNotNull((Object)factoryId);
        return WorkbenchPlugin.getDefault().getElementFactory(factoryId);
    }

    @Override
    public IProgressService getProgressService() {
        return (IProgressService)this.e4Context.get(IProgressService.class.getName());
    }

    @Override
    public IWorkbenchActivitySupport getActivitySupport() {
        return (IWorkbenchActivitySupport)this.e4Context.get(IWorkbenchActivitySupport.class.getName());
    }

    @Override
    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    @Override
    public IWorkbenchContextSupport getContextSupport() {
        return this.workbenchContextSupport;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    @Override
    public IIntroManager getIntroManager() {
        return this.getWorkbenchIntroManager();
    }

    WorkbenchIntroManager getWorkbenchIntroManager() {
        if (this.introManager == null) {
            this.introManager = new WorkbenchIntroManager(this);
        }
        return this.introManager;
    }

    public IntroDescriptor getIntroDescriptor() {
        return this.introDescriptor;
    }

    public void setIntroDescriptor(IntroDescriptor descriptor) {
        if (this.getIntroManager().getIntro() != null) {
            this.getIntroManager().closeIntro(this.getIntroManager().getIntro());
        }
        this.introDescriptor = descriptor;
    }

    @Override
    public IThemeManager getThemeManager() {
        return WorkbenchThemeManager.getInstance();
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public String getPresentationId() {
        if (this.factoryID != null) {
            return this.factoryID;
        }
        this.factoryID = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        if (this.factoryID == null || this.factoryID.equals("")) {
            this.factoryID = "org.eclipse.ui.presentations.default";
        }
        return this.factoryID;
    }

    public final void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            IWorkbenchWindow[] windows = this.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateStart();
                }
                ++i;
            }
        }
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            IWorkbenchWindow[] windows = this.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateEnd();
                }
                ++i;
            }
        }
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        return (IExtensionTracker)this.e4Context.get(IExtensionTracker.class.getName());
    }

    private void addStartupRegistryListener() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(this.startupRegistryListener);
    }

    @Override
    public IWorkbenchHelpSystem getHelpSystem() {
        return WorkbenchHelpSystem.getInstance();
    }

    @Override
    public IWorkbenchBrowserSupport getBrowserSupport() {
        return WorkbenchBrowserSupport.getInstance();
    }

    @Override
    public IViewRegistry getViewRegistry() {
        return WorkbenchPlugin.getDefault().getViewRegistry();
    }

    @Override
    public IWizardRegistry getNewWizardRegistry() {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry();
    }

    @Override
    public IWizardRegistry getImportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getImportWizardRegistry();
    }

    @Override
    public IWizardRegistry getExportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getExportWizardRegistry();
    }

    public final Object getAdapter(Class key) {
        return this.serviceLocator.getService(key);
    }

    @Override
    public final Object getService(Class key) {
        return this.serviceLocator.getService(key);
    }

    @Override
    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public final void registerService(Class api, Object service) {
        this.serviceLocator.registerService(api, service);
    }

    public final void addShowingMenus(Set menuIds, ISelection localSelection, ISelection localEditorInput) {
        this.menuSourceProvider.addShowingMenus(menuIds, localSelection, localEditorInput);
        Map currentState = this.menuSourceProvider.getCurrentState();
        String[] stringArray = this.menuSourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.e4Context.set(key, currentState.get(key));
            ++n2;
        }
    }

    public final void removeShowingMenus(Set menuIds, ISelection localSelection, ISelection localEditorInput) {
        this.menuSourceProvider.removeShowingMenus(menuIds, localSelection, localEditorInput);
        String[] stringArray = this.menuSourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.e4Context.remove(key);
            ++n2;
        }
    }

    @Override
    public boolean saveAll(IShellProvider shellProvider, IRunnableContext runnableContext, ISaveableFilter filter, boolean confirm) {
        HashMap<Saveable, HashSet<IWorkbenchPart>> map = new HashMap<Saveable, HashSet<IWorkbenchPart>>();
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorReferences;
            int n3;
            IViewReference[] viewReferences;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n4 = viewReferences.length;
            int n5 = 0;
            while (n5 < n4) {
                IViewReference reference = iViewReferenceArray[n5];
                IWorkbenchPart part = reference.getPart(false);
                if (part instanceof ISaveablesSource) {
                    Saveable[] saveables;
                    Saveable[] saveableArray = saveables = ((ISaveablesSource)((Object)part)).getSaveables();
                    n3 = saveables.length;
                    int n6 = 0;
                    while (n6 < n3) {
                        Saveable saveable = saveableArray[n6];
                        if (saveable.isDirty()) {
                            HashSet<IWorkbenchPart> parts = (HashSet<IWorkbenchPart>)map.get(saveable);
                            if (parts == null) {
                                parts = new HashSet<IWorkbenchPart>();
                                map.put(saveable, parts);
                            }
                            parts.add(part);
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n7 = editorReferences.length;
            n4 = 0;
            while (n4 < n7) {
                IEditorReference reference = iEditorReferenceArray[n4];
                IWorkbenchPart part = reference.getPart(false);
                if (part instanceof ISaveablesSource) {
                    Saveable[] saveables;
                    Saveable[] saveableArray = saveables = ((ISaveablesSource)((Object)part)).getSaveables();
                    int n8 = saveables.length;
                    n3 = 0;
                    while (n3 < n8) {
                        Saveable saveable = saveableArray[n3];
                        if (saveable.isDirty()) {
                            HashSet<IWorkbenchPart> parts = (HashSet<IWorkbenchPart>)map.get(saveable);
                            if (parts == null) {
                                parts = new HashSet<IWorkbenchPart>();
                                map.put(saveable, parts);
                            }
                            parts.add(part);
                        }
                        ++n3;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<Saveable> toSave = new ArrayList<Saveable>();
        for (Map.Entry entrySet : map.entrySet()) {
            Set parts;
            Saveable saveable = (Saveable)entrySet.getKey();
            if (!filter.select(saveable, (parts = (Set)entrySet.getValue()).toArray(new IWorkbenchPart[parts.size()]))) continue;
            toSave.add(saveable);
        }
        if (toSave.isEmpty()) {
            return true;
        }
        SaveablesList saveablesList = (SaveablesList)this.getService(ISaveablesLifecycleListener.class);
        if (!confirm) {
            return !saveablesList.saveModels(toSave, shellProvider, runnableContext);
        }
        return !saveablesList.promptForSaving(toSave, shellProvider, runnableContext, true, false);
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Override
    public IShellProvider getModalDialogShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return ProgressManagerUtil.getDefaultParent();
            }
        };
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }

    public MApplication getApplication() {
        return this.application;
    }

    /* synthetic */ Workbench(Display display, WorkbenchAdvisor workbenchAdvisor, MApplication mApplication, IEclipseContext iEclipseContext, Workbench workbench) {
        this(display, workbenchAdvisor, mApplication, iEclipseContext);
    }

    class ActiveWorkbenchWindowQueryContextFunction
    implements IContextFunction {
        private final String variable;

        public ActiveWorkbenchWindowQueryContextFunction(String variable) {
            this.variable = variable;
        }

        public Object compute(IEclipseContext context) {
            IEclipseContext child = context.getActiveChild();
            return child == null ? null : child.getLocal(this.variable);
        }
    }

    private final class StartupProgressBundleListener
    implements SynchronousBundleListener {
        private final IProgressMonitor progressMonitor;
        private final int maximumProgressCount;
        private final List starting;

        StartupProgressBundleListener(IProgressMonitor progressMonitor, int maximumProgressCount) {
            this.progressMonitor = progressMonitor;
            this.maximumProgressCount = maximumProgressCount;
            this.starting = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            String bundleName;
            int eventType = event.getType();
            StartupProgressBundleListener startupProgressBundleListener = this;
            synchronized (startupProgressBundleListener) {
                if (eventType == 128) {
                    bundleName = event.getBundle().getSymbolicName();
                    this.starting.add(bundleName);
                } else if (eventType == 2) {
                    int index;
                    Workbench workbench = Workbench.this;
                    workbench.progressCount = workbench.progressCount + 1;
                    if (Workbench.this.progressCount <= this.maximumProgressCount) {
                        this.progressMonitor.worked(1);
                    }
                    if ((index = this.starting.lastIndexOf(event.getBundle().getSymbolicName())) >= 0) {
                        this.starting.remove(index);
                    }
                    if (index != this.starting.size()) {
                        return;
                    }
                    bundleName = index == 0 ? null : (String)this.starting.get(index - 1);
                } else {
                    return;
                }
            }
            String taskName = bundleName == null ? WorkbenchMessages.Startup_Loading_Workbench : NLS.bind((String)WorkbenchMessages.Startup_Loading, (Object)bundleName);
            this.progressMonitor.subTask(taskName);
        }
    }
}

