/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLInsertionComputer;

public class NewElementAction
extends Action {
    public static final String UNKNOWN_ELEMENT_TAG = PDEUIMessages.NewElementAction_generic;
    private ISchemaElement elementInfo;
    private IPluginParent parent;

    public NewElementAction(ISchemaElement elementInfo, IPluginParent parent) {
        this.elementInfo = elementInfo;
        this.parent = parent;
        this.setText(this.getElementName());
        this.setImageDescriptor(PDEPluginImages.DESC_GENERIC_XML_OBJ);
        this.setEnabled(parent.getModel().isEditable());
    }

    private String getElementName() {
        return this.elementInfo != null ? this.elementInfo.getName() : UNKNOWN_ELEMENT_TAG;
    }

    public void run() {
        IPluginElement newElement = this.parent.getModel().getFactory().createElement((IPluginObject)this.parent);
        try {
            newElement.setName(this.getElementName());
            ((PluginElementNode)newElement).setParentNode((IDocumentElementNode)this.parent);
            if (this.elementInfo != null) {
                XMLInsertionComputer.computeInsertion(this.elementInfo, (IPluginParent)newElement);
            }
            this.parent.add((IPluginObject)newElement);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

