/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.parsers.ICSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.converters.CSSValueBooleanConverterImpl;
import org.eclipse.e4.ui.css.core.dom.properties.providers.CSSPropertyHandlerLazyProviderImpl;
import org.eclipse.e4.ui.css.core.dom.properties.providers.CSSPropertyHandlerSimpleProviderImpl;
import org.eclipse.e4.ui.css.core.impl.engine.AbstractCSSEngine;
import org.eclipse.e4.ui.css.core.impl.sac.CSSConditionFactoryImpl;
import org.eclipse.e4.ui.css.core.impl.sac.CSSSelectorFactoryImpl;
import org.w3c.css.sac.ConditionFactory;

public abstract class CSSEngineImpl
extends AbstractCSSEngine {
    public static final ConditionFactory CONDITIONFACTORY_INSTANCE = new CSSConditionFactoryImpl(null, "class", null, "id");
    private CSSPropertyHandlerSimpleProviderImpl handlerProvider = null;
    private CSSPropertyHandlerLazyProviderImpl lazyHandlerProvider = null;

    public CSSEngineImpl() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.u.css.core.elementProvider");
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                String tmp = ce.getName();
                if (tmp.equals("provider")) {
                    try {
                        Object tmp2 = ce.createExecutableExtension("class");
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement ce2 = iConfigurationElementArray2[n6];
                            String widget = ce2.getAttribute("class");
                            this.widgetsMap.put(widget, tmp2);
                            ++n6;
                        }
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        super.registerCSSValueConverter(CSSValueBooleanConverterImpl.INSTANCE);
    }

    public CSSEngineImpl(ExtendedDocumentCSS documentCSS) {
        super(documentCSS);
        super.registerCSSValueConverter(CSSValueBooleanConverterImpl.INSTANCE);
    }

    public CSSParser makeCSSParser() {
        ICSSParserFactory factory = CSSParserFactory.newInstance();
        CSSParser parser = factory.makeCSSParser();
        parser.setSelectorFactory(CSSSelectorFactoryImpl.INSTANCE);
        parser.setConditionFactory(CONDITIONFACTORY_INSTANCE);
        return parser;
    }

    public void registerCSSPropertyHandler(Class cl, ICSSPropertyHandler handler) {
        this.initHandlerProviderIfNeed();
        this.handlerProvider.registerCSSPropertyHandler(cl, handler);
    }

    private void initHandlerProviderIfNeed() {
        if (this.handlerProvider == null) {
            this.handlerProvider = new CSSPropertyHandlerSimpleProviderImpl();
            super.registerCSSPropertyHandlerProvider(this.handlerProvider);
        }
    }

    public void registerCSSProperty(String propertyName, Class propertyHandlerClass) {
        this.initHandlerProviderIfNeed();
        this.handlerProvider.registerCSSProperty(propertyName, propertyHandlerClass);
    }

    private void initLazyHandlerProviderIfNeed() {
        if (this.lazyHandlerProvider == null) {
            this.lazyHandlerProvider = new CSSPropertyHandlerLazyProviderImpl();
            super.registerCSSPropertyHandlerProvider(this.lazyHandlerProvider);
        }
    }

    public void registerPackage(String packageName) {
        this.initLazyHandlerProviderIfNeed();
        this.lazyHandlerProvider.registerPackage(packageName);
    }
}

