/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerUpdate;

class MarkersChangeListener
implements IResourceChangeListener {
    private ExtendedMarkersView view;
    private CachedMarkerBuilder builder;
    private String[] listeningTypes;
    private boolean receiving;
    private long preBuildTime;

    MarkersChangeListener(ExtendedMarkersView view, CachedMarkerBuilder builder) {
        this.view = view;
        this.builder = builder;
        this.listeningTypes = new String[0];
    }

    synchronized void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 25);
    }

    synchronized void stop() {
        if (this.listeningTypes != null) {
            this.listeningTypes = new String[0];
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    boolean workspaceBuilding() {
        return this.preBuildTime > 0L;
    }

    void listenToTypes(String[] typeIds, boolean includeSubTypes) {
        try {
            this.listeningTypes = includeSubTypes ? MarkerResourceUtil.getAllSubTypesIds(typeIds) : typeIds;
        }
        catch (Exception e) {
            MarkerSupportInternalUtilities.logViewError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void resourceChanged(IResourceChangeEvent event) {
        this.setReceivingChange(true);
        try {
            if (event.getType() == 8) {
                this.preBuild();
                return;
            }
            if (event.getType() == 16) {
                this.postBuild();
                this.builder.getUpdateScheduler().speedUpPendingUpdates();
                return;
            }
            if (!this.hasApplicableTypes(event)) {
                return;
            }
            if (!this.builder.isIncremental()) {
                this.handleMarkerChange(event);
                return;
            }
            this.handleIncrementalChange(event);
            return;
        }
        finally {
            this.setReceivingChange(false);
        }
    }

    boolean isReceivingChange() {
        return this.receiving;
    }

    void setReceivingChange(boolean receiving) {
        this.receiving = receiving;
    }

    private void handleMarkerChange(IResourceChangeEvent event) {
        this.builder.getUpdateScheduler().scheduleUpdate();
    }

    private void handleNoMarkerChange() {
    }

    private void handleIncrementalChange(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        if (markerDeltas.length == 0) {
            return;
        }
        LinkedList<MarkerEntry> removed = new LinkedList<MarkerEntry>();
        LinkedList<MarkerEntry> added = new LinkedList<MarkerEntry>();
        LinkedList<MarkerEntry> changed = new LinkedList<MarkerEntry>();
        String[] types = this.listeningTypes;
        int i = 0;
        while (i < markerDeltas.length) {
            try {
                String typeId = markerDeltas[i].getType();
                if (this.isApplicableType(types, typeId)) {
                    IMarker marker = markerDeltas[i].getMarker();
                    MarkerEntry markerEntry = new MarkerEntry(marker);
                    switch (markerDeltas[i].getKind()) {
                        case 2: {
                            removed.add(markerEntry);
                            break;
                        }
                        case 1: {
                            added.add(markerEntry);
                            break;
                        }
                        case 4: {
                            changed.add(markerEntry);
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                MarkerSupportInternalUtilities.logViewError(e);
            }
            ++i;
        }
        if (removed.size() > 0 || added.size() > 0 || changed.size() > 0) {
            MarkerUpdate update = new MarkerUpdate(added, removed, changed);
            this.builder.incrementalUpdate(update);
            this.builder.getUpdateScheduler().scheduleUpdate();
        } else {
            this.handleNoMarkerChange();
        }
    }

    private boolean hasApplicableTypes(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        String[] types = this.listeningTypes;
        if (types.length == 0) {
            return false;
        }
        int i = 0;
        while (i < markerDeltas.length) {
            if (this.isApplicableType(types, markerDeltas[i].getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isApplicableType(String[] types, String typeId) {
        int i = 0;
        while (i < types.length) {
            if (types[i].equals(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void preBuild() {
        this.preBuildTime = System.currentTimeMillis();
    }

    private void postBuild() {
        this.preBuildTime = -1L;
    }

    ExtendedMarkersView getView() {
        return this.view;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }
}

