/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private TemplateEngine fEngine;

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        ICompilationUnit unit = javaContext.getCompilationUnit();
        if (unit == null) {
            return Collections.emptyList();
        }
        this.fEngine = this.computeCompletionEngine(javaContext);
        if (this.fEngine == null) {
            return Collections.emptyList();
        }
        this.fEngine.reset();
        this.fEngine.complete(javaContext.getViewer(), javaContext.getInvocationOffset(), unit);
        TemplateProposal[] templateProposals = this.fEngine.getResults();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>(Arrays.asList(templateProposals));
        IJavaCompletionProposal[] keyWordResults = javaContext.getKeywordProposals();
        if (keyWordResults.length == 0) {
            return result;
        }
        int k = 0;
        while (k < templateProposals.length) {
            TemplateProposal curr = templateProposals[k];
            String name = curr.getTemplate().getPattern();
            int i = 0;
            while (i < keyWordResults.length) {
                String content;
                String keyword = keyWordResults[i].getDisplayString();
                if (name.startsWith(keyword) && (content = curr.getTemplate().getPattern()).startsWith(keyword)) {
                    curr.setRelevance(keyWordResults[i].getRelevance() + 1);
                    break;
                }
                ++i;
            }
            ++k;
        }
        return result;
    }

    protected abstract TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext var1);

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        if (this.fEngine != null) {
            this.fEngine.reset();
            this.fEngine = null;
        }
    }
}

