/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaModelUtil {
    public static final boolean HIDE_VERSION_1_7 = true;
    public static final String DEFAULT_CU_SUFFIX = ".java";

    public static IJavaElement findTypeContainer(IJavaProject jproject, String typeContainerName) throws JavaModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = types[i].getTypeQualifiedName('.');
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && otherpack != null && JavaModelUtil.isSamePackage(pack, otherpack);
    }

    public static boolean isVisibleInHierarchy(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || Flags.isProtected((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethod findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IMethod res;
        IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        if (!isConstructor) {
            IType[] superInterfaces = hierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(hierarchy, superInterfaces[i], name, paramTypes, false);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return method;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSamePackage(IPackageFragment pack1, IPackageFragment pack2) {
        return pack1.getElementName().equals(pack2.getElementName());
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isMainMethod()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static boolean isInterfaceOrAnnotation(IType type) throws JavaModelException {
        return type.isInterface();
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        Assert.isNotNull((Object)cu);
        IResource resource = cu.getPrimary().getResource();
        return resource.exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean isPrimitive(String typeSignature) throws JavaModelException {
        return Signature.getTypeSignatureKind((String)Signature.getElementType((String)typeSignature)) == 2;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)((Object)exception);
        return !je.isDoesNotExist();
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaModelException {
        try {
            IType objekt;
            IType[] superTypes = SuperTypeHierarchyCache.getTypeHierarchy(type).getAllSupertypes(type);
            if (type.isInterface() && (objekt = type.getJavaProject().findType("java.lang.Object")) != null) {
                IType[] superInterfacesAndObject = new IType[superTypes.length + 1];
                System.arraycopy(superTypes, 0, superInterfacesAndObject, 0, superTypes.length);
                superInterfacesAndObject[superTypes.length] = objekt;
                IType[] iTypeArray = superInterfacesAndObject;
                return iTypeArray;
            }
            IType[] iTypeArray = superTypes;
            return iTypeArray;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (possibleSuperType.equals(superClass) || JavaModelUtil.isSuperType(hierarchy, possibleSuperType, superClass))) {
            return true;
        }
        if (Flags.isInterface((int)hierarchy.getCachedFlags(possibleSuperType))) {
            IType[] superInterfaces = hierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IType curr = superInterfaces[i];
                if (possibleSuperType.equals(curr) || JavaModelUtil.isSuperType(hierarchy, possibleSuperType, curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void reconcile(ICompilationUnit unit) throws JavaModelException {
        unit.reconcile(0, false, null, null);
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject jproject, IPath containerPath, IPath libPath) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateClasspathContainer(containerPath, jproject)) {
            return JavaModelUtil.findEntryInContainer(container, libPath);
        }
        return null;
    }

    public static IClasspathEntry findEntryInContainer(IClasspathContainer container, IPath libPath) {
        IClasspathEntry[] entries = container.getClasspathEntries();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr);
            if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static IClasspathEntry getClasspathEntry(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry rawEntry = root.getRawClasspathEntry();
        int rawEntryKind = rawEntry.getEntryKind();
        switch (rawEntryKind) {
            case 1: 
            case 4: 
            case 5: {
                if (!root.isArchive() || root.getKind() != 2) break;
                IClasspathEntry resolvedEntry = root.getResolvedClasspathEntry();
                if (resolvedEntry.getReferencingEntry() != null) {
                    return resolvedEntry;
                }
                return rawEntry;
            }
        }
        return rawEntry;
    }

    public static ICompilationUnit[] getAllCompilationUnits(IJavaElement[] javaElements) throws JavaModelException {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        int i = 0;
        while (i < javaElements.length) {
            JavaModelUtil.addAllCus(result, javaElements[i]);
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static void addAllCus(HashSet<ICompilationUnit> collector, IJavaElement javaElement) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 2: {
                IJavaProject javaProject = (IJavaProject)javaElement;
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    JavaModelUtil.addAllCus(collector, (IJavaElement)packageFragmentRoots[i]);
                    ++i;
                }
                return;
            }
            case 3: {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)javaElement;
                if (packageFragmentRoot.getKind() != 1) {
                    return;
                }
                IJavaElement[] packageFragments = packageFragmentRoot.getChildren();
                int j = 0;
                while (j < packageFragments.length) {
                    JavaModelUtil.addAllCus(collector, packageFragments[j]);
                    ++j;
                }
                return;
            }
            case 4: {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                collector.addAll(Arrays.asList(packageFragment.getCompilationUnits()));
                return;
            }
            case 5: {
                collector.add((ICompilationUnit)javaElement);
                return;
            }
        }
        IJavaElement cu = javaElement.getAncestor(5);
        if (cu != null) {
            collector.add((ICompilationUnit)cu);
        }
    }

    public static void set50ComplianceOptions(Map<String, String> map) {
        JavaModelUtil.setComplianceOptions(map, "1.5");
    }

    public static void setComplianceOptions(Map<String, String> map, String compliance) {
        JavaCore.setComplianceOptions((String)compliance, map);
    }

    public static void setDefaultClassfileOptions(Map<String, String> map, String compliance) {
        map.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", JavaModelUtil.is50OrHigher(compliance) ? "enabled" : "disabled");
        map.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        map.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        map.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        map.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        if ("cldc1.1".equals(version1)) {
            version1 = "1.1a";
        }
        if ("cldc1.1".equals(version2)) {
            version2 = "1.1a";
        }
        return version1.compareTo(version2) < 0;
    }

    public static boolean is50OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.5");
    }

    public static boolean is50OrHigher(IJavaProject project) {
        String source = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return JavaModelUtil.is50OrHigher(source);
    }

    public static boolean is50OrHigherJRE(IJavaProject project) throws CoreException {
        IVMInstall vmInstall = project == null ? JavaRuntime.getDefaultVMInstall() : JavaRuntime.getVMInstall((IJavaProject)project);
        if (!(vmInstall instanceof IVMInstall2)) {
            return true;
        }
        String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)vmInstall, null);
        if (compliance == null) {
            return true;
        }
        return compliance.startsWith("1.5") || compliance.startsWith("1.6") || compliance.startsWith("1.7");
    }

    public static String getCompilerCompliance(IVMInstall2 vMInstall, String defaultCompliance) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return defaultCompliance;
        }
        if (version.startsWith("1.7")) {
            return "1.6";
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3")) {
            return "1.3";
        }
        if (version.startsWith("1.2")) {
            return "1.3";
        }
        if (version.startsWith("1.1")) {
            return "1.3";
        }
        return defaultCompliance;
    }

    public static String getExecutionEnvironmentCompliance(IExecutionEnvironment executionEnvironment) {
        Object compliance;
        Map complianceOptions = executionEnvironment.getComplianceOptions();
        if (complianceOptions != null && (compliance = complianceOptions.get("org.eclipse.jdt.core.compiler.compliance")) instanceof String) {
            return (String)compliance;
        }
        String desc = executionEnvironment.getId();
        if (desc.indexOf("1.7") != -1) {
            return "1.6";
        }
        if (desc.indexOf("1.6") != -1) {
            return "1.6";
        }
        if (desc.indexOf("1.5") != -1) {
            return "1.5";
        }
        if (desc.indexOf("1.4") != -1) {
            return "1.4";
        }
        return "1.3";
    }

    public static String getRenamedCUName(ICompilationUnit cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }

    public static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        IFile file = (IFile)cu.getResource();
        if (!save || !file.exists()) {
            cu.applyTextEdit(edit, monitor);
        } else {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 2);
            try {
                IStatus status = Resources.makeCommittable((IResource)file, null);
                if (!status.isOK()) {
                    throw new ValidateEditException(status);
                }
                cu.applyTextEdit(edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
            }
            finally {
                monitor.done();
            }
        }
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        String mainTypeName = JavaModelUtil.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    public static boolean isOpenableStorage(Object storage) {
        if (storage instanceof IJarEntryResource) {
            return ((IJarEntryResource)storage).isFile();
        }
        return storage instanceof IStorage;
    }

    public static boolean isPackageInfo(ICompilationUnit cu) {
        return "package-info.java".equals(cu.getElementName());
    }
}

