/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.utils.SearchXMLGenerator;

public class SearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_PHRASE = "phrase";
    private QueryTooComplexException searchException;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response = this.processRequest(req, resp);
        if ("".equals(response)) {
            resp.sendError(400);
        } else {
            resp.getWriter().write(response);
        }
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BaseHelpSystem.checkMode();
        HitCollector collector = new HitCollector();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        String phrase = req.getParameter(PARAMETER_PHRASE);
        if (phrase != null) {
            phrase = URLCoder.decode((String)phrase);
            SearchQuery query = new SearchQuery(phrase, false, (Collection)Collections.EMPTY_LIST, locale);
            collector.results.clear();
            BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
            if (this.searchException == null) {
                return SearchServlet.serialize(collector.results);
            }
        }
        return "";
    }

    public static String serialize(Collection results) {
        return SearchXMLGenerator.serialize(results);
    }

    private final class HitCollector
    implements ISearchHitCollector {
        public Collection results = new ArrayList();

        private HitCollector() {
        }

        public void addHits(List hits, String wordsSearched) {
            if (this.results != null) {
                this.results.addAll(hits);
            }
        }

        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
            SearchServlet.this.searchException = exception;
        }
    }
}

