/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class MessageWizardPage
extends UserInputWizardPage {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_INFORMATION = 1;
    public static final int STYLE_QUESTION = 2;
    public static final int STYLE_ERROR = 3;
    public static final int STYLE_WARNING = 4;
    private final int fStyle;

    public MessageWizardPage(String pageName, boolean isLastUserPage, int style) {
        super(pageName);
        this.fStyle = style;
    }

    protected abstract String getMessageString();

    protected Image getMessageImage() {
        switch (this.fStyle) {
            case 3: {
                return Display.getCurrent().getSystemImage(1);
            }
            case 4: {
                return Display.getCurrent().getSystemImage(8);
            }
            case 1: {
                return Display.getCurrent().getSystemImage(2);
            }
            case 2: {
                return Display.getCurrent().getSystemImage(4);
            }
        }
        return null;
    }

    public void createControl(Composite parent) {
        String message;
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7) * 3 / 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4) * 2;
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Image image = this.getMessageImage();
        if (image != null) {
            Label label = new Label(result, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if ((message = this.getMessageString()) != null) {
            Label messageLabel = new Label(result, 64);
            messageLabel.setText(message);
            GridData data = new GridData(770);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            messageLabel.setLayoutData((Object)data);
            messageLabel.setFont(result.getFont());
        }
        Dialog.applyDialogFont((Control)result);
    }
}

